

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetContainerRptItems.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetContainerRptItems.sp,v $ $Id: sp_dm2_GetContainerRptItems.sp,v 1.12 2015/03/10 13:26:06 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetContainerRptItems <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetContainerRptItems')
	drop procedure sp_dm2_GetContainerRptItems
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetContainerRptItems')
	delete from GxQscripts where name = 'sp_dm2_GetContainerRptItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetContainerRptItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetContainerRptItems'
GO
print '... Creating Procedure: sp_dm2_GetContainerRptItems'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetContainerRptItems
  @inputXML xml
AS
BEGIN
  DECLARE @fromDate DateTime
  DECLARE @ToDate DateTime
  DECLARE @fromDateString varchar(20)
  DECLARE @ToDateString varchar(20)
  DECLARE @offset INT
  DECLARE @limit INT
  DECLARE @debug BIT
	SET NOCOUNT ON
	--should be 1 only for debugging purposes
	SET @debug = 0
	IF @debug = 1
	BEGIN
		SET @limit = 10
		SET @offset = 20
	END
	ELSE
	BEGIN
		SET @limit = @inputXML.value('(DM2ContentIndexing_GetContainersRptReq/pagingConfig/@limit)[1]', 'INT')
		SET @offset = @inputXML.value('(DM2ContentIndexing_GetContainersRptReq/pagingConfig/@offset)[1]', 'INT')
	END
	IF @limit <= 0
	BEGIN
		SET @limit = 1000
	END
	--Capture Inputs
	SET @fromDateString = @inputXML.value('(/DM2ContentIndexing_GetContainersRptReq/@fromTime)[1]', 'varchar(20)')
	SET @ToDateString = @inputXML.value('(/DM2ContentIndexing_GetContainersRptReq/@toTime)[1]', 'varchar(20)')
	SET @fromDate = dbo.GetDateTime(@fromDateString)
	SET @ToDate = dbo.GetDateTime(@ToDateString)
	--Input is UTC. We have been storing local time in DMContainerItem. So convert before compare..
    SELECT @fromDate = dbo.GetLocalTime(@fromDate), @ToDate = dbo.GetLocalTime(@ToDate)
	--DROP and create necessary temp tables..
	IF object_id('tempdb.dbo.#tblContainers') is not null
	DROP TABLE #tblContainers
	--IF object_id('tempdb.dbo.#tblGetContainerRptItem') is not null
	--DROP TABLE #tblGetContainerRptItem
	create table #tblContainers (ContainerID varchar(36), ContainerName nvarchar(MAX))
	--create table #tblGetContainerRptItem (
	--	rowId INT IDENTITY(1,1),
	--	ContainerID VARCHAR(36), ClientID INT, JobId INT, RestoreStatus INT, ERMStatus INT, BackupStatus INT,
	--	CreateTime VARCHAR(20), UserName VARCHAR(128), EmailOrFile VARCHAR(5), Conv VARCHAR(MAX)
	--)
	INSERT INTO #tblContainers
	SELECT T.item.value('@containerGuid', 'VARCHAR(36)') as ContainerID,
			T.item.value('@containerName', 'NVARCHAR(MAX)') as ContainerName
	FROM @inputxml.nodes('/DM2ContentIndexing_GetContainersRptReq/containers') T(item)
	DECLARE @CC INT
	SET @CC = (SELECT COUNT(*) FROM #tblContainers)
	SELECT ContainerID, ClientID, JobId, RestoreStatus, ERMStatus, BackupStatus, CreateTime, UserName, EmailOrFile, Conv FROM
	(
		SELECT *, /*ROW_NUMBER() OVER (ORDER BY DER.ContainerID, DER.CONV) AS ROWNUM,*/
				ROW_NUMBER() OVER (ORDER BY MUserName) AS URowNum
		FROM
		(
			SELECT DISTINCT I.ContainerID, U.ClientID, U.JobId, U.RestoreStatus, U.ERMStatus, LB.BackupStatus,
			CONVERT(CHAR(19), I.CreateTime, 20) AS CreateTime, S.UserName , (CASE WHEN P.IsEmailAppType = 1 THEN 'Email' ELSE 'File' END) AS EmailOrFile,
			(CASE WHEN P.IsEmailAppType = 1 THEN  U.Title  ELSE U.OriginalFullPath END)  AS Conv,
			U.ResultSetID AS ResultSetID,
			(SELECT ISNULL(ContainerName, '') FROM #tblContainers C WHERE I.ContainerID = C.ContainerId) AS ContainerName,
			(CASE CHARINDEX('\', S.UserName) WHEN 0 THEN S.UserName ELSE SUBSTRING(S.UserName, CHARINDEX('\', S.UserName) + 1, LEN(S.UserName) - CHARINDEX('\',S.UserName)) END) AS MUserName
			FROM DMContainerItem I  WITH (READUNCOMMITTED)
			INNER JOIN DMResultSet U WITH (READUNCOMMITTED) ON I.ResultSetID = U.ResultSetID  AND (I.Attribute & 4) != 4
			LEFT  JOIN DMUserSession S WITH (READUNCOMMITTED) ON I.UserGUID = S.UserGUID
			LEFT JOIN DMUIAppTypeMap P WITH (READUNCOMMITTED) ON U.AppType = P.AppTypeId
			LEFT JOIN DMLegalHoldItemsToBackup LB WITH (READUNCOMMITTED) ON LB.ResultSetID = U.ResultSetID -- and LB.JobId = U.JobId
			WHERE  dateadd(minute, datepart(TZoffset, sysdatetimeoffset()), I.CreateTime) < @ToDate and dateadd(minute, datepart(TZoffset, sysdatetimeoffset()), I.CreateTime) >= @fromDate
			and (@CC = 0 OR I.ContainerID in (select ContainerID from #tblContainers))
		) DER
	) TEMP
	WHERE TEMP.URowNum > @offset AND TEMP.URowNum <= @offset + @limit
	ORDER BY TEMP.MUserName, TEMP.ContainerName
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetContainerRptItems')
	delete from GxQscripts where name = 'sp_dm2_GetContainerRptItems'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetContainerRptItems')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetContainerRptItems'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetContainerRptItems',  '00010012000000000000', 'sp_dm2_GetContainerRptItems', '00010012000000000000')
GO

