

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_GetAuditValue.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_GetAuditValue.sp,v $ $Id: sp_dm2_GetAuditValue.sp,v 1.1 2011/05/17 11:07:03 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_GetAuditValue <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_GetAuditValue')
	drop procedure sp_dm2_GetAuditValue
IF EXISTS (select * from GxQscripts where name='sp_dm2_GetAuditValue')
	delete from GxQscripts where name = 'sp_dm2_GetAuditValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAuditValue')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAuditValue'
GO
print '... Creating Procedure: sp_dm2_GetAuditValue'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_GetAuditValue
  @inputXml XML 
AS
BEGIN
	--Local variables.
	DECLARE @userGuid VARCHAR(36)
	DECLARE @containerGuid VARCHAR(36)
	DECLARE @eventType INT
	DECLARE @eventId BIGINT
	DECLARE @resultSetTable TABLE( resultSetId VARCHAR(36));
	DECLARE @paramListTable TABLE( paramValue INT);
	--Assign local Value.
	SELECT @containerGuid = ISNULL(T.col.value('@containerGuid','VARCHAR(36)'),''),
			@userGuid = ISNULL(T.col.value('@userGuid','VARCHAR(36)'),''),
			@eventType = ISNULL(T.col.value('@type','INT'),0),
			@eventId = ISNULL(T.col.value('@eventId','INT'),0)
	FROM @inputXML.nodes('DM2ContentIndexing_AuditQueryRequest') AS T(col)
	--insert input resultSetIds
	INSERT INTO @resultSetTable
	SELECT T.col.value('@val','VARCHAR(36)')
	FROM @inputXML.nodes('DM2ContentIndexing_AuditQueryRequest/resultSetIds') AS T(col)
	--insert input paramList
	INSERT INTO @paramListTable
	SELECT T.col.value('@val','INT')
	FROM @inputXML.nodes('DM2ContentIndexing_AuditQueryRequest/paramList') AS T(col)
	;WITH CTE_EvntId AS
	(
		SELECT refEventId,A.ContainerGuid,A.UserGuid,Map.CreateTime,Map.ResultSetId,A.UserName
		FROM DMActionItemMap AS Map
			INNER JOIN
			DMAction AS A
		ON ( (@eventId > 0 AND A.EventId = @eventId AND  Map.refEventId = @eventId ) OR
			 (@eventId <= 0 AND A.EventId = Map.refEventId ))
		AND ResultSetId IN (SELECT resultSetId FROM @resultSetTable)
		AND ( @eventType = 0 OR A.EventType = @eventType)
			WHERE (LEN(@containerGuid) = 0 OR ContainerGuid = @containerGuid)
	)
	SELECT p.refEventId "eventId",CTE.ContainerGuid,CTE.ResultSetId,
		P.ParamId,P.ParamValue,CTE.UserGuid,CTE.UserName,CTE.CreateTime
	FROM DMActionParam AS P
		INNER JOIN
		CTE_EvntId AS CTE
	ON P.refEventId = CTE.refEventId AND P.ParamId in (SELECT T.paramValue FROM @paramListTable AS T)
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_GetAuditValue')
	delete from GxQscripts where name = 'sp_dm2_GetAuditValue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_GetAuditValue')
	delete from GXDBVersions where aliasname = 'sp_dm2_GetAuditValue'
GO

insert into GXDBVersions values(2, 'sp_dm2_GetAuditValue',  '00010001000000000000', 'sp_dm2_GetAuditValue', '00010001000000000000')
GO

