

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AuditOperation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AuditOperation.sp,v $ $Id: sp_dm2_AuditOperation.sp,v 1.4.60.1 2017/02/10 19:18:29 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AuditOperation <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AuditOperation')
	drop procedure sp_dm2_AuditOperation
IF EXISTS (select * from GxQscripts where name='sp_dm2_AuditOperation')
	delete from GxQscripts where name = 'sp_dm2_AuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AuditOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AuditOperation'
GO
print '... Creating Procedure: sp_dm2_AuditOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AuditOperation
  @inputXML nvarchar(MAX),
  @discardAnyOutput int = 0 --when this value is set as 1, output will not be returned
AS
SET NOCOUNT ON
/*******
			------------------------Sample XML------------------------
		<DM2ContentIndexing_EventOperation containerGuid="fa8b5408-352c-4a51-bb0f-e7599a677c7e" type="1" userGuid="1F1DE630-FD3F-41cc-A0D9-86B0C1E6CF1A" reuseRequestId="">
			<paramList paramValue="Search" paramName="11" />
			<paramList paramValue="b3b49890-1e04-46fc-bcca-05a260eb7d9b" paramName="1" />
			<resultSetIds val="01bfbf46-f887-4a8f-84c8-71bda85563ad" />
			<resultSetIds val="499fe66b-0257-48df-8f07-e74c6041ce2a" />
			<resultSetIds val="19c5b7c9-4d7b-4f67-a318-26007727473d" />
			<resultSetIds val="e55e2ad5-d12d-4336-8beb-d8231ddda098" />
			<resultSetIds val="a82a1540-8249-4f0a-8919-36c5f805d8a2" />
		</DM2ContentIndexing_EventOperation>
			------------------------ Description ------------------------
		1. if valid reuseRequestId is passed as the input then
			a. Check if any row exists with same value, then get its eventId
			b. Do Not create new entry in DMAction table.
			c. Goto 3
		2. else insert new row in DMAction table
			a. Query DMUserSession to get the userName
		3. Since we maintain the unique combination of EventId and ParamId in DMActionParam table.
		   a. So before inserting into DMActionParam table,
		   b. Check, if item exists --> Update with new value
					else --> insert new rows.
		4. Similar case while inserting into DMActionItemMap table.. DoNot insert if item exists.
			------------------------ Output ------------------------
		1. Error Object will be returned.
		2. On Success, ErrorCode - 0 And ErrorMessage - NO ERROR
		3. On failure, can be any of below.
			a. Userguid is empty
			b. EventType is not specified.
			c. Failure in insert/update
			d. Any foreign key violation
			e. Unknown exception
*******/
BEGIN
	-------Return variables-------
	DECLARE @o_errorCode INTEGER = 0,
			@o_errorString NVARCHAR(500) = 'NO ERROR'
	-------input values-------
	DECLARE @i_xml XML = '',
			@i_reuseRequestId VARCHAR(100) = '',
			@i_userGuid VARCHAR(36) = '',
			@i_containerGuid VARCHAR(36) = '',
			@i_eventType INTEGER = 0,
			@i_attribute INTEGER = 0,
			@i_debug INTEGER = 0
	------LocalVariables------
	DECLARE @refEventId BIGINT = 0,
			@userName NVARCHAR(256) = ''
	----------++++++++++Begin Transaction++++++++--------------
	BEGIN TRY
	BEGIN TRAN
		SET @i_xml = @inputXML
		SELECT @i_reuseRequestId = ISNULL(T.col.value('@reuseRequestId','VARCHAR(100)'),''),
				@i_userGuid = ISNULL(T.col.value('@userGuid','VARCHAR(36)'),''),
				@i_containerGuid = ISNULL(T.col.value('@containerGuid','VARCHAR(36)'),''),
				@i_eventType = ISNULL(T.col.value('@type','INTEGER'),0),
				@i_attribute = ISNULL(T.col.value('@attribute','INTEGER'),0),
				@i_debug = ISNULL(T.col.value('@debug','INTEGER'),0)
		FROM @i_xml.nodes('DM2ContentIndexing_EventOperation') as T(col)
		--Null checks
		IF @i_eventType = 0
		BEGIN
			SELECT @o_errorCode = 1, @o_errorString = 'EventType is not specified'
			GOTO EXIT_ERROR
		END
		IF @i_userGuid = ''
		BEGIN
			SELECT @o_errorCode = 2, @o_errorString = 'Invalid UserGuid..'
			GOTO EXIT_ERROR
		END
		----------Check if reuseRequestId exists.----------
		IF (LEN(@i_reuseRequestId) > 0 AND EXISTS (SELECT EventId FROM DMAction WHERE reuseRequestId = @i_reuseRequestId))
		BEGIN
			SELECT @refEventId = EventId FROM DMAction WHERE reuseRequestId = @i_reuseRequestId
			IF(@i_debug = 1)
				SELECT 'Exists',* FROM DMAction WHERE EventId = @refEventId
		END
		---------------------------------------------
			------- Insertion into DMAction ------
		---------------------------------------------
		IF (@refEventId = 0)
		BEGIN
			--Assign userName
			SELECT TOP 1 @userName = UserName FROM DMUserSession WHERE UserGUID = @i_userGuid
			--insert input i_reuseRequestId also, as next time when request comes with same reuseRequestId
			-- previous IF block will be executed and new insertion will not happen
			INSERT INTO DMAction (EventType,UserGuid,UserName,ContainerGuid,CreateTime,Attribute,reuseRequestId)
			VALUES (@i_eventType,@i_userGuid,@userName,@i_containerGuid,GETUTCDATE(),@i_attribute,@i_reuseRequestId)
			SELECT @o_errorCode = @@ERROR, @refEventId = @@IDENTITY
			IF(@o_errorCode != 0)
			BEGIN
				SELECT @o_errorString = 'ERROR While inserting into DMAction table'
				GOTO EXIT_ERROR
			END
			IF(@i_debug = 1)
				SELECT 'New',* FROM DMAction WHERE EventId = @refEventId
		END
		---------------------------------------------
		  ------ Insertion into DMActionParam ------
		---------------------------------------------
		---Now check if paramList exists
		IF ((SELECT T.col.exist('./paramList') FROM @i_xml.nodes('DM2ContentIndexing_EventOperation') AS T(col)) = 1)
		BEGIN
			MERGE DMActionParam  AS A
			USING (  SELECT ISNULL(T.col.value('@paramName','INTEGER'),0) AS "ParamId",
							ISNULL(T.col.value('@paramValue','NVARCHAR(MAX)'),'')  AS "ParamValue"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/paramList') AS T(col)
					WHERE ISNULL(T.col.value('@paramName','INTEGER'),0) > 0) AS B
			ON (A.refEventId = @refEventId AND A.ParamId = B.ParamId )
			WHEN NOT MATCHED THEN
				INSERT (refEventId,ParamId,ParamValue)
				VALUES (@refEventId,B.ParamId,dbo.DecodeInvalidXMLCharsManaged(B.ParamValue))
			WHEN MATCHED AND B.ParamValue <> '' THEN
				UPDATE SET ParamValue = dbo.DecodeInvalidXMLCharsManaged(B.ParamValue)
			;
			SELECT @o_errorCode = @@ERROR
			IF(@o_errorCode != 0)
			BEGIN
				SELECT @o_errorString = 'ERROR While inserting into DMActionParam table'
				GOTO EXIT_ERROR
			END
			IF (@i_debug= 1)
			BEGIN
				SELECT ISNULL(T.col.value('@paramName','INTEGER'),0) AS "ParamId",
							ISNULL(T.col.value('@paramValue','NVARCHAR(MAX)'),'')  AS "ParamValue"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/paramList') AS T(col)
					WHERE ISNULL(T.col.value('@paramName','INTEGER'),0) > 0
			ENd
		END
			---------------------------------------------
			------- Insert into DMActionItemMap ------
			---------------------------------------------
		--Check for existence of ResultSetIds
		IF ((SELECT T.col.exist('./resultSetIds') FROM @i_xml.nodes('DM2ContentIndexing_EventOperation') AS T(col)) = 1)
		BEGIN
			MERGE DMActionItemMap AS A
			USING (SELECT T.col.value('@val','VARCHAR(36)') AS "ResultSetId"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/resultSetIds') AS T(col)) AS B
			ON (A.refEventId = @refEventId AND A.ResultSetId = B.ResultSetId)
			WHEN NOT MATCHED THEN
				INSERT (refEventId,ResultSetId,CreateTime)
				VALUES (@refEVentId,B.ResultSetId,GETUTCDATE())
			;
			SELECT @o_errorCode = @@ERROR
			IF(@o_errorCode != 0)
			BEGIN
				SELECT @o_errorString = 'ERROR While inserting into DMActionItemMap table'
				GOTO EXIT_ERROR
			END
			IF (@i_debug= 1)
			BEGIN
				SELECT T.col.value('@val','VARCHAR(36)') AS "ResultSetId"
					FROM @i_xml.nodes('DM2ContentIndexing_EventOperation/resultSetIds') AS T(col)
			END
		END
	----------++++++++++Commit Transaction++++++++--------------
	COMMIT TRAN
	END TRY
	---------------------------------------------
	-- CHECK FOR ERRORS ----
	---------------------------------------------
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF @@TRANCOUNT > 0 AND XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
		SELECT @o_errorString = ERROR_MESSAGE(), @o_errorCode = ERROR_NUMBER()
	END CATCH
	EXIT_ERROR:
		IF @o_errorCode != 0
		BEGIN
			IF(@@TRANCOUNT > 0)
			BEGIN
				ROLLBACK TRANSACTION;
			END
		END
		IF @o_errorCode = 0
		BEGIN
			SET @o_errorString = 'NO ERROR'
		END
		IF(@discardAnyOutput != 1)
		BEGIN
		     SELECT (SELECT @o_errorCode "errorCode", @o_errorString "errLogMessage"
				FOR XML RAW('DM2ContentIndexing_Error') )
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AuditOperation')
	delete from GxQscripts where name = 'sp_dm2_AuditOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AuditOperation')
	delete from GXDBVersions where aliasname = 'sp_dm2_AuditOperation'
GO

insert into GXDBVersions values(2, 'sp_dm2_AuditOperation',  '00010004006000010000', 'sp_dm2_AuditOperation', '00010004006000010000')
GO

