

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddLegalHoldItemsToBackupBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddLegalHoldItemsToBackupBulk.sp,v $ $Id: sp_dm2_AddLegalHoldItemsToBackupBulk.sp,v 1.7.60.2 2017/02/10 19:16:13 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddLegalHoldItemsToBackupBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddLegalHoldItemsToBackupBulk')
	drop procedure sp_dm2_AddLegalHoldItemsToBackupBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GxQscripts where name = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO
print '... Creating Procedure: sp_dm2_AddLegalHoldItemsToBackupBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddLegalHoldItemsToBackupBulk
  @i_DataFilePath nvarchar(1024)
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode	 integer;
BEGIN TRY
	DECLARE @l_delimiter	VARCHAR(256)
	DECLARE @l_rowdelimiter VARCHAR(256)
	DECLARE @SQL		VARCHAR(2048)
	SET @l_delimiter = ISNULL((SELECT SettingValue
							FROM DMSetting WITH (READUNCOMMITTED) WHERE settingName = 'DMBulkInsert_Delim'), '')
	IF(LEN(@l_delimiter ) = 0)
	BEGIN
		SET @l_delimiter = 'CV0X12'
		SET @l_rowdelimiter = 'CV0X12RT\n'
	END
	ELSE
	BEGIN
		SET @l_rowdelimiter = @l_delimiter + 'RT\n'
	END
	IF OBJECT_ID('tempdb.dbo.#LHItemsToBackup') IS NULL
	BEGIN
CREATE TABLE #LHItemsToBackup
(
	[JobID] 						[int] 				NOT null,
	[CommCellID] 					[int] 				NOT null,
	[CompPolicyID] 					[char](36) 			NOT null,
	[ContainerID] 					[char](36) 			NOT null,
	[ResultSetID] 					[char](36) 			NOT null,
	[OriginalPath] 					[nvarchar](max) 	null default '',
	[BackupPath] 					[nvarchar](max) 	NOT null,
	[MetaDataXML] 					[nvarchar](max) 	null,
	[AppType] 						[int] 					null,
	[FileSizeKB]					[bigint] 				null,
	[ModifiedTime]					[int] 					null,
	[OriginalFullPath]				[nvarchar](max) 		null,
	[ClientID]						[int] 					null,
	[OwnerField]			 		[nvarchar](max) 		null,
	[FromField]		 				[nvarchar](max) 		null,
	[FolderPath]	 				[nvarchar](max) 		null
)
	END
	IF ISNULL(@i_DataFilePath, '') <> ''
	BEGIN
		SET @SQL = 'BULK INSERT #LHItemsToBackup FROM '''+@i_DataFilePath+''' WITH (ROWTERMINATOR = '''+@l_rowdelimiter+''', FIELDTERMINATOR = '''+@l_delimiter+''', DATAFILETYPE = ''widechar'' )'
	exec (@SQL)
	END
	CREATE INDEX idx_tmpItemsToBackup
	ON #LHItemsToBackup (ResultSetID, JobId, CompPolicyId )
	--------+++++++++++ Begin Transaction++++++++++-------------
	BEGIN TRAN
	MERGE DMLegalHoldItemsToBackup AS A
	USING (SELECT * FROM #LHItemsToBackup)AS T
	ON (A.JobId = T.JobId AND
		A.CompPolicyId = T.CompPolicyId AND
		A.ResultSetID = T.ResultSetID)
	WHEN NOT MATCHED THEN
		INSERT		(JobId,CommCellId,CompPolicyId,
					ContainerID,ResultSetID,OriginalPath,
					BackupPath,MetaDataXML,BackupStatus,
					Attribute,AppType,FileSizeKB,
					ModifiedTime,OriginalFullPath,ClientID,
					OwnerField,FromField,FolderPath
					)
		VALUES    (T.JobID, T.CommCellID, t.CompPolicyID,
					T.ContainerID, T.ResultSetID, ISNULL(T.OriginalPath, ''),
					T.BackupPath, T.MetaDataXML, 0,
					0, T.AppType, T.FileSizeKB,
					dbo.getDateTime(T.ModifiedTime), T.OriginalFullPath, T.ClientID,
					T.OwnerField,T.FromField,T.FolderPath
					)
	WHEN MATCHED AND A.BackupStatus <> 1
	THEN
		UPDATE SET  modifiedTime = dbo.getDateTime(T.ModifiedTime),
					BackupStatus = 0
	;
	--------+++++++++++ Commit Transaction++++++++++-------------
	IF(@@TRANCOUNT > 0)
	BEGIN
		COMMIT TRAN;
	END
CX_EXIT:
	IF object_id('tempdb.dbo.#LHItemsToBackup') IS NOT NULL
		DROP TABLE #LHItemsToBackup
	IF (@errorCode != 0)
	BEGIN
		PRINT 'Completed With Error [ '+ 	CONVERT(NVARCHAR(MAX),@errorCode) + ' ]';
		IF(XACT_STATE() <> 0)
		BEGIN
			ROLLBACK TRAN;
			PRINT 'Transcation Rollbacked due to Error'
		END
	END
	ELSE
	BEGIN
		PRINT 'Completed Successfully';
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER()
	PRINT 'Error Code   : '+ CONVERT(NVARCHAR(MAX),@errorCode  )
    PRINT 'Error Message: '+ ERROR_MESSAGE()
	-- Rollback any active or uncommittable transactions
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRAN;
		PRINT 'Transcation Rollbacked due to Exception'
	END
	IF object_id('tempdb.dbo.#LHItemsToBackup') IS NOT NULL
		DROP TABLE #LHItemsToBackup
END CATCH;
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GxQscripts where name = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddLegalHoldItemsToBackupBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddLegalHoldItemsToBackupBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddLegalHoldItemsToBackupBulk',  '00010007006000020000', 'sp_dm2_AddLegalHoldItemsToBackupBulk', '00010007006000020000')
GO

