

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddDownloadResultSetBulk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddDownloadResultSetBulk.sp,v $ $Id: sp_dm2_AddDownloadResultSetBulk.sp,v 1.11.12.9 2019/04/16 16:21:25 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sp_dm2_AddDownloadResultSetBulk')
BEGIN
	print '>>> Drop Stored Procedure: sp_dm2_AddDownloadResultSetBulk <<<'
	drop procedure sp_dm2_AddDownloadResultSetBulk
END
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddDownloadResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddDownloadResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDownloadResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDownloadResultSetBulk'
GO
print '... Creating Procedure: sp_dm2_AddDownloadResultSetBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddDownloadResultSetBulk
  @i_DownloadID varchar(36),
  @i_ResultSet xml
-- must be valid xml format, for example:
--    '<ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" turboGUID="5bcd32a5554da86d32a99da2cac57461"/>
--    <ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />
--    <ResultSet CommCellNumber="-1" aFileID="123" aFileOffset="123" AppType="1" Status="1" />'
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
DECLARE @errorCode integer
	DECLARE @tblDownloadResultSet TABLE (CommCellNumber int, aFileID bigint, aFileOffset bigint, AppType int, Status int, fileName NVARCHAR(2040), ResultSetId varchar(36), turboGUID varchar(128))
	DECLARE @DownloadType INT
	DECLARE @RestoreAsXML varchar(10) = 'emailxml'
	DECLARE @Mark_Email_Restore_To_Xml  INTEGER = 1024 -- this is use to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format
	SELECT @DownloadType = D.FileType FROM DMDownload D WHERE DownLoadID = @i_DownloadID
	INSERT INTO @tblDownloadResultSet
	SELECT distinct T.c.value('@CommCellNumber','int'),
		   T.c.value('@aFileID', 'bigint'),
	   T.c.value('@aFileOffset', 'bigint'),
		   T.c.value('@AppType', 'int'),
		   T.c.value('@Status', 'int'),
		   CASE WHEN ISNULL(T.c.value('@fileName', 'NVARCHAR(max)'),'') <> '' THEN LEFT(dbo.DecodeInvalidXMLCharsManaged(T.c.value('@fileName', 'NVARCHAR(max)')), 2040) ELSE '' END, --TABLE has filename length as 2040.. so left function used to prevent errors
				'',
		   CASE WHEN ISNULL(T.c.value('@turboGUID', 'varchar(1024)'), '') <> '' THEN LEFT(dbo.DecodeInvalidXMLCharsManaged(T.c.value('@turboGUID', 'varchar(1024)')), 128) ELSE '' END --TABLE has turboGUID length as 128.. so left function used to prevent errors
	FROM   @i_ResultSet.nodes('/ResultSet') T(c)
	-- Refer to TR 190129-530.. we don't have real GUIDs for new exchange app type 137 so we ignore them
	-- Exception: when restoring as xml, there is a prefix that can tell it is fabricated GUID and such value is needed for
	-- that feature to work. For other operations that involve power restore, GUIDs are dropped for 137 app-type on purpose - Sreekanth, Ahn
	--
UPDATE @tblDownloadResultSet SET turboGUID = '' WHERE ISNULL(AppType, 0) = 137 AND ISNULL(CHARINDEX(@RestoreAsXML, turboGUID, 1), 0) = 0
	--
	UPDATE t SET ResultSetId = RS.ResultSetId, t.filename = ISNULL(RS.DestinationPath, ''),
	    t.AppType =  CASE WHEN ISNULL(RS.AppType, 0) > 0 THEN rs.AppType ELSE ISNULL(t.AppType, 0) END
		FROM @tblDownloadResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.turboGUID,'') <> '' AND t.turboGUID = RS.IndexGUID
	--
	UPDATE t SET ResultSetId = RS.ResultSetId, t.fileName = ISNULL(RS.DestinationPath, '')
		FROM @tblDownloadResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.fileName,'') <> '' AND
			t.CommCellNumber = RS.CommCellNumber
			AND t.fileName = RS.OriginalFullPath
			AND t.AppType = RS.Apptype
AND t.AppType = 106
	--
	-- When data is Restored from legal hold, due to old bug of pushing wrong (source item's) turboguid to review set core
	-- first check if we can match item based on afileid, afileoffset and attribute = 16 (Legal_Restored_Item)
	-- This change is made to prevent returning wrong ResultSetID (for legal hold backed up items restored from LH to review set)
	-- We do not want to return ResultSetID of item that was added to legal hold instead of returning ID of item from it's corresponding
	-- legal hold backup.
	-- Change like this can be found in following SPs: sp_dm2_GetResultItemDetail, sp_dm2_AddResultSetBulk, sp_dm2_UpdateRestoreJobIDBulk.sp
	UPDATE t SET ResultSetId = RS.ResultSetId, t.fileName = ISNULL(RS.DestinationPath, ''),
		t.AppType =  CASE WHEN ISNULL(RS.AppType, 0) > 0 THEN rs.AppType ELSE ISNULL(t.AppType, 0) END
		FROM @tblDownloadResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.ResultSetId,'') = '' AND
			t.CommCellNumber = RS.CommCellNumber
			and t.aFileID = RS.aFileID
			and t.aFileOffset = RS.aFileOffset
			AND RS.Attribute = 16 -- Item restored from LH to review set given high preference
		--now update only items where resultsetid is not populated
	UPDATE t SET ResultSetId = RS.ResultSetId, t.fileName = ISNULL(RS.DestinationPath, ''),
		t.AppType =  CASE WHEN ISNULL(RS.AppType, 0) > 0 THEN rs.AppType ELSE ISNULL(t.AppType, 0) END
		FROM @tblDownloadResultSet t inner join DMResultSet RS WITH (NOLOCK)
		ON  ISNULL(t.ResultSetId,'') = '' AND
			t.CommCellNumber = RS.CommCellNumber
			and t.aFileID = RS.aFileID
			and t.aFileOffset = RS.aFileOffset
			AND RS.Attribute <> @Mark_Email_Restore_To_Xml --RS.Attribute <> @Mark_Email_Restore_To_Xml is used to filter out all emails which are restored in .xml format. Those restored emails can have same Commcell Number, aFileID, and aFileOffset but the restored file is in .xml format. That .xml format is specifically used for Outlook client to generate email preview with attachments in native format. For those items, when restore request is submitted, IndexGUID is ALWAYS available so this filter won't affect the its insertion
AND t.AppType <> 106
	/* no more deduplication here. Let items get added to the way they come from the source as count mismatch on what is submitted and what is inserted causing lot of TRs */
	/*
	DECLARE @tblDMResultSet TABLE (ResultSetId varchar(36), AppType int, [status] int, DestPath nvarchar(max))
	insert into @tblDMResultSet
	select distinct b.resultsetid, a.AppType, a.[Status], ISNULL(b.DestinationPath, '') AS DestPath
	from @tblDownloadResultSet a,  DMResultSet b with (nolock)
	where  a.ResultSetId = b.ResultSetId AND ISNULL(a.ResultSetId,'') <> ''
	 DECLARE @tblDMDownloadResultSet TABLE (ResultSetId varchar(36), DownloadID varchar(36))
	insert into @tblDMDownloadResultSet
	select a.ResultSetId,  DownloadID
	from DMDownloadResultSet a with (nolock), @tblDMResultSet b
	where DownloadID = @i_DownloadID and a.ResultSetId = b.ResultSetId
	--remove duplicate rows
	 DELETE a
	 FROM @tblDMResultSet a, @tblDMDownloadResultSet b
	 WHERE a.ResultSetId = b.ResultSetId
	 */
	 insert into DMDownloadResultSet (DownloadID , ResultSetID, AppType, Status, CreateTime , FileName)
     select @i_DownloadID, b.ResultSetId, b.AppType,
     (CASE WHEN @DownloadType <> 1 AND fileName <> '' THEN 100 ELSE  b.[Status] END) AS [Status], getdate(),
     (CASE WHEN @DownloadType <> 1 THEN fileName ELSE '' END) as [FileName]
     FROM  @tblDownloadResultSet b
SELECT @errorCode = @@Error
SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddDownloadResultSetBulk')
	delete from GxQscripts where name = 'sp_dm2_AddDownloadResultSetBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddDownloadResultSetBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddDownloadResultSetBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddDownloadResultSetBulk',  '00010011001200090000', 'sp_dm2_AddDownloadResultSetBulk', '00010011001200090000')
GO

