

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/sp_dm2_AddCacheFileListBulk.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sp_dm2_AddCacheFileListBulk()
--  | Description:  Add inputfiles to the DM2TempCacheFileList table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/sp_dm2_AddCacheFileListBulk.sp,v $ $Id: sp_dm2_AddCacheFileListBulk.sp,v 1.2 2013/12/28 03:35:36 ksundaram Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sp_dm2_AddCacheFileListBulk <<<'

IF EXISTS (select * from sysobjects where name='sp_dm2_AddCacheFileListBulk')
	drop procedure sp_dm2_AddCacheFileListBulk
IF EXISTS (select * from GxQscripts where name='sp_dm2_AddCacheFileListBulk')
	delete from GxQscripts where name = 'sp_dm2_AddCacheFileListBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddCacheFileListBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddCacheFileListBulk'
GO
print '... Creating Procedure: sp_dm2_AddCacheFileListBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sp_dm2_AddCacheFileListBulk
  @i_filePathList NVARCHAR(MAX),
  @o_errrorCode INT OUTPUT,
  @o_errorMessage NVARCHAR(MAX) OUTPUT
AS
BEGIN
	/*
		sp_dm2_InitPruning myst be called before invoking this SP.
	*/
	--DECLARE @o_errrorCode	INT;
	--DECLARE @o_errorMessage	NVARCHAR(MAX);
	--if table is not created, return error.
	if (object_id('DM2TempCacheFileList') is null)
	BEGIN
		SELECT @o_errrorCode = 1, @o_errorMessage = 'Tables DM2TempCacheFileList is not created. '
		GOTO EXIT_;
	END
	DECLARE @FileList TABLE ( filePath NVARCHAR(MAX)) ;
	DECLARE @i_xml XML =  @i_filePathList
	/*
		format of i_xml
		'<PathList>
			<path val ="c:\test\a;t.t"/>
			<path val ="c:\test1\b.t"/>
			<path val ="c:\test2\c.t"/>
		</PathList>'
	*/
	INSERT INTO @FileList
	SELECT distinct ref.value('@val','nvarchar(MAX)')
	FROM @i_xml.nodes('PathList/path') R(ref)
	--Now insert into
	INSERT INTO DM2TempCacheFileList (cachePath, chkSum)
	SELECT F.filePath, dbo.fn_HashData(UPPER(F.filePath)) FROM @FileList as F
	WHERE ISNULL(F.filePath,'') <> ''
	SELECT @o_errrorCode = 0, @o_errorMessage = 'Inserted ' + CONVERT(VARCHAR(10),@@ROWCOUNT) + ' into cache temp table'
	EXIT_:
		RETURN
		--SELECT @o_errrorCode 'ErrorCode', @o_errorMessage 'Message'
END
GO

IF EXISTS (select * from GxQscripts where name = 'sp_dm2_AddCacheFileListBulk')
	delete from GxQscripts where name = 'sp_dm2_AddCacheFileListBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sp_dm2_AddCacheFileListBulk')
	delete from GXDBVersions where aliasname = 'sp_dm2_AddCacheFileListBulk'
GO

insert into GXDBVersions values(2, 'sp_dm2_AddCacheFileListBulk',  '00010002000000000000', 'sp_dm2_AddCacheFileListBulk', '00010002000000000000')
GO

