

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/QS_EnableBannerText.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/QS_EnableBannerText.sp,v $ $Id: QS_EnableBannerText.sp,v 1.4.52.2 2018/12/27 18:30:31 vikashkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_EnableBannerText')
BEGIN
	print '>>> Drop Stored Procedure: QS_EnableBannerText <<<'
	drop procedure QS_EnableBannerText
END
IF EXISTS (select * from GxQscripts where name='QS_EnableBannerText')
	delete from GxQscripts where name = 'QS_EnableBannerText'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableBannerText')
	delete from GXDBVersions where aliasname = 'QS_EnableBannerText'
GO
print '... Creating Procedure: QS_EnableBannerText'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_EnableBannerText
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- SP Input Params
  @i_enableBanner varchar(64)='',
  @i_filePath varchar(1024)=''
AS
Set NOCOUNT ON
/*
 Local Variables
 */
	DECLARE @localErrorMsg	varchar(512)
	DECLARE @localErrorCode INT = 0
	SET		@localErrorMsg	='Error Encountered when running script.'
	DECLARE @NoParameter			varchar(10)
	SET     @NoParameter			=''
	DECLARE @param1Invalid INT
	IF @i_enableBanner = @NoParameter
	BEGIN
		SET @localErrorMsg = 'Error:  Insufficient command line parameters'
		SET @localErrorCode = 1
		GOTO CV_EXIT
	END
	SELECT @param1Invalid = CASE WHEN @i_enableBanner not in ('True', 'False', 'EnableSecondBanner', 'DisableSecondBanner') THEN 1 ELSE 0 END
	DECLARE @isRequestForSecondBanner INT
	SELECT @isRequestForSecondBanner = CASE WHEN @i_enableBanner in ('EnableSecondBanner', 'DisableSecondBanner') THEN 1 ELSE 0 END
	DECLARE @ENABLE_BANNER_SETTING VARCHAR(255)
	DECLARE @BANNER_TEXT_SETTING VARCHAR(255)
	IF @isRequestForSecondBanner = 1
	BEGIN
		SET @ENABLE_BANNER_SETTING = 'PRELOGIN_BANNER2_ENABLED'
		SET @BANNER_TEXT_SETTING = 'PRELOGIN_BANNER2_TEXT'
	END
	ELSE
	BEGIN
		SET @ENABLE_BANNER_SETTING = 'PRELOGIN_BANNER_ENABLED'
		SET @BANNER_TEXT_SETTING = 'PRELOGIN_BANNER_TEXT'
	END
	IF @param1Invalid = 1
	BEGIN
		SET @localErrorMsg = 'Error:  Parameter value: [' + @i_enableBanner + '] is invalid'
		SET @localErrorCode = 2
		GOTO CV_EXIT
	END
	IF(@i_enableBanner = 'True' AND @i_filePath = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: FilePath is not provided to enable banner text'
		SET @localErrorCode = 3
		GOTO CV_EXIT
	END
	IF(@i_enableBanner = 'EnableSecondBanner' AND @i_filePath = @NoParameter)
	BEGIN
		SET @localErrorMsg = 'Error: FilePath is not provided to enable second banner text'
		SET @localErrorCode = 4
		GOTO CV_EXIT
	END
	--------+++++++Disable the banner test ++++++++------------
	IF(@i_enableBanner = 'False')
	BEGIN
		IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING)
			delete FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING
		IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING)
			delete FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING
		SET @localErrorMsg = 'Prelogin Banner is Disabled'
	END
	ELSE
	BEGIN
	--------+++++++Enable the banner test ++++++++------------
	IF(@i_enableBanner = 'True' OR @i_enableBanner = 'EnableSecondBanner')
	BEGIN
		IF object_id('tempdb.dbo.#temp') IS NOT null
			DROP TABLE #temp
		CREATE TABLE #temp
		(VALUE VARCHAR(MAX));
		SET ANSI_WARNINGS OFF;
		DECLARE @sqlStmt VARCHAR(MAX)
		SET @sqlStmt = 'BULK INSERT #temp FROM '''+ @i_filePath +
						'''WITH (DATAFILETYPE = ''widechar'' ,
								 ROWTERMINATOR  = ''\0'',
								 FIELDTERMINATOR = ''\0'' )'
		---Perform Bulk Insert operation inside TRY/CATCH operation
		BEGIN TRY
			EXECUTE(@sqlStmt)
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @localErrorMsg = 'Error: Cannot load the file : [' + @i_filePath + ']'
			SET @localErrorCode = 5
			GOTO CV_EXIT
		END CATCH
		IF NOT EXISTS (SELECT * FROM #temp T WHERE isnull(T.Value, '') <> '')
		BEGIN
			SET @localErrorMsg = 'Error: Banner text is emtpy in specified file'
			SET @localErrorCode = 6
			GOTO CV_EXIT
		END
	END
		IF(@i_enableBanner = 'False' OR @i_enableBanner = 'DisableSecondBanner')
		BEGIN
			IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING)
				delete FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING
			IF EXISTS (SELECT * FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING)
			 delete FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING
			IF @i_enableBanner = 'False'
				SET @localErrorMsg = 'Main PreLogin Banner is Disabled'
			ELSE
				SET @localErrorMsg = 'Second Banner is Disabled'
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = @ENABLE_BANNER_SETTING)
			BEGIN
				INSERT INTO DMSetting (SettingName,SettingValue,CreateTime)
				VALUES (@ENABLE_BANNER_SETTING, 'True', getDate())
			END
			ELSE
			BEGIN
				UPDATE DMSetting
				SET SettingValue = 'True'
				WHERE SettingName = @ENABLE_BANNER_SETTING
			END
			IF NOT EXISTS (SELECT * FROM DMSetting WHERE SettingName = @BANNER_TEXT_SETTING)
			BEGIN
				INSERT INTO DMSetting(SettingName,SettingValue,CreateTime)
				SELECT TOP 1 @BANNER_TEXT_SETTING, #temp.VALUE, getUtcDate() FROM #temp
			END
			ELSE
			BEGIN
				UPDATE DMSetting
				SET SettingValue = (SELECT TOP 1 #temp.VALUE FROM #temp)
				WHERE SettingName = @BANNER_TEXT_SETTING
			END
			IF @i_enableBanner = 'True'
				SET @localErrorMsg = 'Main PreLogin banner is successfully enabled'
			ELSE
				SET @localErrorMsg = 'Second banner is successfully enabled'
		END
		--Drop temp table
		IF OBJECT_ID('tempdb.dbo.#temp') IS NOT NULL
			DROP TABLE #temp
	END
CV_EXIT:
	IF @localErrorCode > 0
	BEGIN
		RAISERROR (@localErrorMsg, 15, 1)
	END
	ELSE
	BEGIN
		SELECT @localErrorMsg
	END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_EnableBannerText')
	delete from GxQscripts where name = 'QS_EnableBannerText'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_EnableBannerText')
	delete from GXDBVersions where aliasname = 'QS_EnableBannerText'
GO

insert into GXDBVersions values(2, 'QS_EnableBannerText',  '00010004005200020000', 'QS_EnableBannerText', '00010004005200020000')
GO

insert into GxQscripts values(2,'QS_EnableBannerText',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 	To enanble banner text'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''True'' -si ''Banner text filePath'' '
 + CHAR(10) + '-- 	To disable banner text'
 + CHAR(10) + '-- 	qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''False'''
 + CHAR(10) + '-- 	--------------------------------'
 + CHAR(10) + '--     To enable second banner text'
 + CHAR(10) + '--     qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''EnableSecondBanner'' -si ''Banner text filePath'' '
 + CHAR(10) + '--     To disable second banner text'
 + CHAR(10) + '--     qoperation execscript -dbn DM2 -c ''client Name'' -sn EnableBannerText -si ''DisableSecondBanner'''
 + CHAR(10) + '-- 	-------------- Explanation of arguments ------------------'
 + CHAR(10) + '-- 	''client Name'' -- client name of the Webserver machine (Single quotes not required. Hint: To find this, look at name of web server client in simpana administrative console)'
 + CHAR(10) + '-- 	''Banner text filePath'' -- Path to the file, that contains banner text, located on webserver machine local disk'
)
GO

