

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/DM2DbclrInstall.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DM2DbclrInstall')
BEGIN
	print '>>> Drop Stored Procedure: DM2DbclrInstall <<<'
	drop procedure DM2DbclrInstall
END
IF EXISTS (select * from GxQscripts where name='DM2DbclrInstall')
	delete from GxQscripts where name = 'DM2DbclrInstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DbclrInstall')
	delete from GXDBVersions where aliasname = 'DM2DbclrInstall'
GO
print '... Creating Procedure: DM2DbclrInstall'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure DM2DbclrInstall
  @DM2_DBCLR_PATH VARCHAR(MAX)
AS
	SET NOCOUNT ON
	DECLARE @versionSQL	NVARCHAR(MAX)
	DECLARE @sqlQuery	NVARCHAR(MAX)
	DECLARE @errSection	VARCHAR(1024) = ''
	DECLARE @o_retVal	INT = 0;
	DECLARE @windows TINYINT = 1
	DECLARE @linux TINYINT = 2
	DECLARE @osType TINYINT = 0
	DECLARE @nl VARCHAR(4) = ''
	SET @versionSQL = @@VERSION
	SET @osType = IIF((@versionSQL LIKE '%Linux%'), @linux, @windows)
	SET @nl = IIF((@osType = @windows), (CHAR(13) + CHAR(10)), CHAR(10))		-- CRLF(Windows), LF(Linux newline)
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	-- Valid inputted path
	IF (@DM2_DBCLR_PATH IS NULL OR @DM2_DBCLR_PATH = '')
	BEGIN
		RAISERROR('DM2DbclrInstall: Error @DM2_DBCLR_PATH argument not set.', 16, 1) WITH LOG, NOWAIT;
	END
	PRINT 'DM2DbclrInstall: CLRFile [' + @DM2_DBCLR_PATH + ']'
	-- Changes to stop RECONFIGURE the SQL Server during each DbUpgrade over the life time of the server
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'show advanced options' AND CAST(value_in_use AS INT) = 0)
	BEGIN
		SET @sqlQuery = 'USE MASTER;
				EXEC sp_configure ''show advanced options'', 1;
				RECONFIGURE;
		'
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF  @o_retVal <> 0
		BEGIN
			SET @errSection = 'EXEC sp_configure ''show advanced options'''
			GOTO CX_EXIT
		END
	END
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr enabled' AND CAST(value_in_use AS INT) = 0)
	BEGIN
		SET @sqlQuery = 'USE MASTER;
				EXEC sp_configure ''clr enabled'' , 1;
				RECONFIGURE;
		'
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF  @o_retVal <> 0
		BEGIN
			SET @errSection = 'EXEC sp_configure ''clr enabled'''
			GOTO CX_EXIT
		END
	END
	IF (@releaseNumber >= 14)	-- SQL Server 2017+
	BEGIN
		-- If CLR Strict Security is enabled need to disabled
		IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr strict security' AND CAST(value_in_use AS INT) = 1)
		BEGIN
			SET @sqlQuery = 'USE MASTER;
					EXEC sp_configure ''clr strict security'' , 0;
					RECONFIGURE;
			'
			EXECUTE sp_executeSql @sqlQuery
			SET @o_retVal = @@ERROR
			IF  @o_retVal <> 0
			BEGIN
				SET @errSection = 'EXEC sp_configure ''clr strict security'''
				GOTO CX_EXIT
			END
		END
	END
	SET @sqlQuery =  ''
	DECLARE @objcur CURSOR
	DECLARE @object_id INT
	DECLARE @type char(2)
	SET @objcur=CURSOR FOR
		(SELECT object_id,TYPE
			FROM sys.objects WHERE object_id in (
			SELECT object_id FROM sys.assembly_modules
			WHERE
				assembly_id in (
					SELECT assembly_id
					FROM sys.assemblies WHERE name IN (
							'CommonUtils',
							'CVManagedLogger',
							'XmlManagedMsg',
							'XMlManagedMsgBase',
							'XmlManagedMsgApp'
						)
				)
			)
		)
	OPEN @objcur
	FETCH NEXT FROM @objcur INTO @object_id,@type
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @type = 'P' OR @type = 'PC'
			SET @sqlQuery += 'DROP PROCEDURE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		ELSE IF @type = 'FS'
			SET @sqlQuery += 'DROP FUNCTION ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		ELSE IF @type = 'AF'
			SET @sqlQuery += 'DROP AGGREGATE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		FETCH NEXT FROM @objcur INTO @object_id,@type
	END
	CLOSE @objcur
	DEALLOCATE @objcur
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0
	BEGIN
		SET @errSection = 'Dropping Assembly Modules (Proc, Func, Agg)'
		GOTO CX_EXIT
	END
	SET @sqlQuery = '
		USE MASTER;
		IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVDM2DBCLRLogin'')
			DROP LOGIN CVDM2DBCLRLogin;
		IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVDM2DBCLRKey'')
			DROP ASYMMETRIC KEY CVDM2DBCLRKey;
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0
	BEGIN
		SET @errSection = 'Dropping Login and CLR Key'
		GOTO CX_EXIT
	END
	DECLARE @assemblyTbl TABLE (
		id		INT IDENTITY(1,1) PRIMARY KEY,	-- assemblies dropped in specific order
		name	SYSNAME
	)
	-- Assemblies inserted in drop order
	INSERT INTO @assemblyTbl (name) VALUES
		('CommonUtils'),
		('XmlManagedMsg'),
		('XmlManagedMsgApp'),
		('XMlManagedMsgBase'),
		('CVManagedLogger')
	DECLARE @AssemblyName SYSNAME
	DECLARE AssemblyCur CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
		SELECT
			name
		FROM @assemblyTbl
		ORDER BY id ASC        -- order to drop
	OPEN AssemblyCur
	FETCH NEXT FROM AssemblyCur INTO @AssemblyName
	SET @sqlQuery = ''
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @sqlQuery += '
		IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''' + @AssemblyName + ''')
		BEGIN
			DROP ASSEMBLY [' + @AssemblyName + ']
			PRINT ''Dropped Assembly [' + @AssemblyName + ']''
		END
		'
		FETCH NEXT FROM AssemblyCur INTO @AssemblyName
	END
	CLOSE AssemblyCur
	DEALLOCATE AssemblyCur
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0
	BEGIN
		SET @errSection = 'Dropping Assembly DLLs'
		GOTO CX_EXIT
	END
	SET @sqlQuery = '
		CREATE ASSEMBLY CommonUtils FROM ''' + @DM2_DBCLR_PATH + '''
			WITH PERMISSION_SET = SAFE
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0
	BEGIN
		SET @errSection = 'Creating Assembly CommonUtils'
		GOTO CX_EXIT
	END
	SET @sqlQuery = '
		CREATE FUNCTION [dbo].[DecodeInvalidXMLCharsManaged] (@inputString NVARCHAR(MAX))
			RETURNS NVARCHAR(MAX)
			WITH EXECUTE AS CALLER
		AS
			EXTERNAL NAME [CommonUtils].[Utils].[decodeInvalidXMLChars]
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0
	BEGIN
		SET @errSection = 'Creating Function decodeInvalidXMLChars'
		GOTO CX_EXIT
	END
CX_EXIT:
	IF  @o_retVal <> 0
	BEGIN
		PRINT 'DM2DbclrInstall: Failure in [' + @errSection + ']'
	END
	SELECT @o_retVal
	RETURN @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'DM2DbclrInstall')
	delete from GxQscripts where name = 'DM2DbclrInstall'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DM2DbclrInstall')
	delete from GXDBVersions where aliasname = 'DM2DbclrInstall'
GO

insert into GXDBVersions values(2, 'DM2DbclrInstall',  '00000000000000000000', 'DM2DbclrInstall', '00000000000000000000')
GO

