

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppUpdateDMResultSetAfterBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  AppUpdateDMResultSetAfterBackup
--  |
--  | Description:  Updates the DMResultSet with afileID, offset for files downloaded from download cache
--	|
--  |	   Input :	input XML request
--	|
--  |      Output:
--	|
--  |   Revisions  Author      Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.0      Niresh Ramalingam  Updated DMResult during clbackup complete
--  |
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppUpdateDMResultSetAfterBackup <<<'

IF EXISTS (select * from sysobjects where name='AppUpdateDMResultSetAfterBackup')
	drop procedure AppUpdateDMResultSetAfterBackup
IF EXISTS (select * from GxQscripts where name='AppUpdateDMResultSetAfterBackup')
	delete from GxQscripts where name = 'AppUpdateDMResultSetAfterBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDMResultSetAfterBackup')
	delete from GXDBVersions where aliasname = 'AppUpdateDMResultSetAfterBackup'
GO
print '... Creating Procedure: AppUpdateDMResultSetAfterBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppUpdateDMResultSetAfterBackup
  @xmlTextInput XML
AS
SET NOCOUNT ON
    UPDATE DR set DR.Attribute=0, DR.aFileID =XDR.AFileId, DR.aFileOffset =XDR.AFileOffset, DR.OriginalFullPath=DR.Title,DR.Title=NULL
    FROM
    DMResultset DR
    INNER JOIN
    (
		SELECT
			ref.value('(@aFileId)', 'BIGINT') as 'AFileId',
			ref.value('(@aFileOffset)','BIGINT') as 'AFileOffset',
			ref.value('(@indexGuid)', 'VARCHAR(128)') as 'IndexGuid'
		FROM
		@xmlTextInput.nodes('/Api_UpdateDMResultSetRequest/dmresultsetList') doc(ref)
	) XDR
	on DR.IndexGUID = XDR.IndexGuid
	WHERE DR.Attribute =128
GO

IF EXISTS (select * from GxQscripts where name = 'AppUpdateDMResultSetAfterBackup')
	delete from GxQscripts where name = 'AppUpdateDMResultSetAfterBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppUpdateDMResultSetAfterBackup')
	delete from GXDBVersions where aliasname = 'AppUpdateDMResultSetAfterBackup'
GO

insert into GXDBVersions values(2, 'AppUpdateDMResultSetAfterBackup',  '00000000000000000000', 'AppUpdateDMResultSetAfterBackup', '00000000000000000000')
GO

