

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Sp/AppSyncAddUploadFileForDownload.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/DM2Db/Sp/AppSyncAddUploadFileForDownload.sp,v $ $Id: AppSyncAddUploadFileForDownload.sp,v 1.4.12.3 2018/03/29 22:00:42 nramalingam Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppSyncAddUploadFileForDownload <<<'

IF EXISTS (select * from sysobjects where name='AppSyncAddUploadFileForDownload')
	drop procedure AppSyncAddUploadFileForDownload
IF EXISTS (select * from GxQscripts where name='AppSyncAddUploadFileForDownload')
	delete from GxQscripts where name = 'AppSyncAddUploadFileForDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncAddUploadFileForDownload')
	delete from GXDBVersions where aliasname = 'AppSyncAddUploadFileForDownload'
GO
print '... Creating Procedure: AppSyncAddUploadFileForDownload'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppSyncAddUploadFileForDownload
  @i_uploadReqId NVARCHAR(max),
  @i_documentId NVARCHAR(max),
  @i_CCN int,
  @i_indexGuid VARCHAR(128),
  @i_appId int
AS
SET NOCOUNT ON
BEGIN
	-- For edge drive afileId and afileOffset gets updated after backup.
	-- if there are multiple versions before backup, we will make a copy of the latest file in download cache
	IF NOT EXISTS (SELECT * FROM DMResultSet WHERE documentID = @i_documentId and ((afileId=0 and aFileOffset=0 ) and Attribute & 512 = 0))--EDMResultSetAttribute IsFolder 512
	BEGIN
		INSERT INTO DMResultSet([ResultSetID]
			   ,[CommCellNumber]
			   ,[aFileID]
			   ,[aFileOffset]
			   ,[aFileLength]
			   ,[AppType]
			   ,[FileSizeKB]
			   ,[ModifiedTime]
			   ,[OriginalFullPath]
			   ,[DestinationPath]
			   ,RestoreStatus
			   ,[CreateTime]
			   ,JobId
			   ,RestoreUserGUID
			   ,RestoreCommCellNumber
			   ,RestoreJobID
			   ,Attribute
			   ,documentID
			   ,ClientID
			   ,ERMStatus
			   ,Title
			   ,IndexGUID
			   ,AppId)
		SELECT NEWID(),@i_CCN,0,0,0,33, (fileSize/1024), dbo.getdatetime(modified), @i_uploadReqId, localPath, 4, dbo.getdatetime(created ), 0, userId, 0, 0, 0, @i_documentId, 0, 0, destPath,@i_indexGuid,@i_appId
		FROM SyncUploadInfo
		WHERE requestId = @i_uploadReqId
	END
	ELSE
	BEGIN
		UPDATE DMResultSet
		SET
			[FileSizeKB] = (S.fileSize/1024),
			[ModifiedTime] = dbo.getdatetime(S.modified),
			[OriginalFullPath] = @i_uploadReqId,
			[DestinationPath] = S.localPath,
			[CreateTime] = dbo.getdatetime(S.created ),
			[Title] = S.destPath,
			[Attribute] = 0,
		    [IndexGUID] = @i_indexGuid
		FROM SyncUploadInfo S
		WHERE documentID = @i_documentId AND ((afileId=0 and aFileOffset=0 ) and Attribute & 512 = 0)
		AND S.requestId = @i_uploadReqId
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppSyncAddUploadFileForDownload')
	delete from GxQscripts where name = 'AppSyncAddUploadFileForDownload'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppSyncAddUploadFileForDownload')
	delete from GXDBVersions where aliasname = 'AppSyncAddUploadFileForDownload'
GO

insert into GXDBVersions values(2, 'AppSyncAddUploadFileForDownload',  '00010004001200030000', 'AppSyncAddUploadFileForDownload', '00010004001200030000')
GO

