

--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetLatestResultSetXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetLatestResultSetXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetLatestResultSetXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetLatestResultSetXML]
  delete from GXDBVersions where name = 'fn_dm2_GetLatestResultSetXML' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO

	CREATE FUNCTION fn_dm2_GetLatestResultSetXML (@ResultSetId  CHAR(36), @ResultSet  NVARCHAR(MAX))
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
	DECLARE @ResultSetXML XML
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), 'encoding="utf-8"', '')
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), 'encoding="utf-16"', '')
	--Fix root node in case if it does not have any xml header and root node starts right from start..
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX),@ResultSet), '<resultItem', '<DM2ContentIndexing_GResultItem')
	--Fix end tag
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), '</resultItem>', '</DM2ContentIndexing_GResultItem>')
	SET @ResultSetXML = CONVERT(XML, @ResultSet)
	-- Add ResultItemID attribute only if required..
	IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@ResultItemID]') = 0
		SET @ResultSetXML.modify('insert attribute ResultItemID {sql:variable("@ResultSetId")} into (/DM2ContentIndexing_GResultItem)[1]')
	ELSE
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@ResultItemID)[1] with sql:variable("@ResultSetId")')
	SET @ResultSet= CONVERT(NVARCHAR(MAX), @ResultSetXML)
	RETURN @ResultSet
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetLatestResultSetXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetLatestResultSetXML' AND revision = '1.6')

  insert into GXDBVersions values(5, 'fn_dm2_GetLatestResultSetXML',  '1.6', 'fn_dm2_GetLatestResultSetXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
