SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/GetUnixTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUnixTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUnixTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUnixTime]
  delete from GXDBVersions where name = 'GetUnixTime' and type = 5
END
GO

	CREATE FUNCTION GetUnixTime (@DateTimeArg datetime)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @dateTimeBase DATETIME
    DECLARE @unixtime int
    set @dateTimeBase = '01/01/1970'
	if (@DateTimeArg < @dateTimeBase)
	  set @unixtime = 0
	ELSE
	  set @unixtime =  datediff(second, '01/01/1970', @DateTimeArg)
	return @unixtime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUnixTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUnixTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetUnixTime',  '1.2', 'GetUnixTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/GetDateTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTime]
  delete from GXDBVersions where name = 'GetDateTime' and type = 5
END
GO

	CREATE FUNCTION GetDateTime (@UnixTimeArg integer)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
	 	return dateadd(second, @UnixTimeArg, '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTime' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetDateTime',  '1.3', 'GetDateTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/splitStringToTable.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: splitStringToTable'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[splitStringToTable]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[splitStringToTable]
  delete from GXDBVersions where name = 'splitStringToTable' and type = 5
END
GO

	CREATE FUNCTION dbo.splitStringToTable (@StringInput NVARCHAR(MAX))
	RETURNS @OutputTable TABLE (ID NVARCHAR(1024))
	WITH ENCRYPTION
	AS
	BEGIN
	    DECLARE @StrValue    NVARCHAR(1024)
	    WHILE LEN(@StringInput) > 0
	    BEGIN
	        SET @StrValue = LEFT(@StringInput, ISNULL(NULLIF(CHARINDEX(';', @StringInput) - 1, -1), LEN(@StringInput)))
	        SET @StringInput = SUBSTRING(@StringInput, ISNULL(NULLIF(CHARINDEX(';', @StringInput), 0), LEN(@StringInput)) + 1, LEN(@StringInput))
	        INSERT INTO @OutputTable (ID) VALUES (@StrValue)
	    END
	    RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [splitStringToTable]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'splitStringToTable' AND revision = '1.5')

  insert into GXDBVersions values(5, 'splitStringToTable',  '1.5', 'splitStringToTable', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetLegalHoldBackupStatus.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetLegalHoldBackupStatus'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetLegalHoldBackupStatus]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetLegalHoldBackupStatus]
  delete from GXDBVersions where name = 'fn_dm2_GetLegalHoldBackupStatus' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_GetLegalHoldBackupStatus (@i_ResultSetId CHAR(36))
	RETURNS INTEGER
	AS
	BEGIN
	DECLARE @BackupStatus INT
	SELECT TOP 1 @BackupStatus = BackupStatus
	FROM DMLegalHoldItemsToBackup WHERE ResultSetId = @i_ResultSetId
	ORDER BY JOBID DESC
	RETURN ISNULL(@BackupStatus, 3)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetLegalHoldBackupStatus]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetLegalHoldBackupStatus' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fn_dm2_GetLegalHoldBackupStatus',  '1.2', 'fn_dm2_GetLegalHoldBackupStatus', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetResultItemTags.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetResultItemTags'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetResultItemTags]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetResultItemTags]
  delete from GXDBVersions where name = 'fn_dm2_GetResultItemTags' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_GetResultItemTags (@i_ResultSetID CHAR(36), @i_GetDBTags BIT = 1, @i_GetFastSyncTags BIT = 1, @i_UserGUID CHAR(36) = '', @i_ContainerID CHAR(36) = '')
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
	DECLARE @tmpTagStr NVARCHAR(MAX)
	SET @tmpTagStr = null
	IF @i_UserGUID is null SET @i_UserGUID = ''
	IF @i_GetDBTags = 1
	BEGIN
		SELECT @tmpTagStr = COALESCE(@tmpTagStr + ',', '') + CIT.TagId
		FROM 	DMContainerItemStates CIS, DMContainerItemTags CIT
		WHERE	CIS.ResultSetId = @i_ResultSetID AND (ISNULL(@i_ContainerID, '') = '' or (isnull(@i_ContainerID, '') <> '' and CIS.ContainerId = @i_ContainerID))
		AND	CIS.AssignId = CIT.AssignId
		AND	(CIS.Attribute & 4) = 0
		AND	(CIT.Attribute & 4) = 0
		AND	(@i_UserGUID = '') OR (@i_UserGUID <> '' AND CIS.AssignedUserGUID = @i_UserGUID)
	END
	IF @i_GetFastSyncTags = 1
	BEGIN
		SELECT @tmpTagStr = COALESCE(@tmpTagStr + ',', '') + UIT.TagID
		FROM 	DMUserItemTags UIT
		WHERE	UIT.ResultSetId = @i_ResultSetID
		AND	(UIT.Attribute & 4) = 0
		AND	(@i_UserGUID = '') OR (@i_UserGUID <> '' AND UIT.UserGUID = @i_UserGUID)
	END
	RETURN ISNULL(@tmpTagStr, '')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetResultItemTags]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetResultItemTags' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fn_dm2_GetResultItemTags',  '1.2', 'fn_dm2_GetResultItemTags', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_ResultItemExistInContainers.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_ResultItemExistInContainers'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_ResultItemExistInContainers]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_ResultItemExistInContainers]
  delete from GXDBVersions where name = 'fn_dm2_ResultItemExistInContainers' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_ResultItemExistInContainers (@i_ResultSetID CHAR(36), @i_ContainerIDList VARCHAR(MAX))
	RETURNS BIT
	AS
	BEGIN
	IF EXISTS(
		SELECT * FROM dbo.splitStringToTable (REPLACE(@i_ContainerIDList, ',', ';')) A
		JOIN DMContainerItem B ON A.ID = B.ContainerId
		WHERE ResultSetID = @i_ResultSetID
	)
	BEGIN
		RETURN 1
	END
	RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_ResultItemExistInContainers]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_ResultItemExistInContainers' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fn_dm2_ResultItemExistInContainers',  '1.2', 'fn_dm2_ResultItemExistInContainers', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetLatestResultSetXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetLatestResultSetXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetLatestResultSetXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetLatestResultSetXML]
  delete from GXDBVersions where name = 'fn_dm2_GetLatestResultSetXML' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO

	CREATE FUNCTION fn_dm2_GetLatestResultSetXML (@ResultSetId  CHAR(36), @ResultSet  NVARCHAR(MAX))
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
	DECLARE @ResultSetXML XML
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), 'encoding="utf-8"', '')
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), 'encoding="utf-16"', '')
	--Fix root node in case if it does not have any xml header and root node starts right from start..
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX),@ResultSet), '<resultItem', '<DM2ContentIndexing_GResultItem')
	--Fix end tag
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), '</resultItem>', '</DM2ContentIndexing_GResultItem>')
	SET @ResultSetXML = CONVERT(XML, @ResultSet)
	-- Add ResultItemID attribute only if required..
	IF @ResultSetXML.exist('//DM2ContentIndexing_GResultItem[@ResultItemID]') = 0
		SET @ResultSetXML.modify('insert attribute ResultItemID {sql:variable("@ResultSetId")} into (/DM2ContentIndexing_GResultItem)[1]')
	ELSE
		SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@ResultItemID)[1] with sql:variable("@ResultSetId")')
	SET @ResultSet= CONVERT(NVARCHAR(MAX), @ResultSetXML)
	RETURN @ResultSet
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetLatestResultSetXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetLatestResultSetXML' AND revision = '1.6')

  insert into GXDBVersions values(5, 'fn_dm2_GetLatestResultSetXML',  '1.6', 'fn_dm2_GetLatestResultSetXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetResultItemContainers.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetResultItemContainers'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetResultItemContainers]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetResultItemContainers]
  delete from GXDBVersions where name = 'fn_dm2_GetResultItemContainers' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_GetResultItemContainers (@i_ResultSetID char(36))
	RETURNS  NVARCHAR(MAX)
	AS
	BEGIN
		DECLARE @tmpContainerStr NVARCHAR(MAX)
		SET @tmpContainerStr = ''
		SELECT @tmpContainerStr = COALESCE(@tmpContainerStr + ',', '') + ContainerID
		FROM DMContainerItem WHERE ResultSetID = @i_ResultSetID
		if ISNULL(@tmpContainerStr, '')	<> ''
		BEGIN
			IF LEFT(@tmpContainerStr, 1) = ','
				SET @tmpContainerStr = RIGHT(@tmpContainerStr, LEN(@tmpContainerStr)-1)
			IF RIGHT(@tmpContainerStr, 1) = ','
				SET @tmpContainerStr = LEFT(@tmpContainerStr, LEN(@tmpContainerStr)-1)
		END
		RETURN ISNULL(@tmpContainerStr, '')
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetResultItemContainers]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetResultItemContainers' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fn_dm2_GetResultItemContainers',  '1.2', 'fn_dm2_GetResultItemContainers', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_SearchStrings.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_SearchStrings'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_SearchStrings]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_SearchStrings]
  delete from GXDBVersions where name = 'fn_dm2_SearchStrings' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_SearchStrings ( @var1 varchar(max),  @var2 varchar(max), @seperator VARCHAR(3))
	RETURNS BIT
	AS
	BEGIN

	IF @seperator <> ';'
	BEGIN
		SET @var1 = REPLACE(@var1, @seperator, ';')
	  SET @var2 = REPLACE(@var2, @seperator, ';')
	END

	IF EXISTS(
		SELECT TOP 1 * FROM dbo.splitStringToTable(@var1) A
		JOIN dbo.splitStringToTable(@var2) B ON A.ID = B.ID
	)
	BEGIN
		RETURN 1
	END

	RETURN 0

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_SearchStrings]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_SearchStrings' AND revision = '1.1')

  insert into GXDBVersions values(5, 'fn_dm2_SearchStrings',  '1.1', 'fn_dm2_SearchStrings', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetOwnerFieldDisplayValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetOwnerFieldDisplayValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetOwnerFieldDisplayValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetOwnerFieldDisplayValue]
  delete from GXDBVersions where name = 'fn_dm2_GetOwnerFieldDisplayValue' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_GetOwnerFieldDisplayValue ( @ownerField NVARCHAR(MAX) )
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
	DECLARE @outputVal NVARCHAR(MAX)
	DECLARE @spliter CHAR(3) = 'CN='
	DECLARe @lastIndexOfSpliter INT = 0
	--Try to get the display name by taking first value
	SELECT @outputVal =      CASE WHEN LEN(@ownerField)> 0 AND CHARINDEX('||',@ownerField,1) > 0 THEN
	                                          SUBSTRING( @ownerField , 1, CHARINDEX( '||', @ownerField)-1)
	                                    ELSE  @ownerField END
	SET @lastIndexOfSpliter = dbo.LastIndex(@ownerField,@spliter)
	IF((CHARINDEX(@spliter,@outputVal)>0 OR LEN(@outputVal) = 0) AND @lastIndexOfSpliter > 0)
	BEGIN
	      DECLARE @length INT = 0
	      SELECT @length =
	      CASE
	      	WHEN CHARINDEX('/',@ownerField,@lastIndexOfSpliter) > 4 THEN
 				(CHARINDEX('/',@ownerField,@lastIndexOfSpliter) - @lastIndexOfSpliter - 3 )--Exclude the starting string 'CN='
			ELSE (LEN(@ownerField) -  @lastIndexOfSpliter) END
	      		SELECT @outputVal = SUBSTRING(@ownerField,(3 + @lastIndexOfSpliter),@length)
	      END
	      RETURN @outputVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetOwnerFieldDisplayValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetOwnerFieldDisplayValue' AND revision = '1.1')

  insert into GXDBVersions values(5, 'fn_dm2_GetOwnerFieldDisplayValue',  '1.1', 'fn_dm2_GetOwnerFieldDisplayValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/LASTINDEX.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LASTINDEX'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LASTINDEX]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LASTINDEX]
  delete from GXDBVersions where name = 'LASTINDEX' and type = 5
END
GO

	CREATE FUNCTION LASTINDEX ( @inputVal NVARCHAR(MAX), @separator NVARCHAR(20) )
	RETURNS INT
	AS
	BEGIN
      DECLARE @returnVal INT = 0
      IF(CHARINDEX(@separator,@inputVal) > 0)
      BEGIN
            SET @returnVal = LEN(@inputVal) - CHARINDEX(REVERSE(@separator), REVERSE(@inputVal)) + 1 - (LEN(@separator) - 1)
      END
      RETURN @returnVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LASTINDEX]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LASTINDEX' AND revision = '1.2')

  insert into GXDBVersions values(5, 'LASTINDEX',  '1.2', 'LASTINDEX', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/GetLocalTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLocalTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLocalTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLocalTime]
  delete from GXDBVersions where name = 'GetLocalTime' and type = 5
END
GO

	CREATE FUNCTION GetLocalTime (  @DateTimeInput DateTime )
	RETURNS DateTime
	AS
	BEGIN

	DECLARE @minuteDiff INT
	SET @minuteDiff = DATEDIFF(MI, getutcdate(), getdate())
	RETURN DateAdd(MI, @minuteDiff, @DateTimeInput)

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLocalTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLocalTime' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetLocalTime',  '1.1', 'GetLocalTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/split.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: split'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[split]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[split]
  delete from GXDBVersions where name = 'split' and type = 5
END
GO

	CREATE FUNCTION split (@RowData nvarchar(max), @SplitBy nvarchar(5))
	RETURNS @RtnValue table
	(
		Id int identity(1,1),
		Data nvarchar(max)
	)
	WITH ENCRYPTION
	AS
	BEGIN
		Declare @Cnt int
		Set @Cnt = 1
		While (Charindex(@SplitBy,@RowData)>0)
		Begin
			Insert Into @RtnValue (data)
			Select
				Data = ltrim(rtrim(Substring(@RowData,1,Charindex(@SplitBy,@RowData)-1)))
			Set @RowData = Substring(@RowData,Charindex(@SplitBy,@RowData)+1,len(@RowData))
			Set @Cnt = @Cnt + 1
		End
		Insert Into @RtnValue (data)
		Select Data = ltrim(rtrim(@RowData))
		Return
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [split]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'split' AND revision = '1.3')

  insert into GXDBVersions values(5, 'split',  '1.3', 'split', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/isValidSmtpValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isValidSmtpValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isValidSmtpValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isValidSmtpValue]
  delete from GXDBVersions where name = 'isValidSmtpValue' and type = 5
END
GO

	CREATE FUNCTION dbo.isValidSmtpValue (@EmailFieldValue NVARCHAR(MAX))
	RETURNS BIT
	WITH ENCRYPTION
	AS
	BEGIN
		if @EmailFieldValue is not null AND LTRIM(RTRIM(@EmailFieldValue)) <> ''
		BEGIN
		--if all entries are not simply empty or . values
			IF EXISTS (
				SELECT * FROM dbo.split(@EmailFieldValue, ';') A
				WHERE LTRIM(RTRIM(ISNULL(A.Data, ''))) <> '.' AND
				LTRIM(RTRIM(ISNULL(A.Data, ''))) <> ''
			)
			BEGIN
				RETURN 1
			END
		END
		RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isValidSmtpValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isValidSmtpValue' AND revision = '1.1')

  insert into GXDBVersions values(5, 'isValidSmtpValue',  '1.1', 'isValidSmtpValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetEmailFieldValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetEmailFieldValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetEmailFieldValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetEmailFieldValue]
  delete from GXDBVersions where name = 'fn_dm2_GetEmailFieldValue' and type = 5
END
GO

	CREATE FUNCTION dbo.fn_dm2_GetEmailFieldValue (@EmailFieldValue NVARCHAR(MAX))
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
	--DECLARE @EmailFieldValue nvarchar(MAX)
	DECLARE @SplitBy CHAR(1) = ';'
	DECLARE @Data NVARCHAR(1024)
	Declare @Cnt int
	DECLARE @EmailFieldValueOut nvarchar(MAX)
	SELECT @EmailFieldValueOut = '', @Cnt = 1
	if Charindex(@SplitBy, @EmailFieldValue) <= 0
		SET @EmailFieldValue = @EmailFieldValue + ';'
	While (Charindex(@SplitBy,@EmailFieldValue)>0)
	BEGIN
		Select @Data = ltrim(rtrim(Substring(@EmailFieldValue,1,Charindex(@SplitBy,@EmailFieldValue)-1)))
		IF @Data IS NOT NULL
		BEGIN
			SELECT @EmailFieldValueOut = @EmailFieldValueOut + dbo.fn_dm2_GetOwnerFieldDisplayValue(@Data) + @SplitBy
		END
		Set @EmailFieldValue = Substring(@EmailFieldValue,Charindex(@SplitBy,@EmailFieldValue)+1,len(@EmailFieldValue))
		Set @Cnt = @Cnt + 1
	END
	IF RIGHT(@EmailFieldValueOut, 1) = @SplitBy
		SET @EmailFieldValueOut = LEFT(@EmailFieldValueOut, LEN(@EmailFieldValueOut) - 1)
	RETURN @EmailFieldValueOut
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetEmailFieldValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetEmailFieldValue' AND revision = '1.1')

  insert into GXDBVersions values(5, 'fn_dm2_GetEmailFieldValue',  '1.1', 'fn_dm2_GetEmailFieldValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetValuesForEmailFields.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetValuesForEmailFields'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetValuesForEmailFields]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetValuesForEmailFields]
  delete from GXDBVersions where name = 'fn_dm2_GetValuesForEmailFields' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	SET ANSI_NULLS ON
	GO
	CREATE FUNCTION dbo.fn_dm2_GetValuesForEmailFields (@ResultSetTable ResultSetType READONLY)
	RETURNS @emailFieldTable TABLE (
	      subjectField NVARCHAR(MAX),
	      toField NVARCHAR(MAX),
	      fromField NVARCHAR(MAX),
	      bccField NVARCHAR(MAX),
	      ccField NVARCHAR(MAX),
	      resultSetId varchar(36)
	)
	AS
	BEGIN
			SET QUOTED_IDENTIFIER ON
			SET ANSI_NULLS ON
			INSERT INTO @emailFieldTable (subjectField,bccField,ccField,toField,fromField,resultSetId)
	        SELECT
	            ISNULL(ResultSet.value('(//eMail/@subject)[1]', 'nvarchar(max)'), ''),
	            ISNULL(dbo.fn_dm2_GetEmailFieldValue
	            (
					CASE WHEN dbo.isValidSmtpValue(ResultSet.value('(//eMail/@smtpBCC)[1]', 'nvarchar(max)')) = 0 THEN
					ResultSet.value('(//eMail/@bcc)[1]', 'nvarchar(max)')
					ELSE
					ResultSet.value('(//eMail/@smtpBCC)[1]', 'nvarchar(max)')
					END
				), ''),
	            ISNULL(dbo.fn_dm2_GetEmailFieldValue
	            (
					CASE WHEN dbo.isValidSmtpValue(ResultSet.value('(//eMail/@smtpCC)[1]', 'nvarchar(max)')) = 0 THEN
					ResultSet.value('(//eMail/@cc)[1]', 'nvarchar(max)')
	                ELSE ResultSet.value('(//eMail/@smtpCC)[1]', 'nvarchar(max)')
	                END
	            ), ''),
	            ISNULL(dbo.fn_dm2_GetEmailFieldValue
	            (
					CASE WHEN dbo.isValidSmtpValue(ResultSet.value('(//eMail/@smtpTo)[1]', 'nvarchar(max)')) = 0 THEN
					ResultSet.value('(//eMail/@to)[1]', 'nvarchar(max)')
					ELSE ResultSet.value('(//eMail/@smtpTo)[1]', 'nvarchar(max)')
					END
				), ''),
	            ISNULL(dbo.fn_dm2_GetEmailFieldValue
	            (
					CASE WHEN dbo.isValidSmtpValue(ResultSet.value('(//eMail/@smtpFrom)[1]', 'nvarchar(max)')) = 0 THEN
	                ResultSet.value('(//eMail/@from)[1]', 'nvarchar(max)')
	                ELSE ResultSet.value('(//eMail/@smtpFrom)[1]', 'nvarchar(max)')
	                END
	            ), ''),
	            ResultSetID
	        FROM @ResultSetTable
	      RETURN;
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetValuesForEmailFields]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetValuesForEmailFields' AND revision = '1.3')

  insert into GXDBVersions values(5, 'fn_dm2_GetValuesForEmailFields',  '1.3', 'fn_dm2_GetValuesForEmailFields', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/SplitIDs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitIDs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitIDs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitIDs]
  delete from GXDBVersions where name = 'SplitIDs' and type = 5
END
GO

	CREATE FUNCTION dbo.SplitIDs
	(
		@IDsList varchar(max)
	)
	RETURNS
	@ParsedList table
	(
		_ID bigint
	)
	AS
	BEGIN
		DECLARE @_ID varchar(64), @Pos int
		SET @IDsList = LTRIM(RTRIM(@IDsList))+ ','
		SET @Pos = CHARINDEX(',', @IDsList, 1)
		IF REPLACE(@IDsList, ',', '') <> ''
		BEGIN
			WHILE @Pos > 0
			BEGIN
				SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))
				IF @_ID <> ''
				BEGIN
					INSERT INTO @ParsedList (_ID)
					VALUES (CAST(@_ID AS bigint)) --Use Appropriate conversion
				END
				SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)
				SET @Pos = CHARINDEX(',', @IDsList, 1)
			END
		END
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitIDs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitIDs' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SplitIDs',  '1.1', 'SplitIDs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetTurboResultSet.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetTurboResultSet'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetTurboResultSet]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetTurboResultSet]
  delete from GXDBVersions where name = 'fn_dm2_GetTurboResultSet' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO

	CREATE FUNCTION fn_dm2_GetTurboResultSet (@ResultSet  NVARCHAR(MAX), @CommCellNumber int, @aFileId bigint, @aFileOffset bigint)
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
	DECLARE @ResultSetXML XML
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), 'encoding="utf-8"', '')
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), 'encoding="utf-16"', '')
	--Fix root node in case if it does not have any xml header and root node starts right from start..
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX),@ResultSet), '<resultItem', '<DM2ContentIndexing_GResultItem')
	--Fix end tag
	SET @ResultSet = REPLACE(CONVERT(NVARCHAR(MAX), @ResultSet), '</resultItem>', '</DM2ContentIndexing_GResultItem>')
	SET @ResultSetXML = CONVERT(XML, @ResultSet)
	SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@commcellNo)[1] with sql:variable("@CommCellNumber")')
	SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@aFileOffset)[1] with sql:variable("@aFileOffset")')
	SET @ResultSetXML.modify('replace value of (/DM2ContentIndexing_GResultItem/@aFileId)[1] with sql:variable("@aFileId")')
	SET @ResultSet = CONVERT(NVARCHAR(MAX), @ResultSetXML)
	RETURN @ResultSet
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetTurboResultSet]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetTurboResultSet' AND revision = '1.1')

  insert into GXDBVersions values(5, 'fn_dm2_GetTurboResultSet',  '1.1', 'fn_dm2_GetTurboResultSet', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_dm2_GetLastComment.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_dm2_GetLastComment'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_dm2_GetLastComment]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_dm2_GetLastComment]
  delete from GXDBVersions where name = 'fn_dm2_GetLastComment' and type = 5
END
GO

	CREATE FUNCTION fn_dm2_GetLastComment ( @i_UserGuid varchar(36), @i_ContainerId varchar(36), @i_ResultSetId varchar(36) )
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
	DECLARE @comment nvarchar(max)
	SELECT TOP 1 @comment = Comment FROM DMUserComment UC WHERE UC.ResultSetID = @i_ResultSetId AND UC.UserGUID = @i_UserGuid AND UC.ContainerID = @i_ContainerId
	ORDER BY ModifiedTime DESC
	RETURN ISNULL(@comment, '')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_dm2_GetLastComment]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_dm2_GetLastComment' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fn_dm2_GetLastComment',  '1.2', 'fn_dm2_GetLastComment', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/isUpgrade.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isUpgrade'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isUpgrade]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isUpgrade]
  delete from GXDBVersions where name = 'isUpgrade' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO

	CREATE FUNCTION dbo.isUpgrade()
	RETURNS BIT
	AS
	BEGIN
	IF EXISTS (SELECT * FROM DMSetting WHERE SettingName =
		(
		SELECT TOP 1 'IS_UPGRADE_TO_' + Release FROM simAllGalaxyRel
		ORDER BY ID DESC
		)
	)
	BEGIN
		RETURN 1
	END
	RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isUpgrade]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isUpgrade' AND revision = '1.1')

  insert into GXDBVersions values(5, 'isUpgrade',  '1.1', 'isUpgrade', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/DM2Db/Function/fn_HashData.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_HashData'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_HashData]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_HashData]
  delete from GXDBVersions where name = 'fn_HashData' and type = 5
END
GO

 CREATE FUNCTION [dbo].[fn_HashData] (@inputData NVARCHAR(MAX))
	RETURNS VARCHAR(32)
	WITH SCHEMABINDING
	AS
	BEGIN
		DECLARE
			@index int,
			@inputDataLength int,
			@returnSum varbinary(max)

		SET @returnSum = 0
		SET @index = 1
		SET @inputDataLength = DATALENGTH(@inputData)

		WHILE @index <= @inputDataLength
		BEGIN
			SET @returnSum = @returnSum + HASHBYTES('MD5', SUBSTRING(@inputData, @index, 4000))
			SET @index = @index + 4000
		END
		RETURN CONVERT(VARCHAR(32),HASHBYTES('MD5',@returnSum),2)
	END
 Go



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_HashData]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_HashData' AND revision = '1.2')

  insert into GXDBVersions values(5, 'fn_HashData',  '1.2', 'fn_HashData', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
