SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET	@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET	@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET	@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET	@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET	@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET	@colSeperator = ':,:'

DECLARE @errorCode  INTEGER 
SET 	@errorCode = 2

DECLARE @ScriptName NVARCHAR(MAX) = 'Validate authcode for upgrade: '
DECLARE @AuthCode VARCHAR(4000) = ISNULL((select value from GxGlobalParam where name = 'AUTHCODEFORUPGRADE'), '')
DECLARE @regCodeInDB VARCHAR(128) = ISNULL((select csGUID from APP_CommCell where id=2), '')
DECLARE @relIdInDB VARCHAR(2) = ISNULL((select TOP 1 release from SImAllGalaxyRel order by id DESC), '')
DECLARE @relIdUpgTo VARCHAR(2) = '11'
DECLARE @decVal VARCHAR(4000) = ''
DECLARE @regCode VARCHAR(11)
DECLARE @expTime INT
DECLARE @relId VARCHAR(32)

IF @relIdInDB = @relIdUpgTo
BEGIN
	SET @errorCode = 0
	GOTO CX_EXIT
END

IF LEN(@AuthCode) = 0
BEGIN
	PRINT  @ErrorTag + 'This Commcell is not authorized for upgrade.'
	GOTO CX_EXIT
END

SET @regCodeInDB = SUBSTRING(@regCodeInDB,LEN(@regCodeInDB)-9,10)
SELECT @decVal = DecryptByPassphrase(@regCodeInDB, CONVERT(VARBINARY(8000), @AuthCode, 1))
IF @decVal IS NULL OR LEN(@decVal) = 0
BEGIN
	PRINT  @ErrorTag + 'Invalid upgrade authorization code [' + @AuthCode + '].'
	GOTO CX_EXIT
END

SET @regCode = SUBSTRING(@decVal,0,CHARINDEX('_', @decVal))
IF @regCodeInDB <> @regCode
BEGIN
	PRINT  @ErrorTag + 'The upgrade authorization code [' + @AuthCode +'] is not applicable for the current CommServe [' + @regCodeInDB + '].'
	GOTO CX_EXIT
END

SET @decVal = SUBSTRING(@decVal,CHARINDEX('_', @decVal)+1, LEN(@decVal))
SET @relId = SUBSTRING(@decVal,0,CHARINDEX('_', @decVal))
IF @relId <> @relIdUpgTo
BEGIN
	PRINT  @ErrorTag + 'The upgrade authorization code [' + @AuthCode +'] is not applicable for V' + @relIdUpgTo + ' upgrade.'
	GOTO CX_EXIT
END

SET @expTime = CAST(SUBSTRING(@decVal,CHARINDEX('_', @decVal)+1,LEN(@decVal)) AS INT)
IF @expTime < dbo.getUNIXTime(GETUTCDATE())
BEGIN
	PRINT  @ErrorTag + 'The upgrade authorization code has expired on [' + CAST(dbo.UTCToClientLocalTime(dbo.getDateTime(@expTime), 2) AS VARCHAR(256)) + '] (CommServe time).'
	GOTO CX_EXIT
END 

SET @errorCode = 0

CX_EXIT:

IF @errorCode <> 0
BEGIN
	PRINT  @AdviceTag + ' Please email yourupgradeadvisor@commvault.com to request an authorization code.'
	SELECT 2
END
ELSE
BEGIN
	IF @errorCode = 0
		PRINT @ScriptName + 'passed'
	SELECT @errorCode 
END

RETURN

