-- Warning on DB Upgrade if there are any clients with 1-Touch

SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeparator NVARCHAR(20) 
SET			@colSeparator = ':,:'

DECLARE @currentRelease	INTEGER
SET @currentRelease = (SELECT MAX(id) FROM simAllGalaxyRel)

DECLARE @ScriptName	NVARCHAR(MAX)
DECLARE @retCode	INT
DECLARE @errorCode	INT
DECLARE @openCurFlag	INT
DECLARE @clientName	NVARCHAR(MAX)
DECLARE @oneTouchCount INT

SET @ScriptName		= 'Client with 1-Touch not upgradeable check: '
SET @retCode		= 0
SET @errorCode		= 0
SET @openCurFlag	= 0
SET @oneTouchCount 	= 0

PRINT @DescTag + ' Check for clients that cannot be upgraded in this version. Clients with 1-Touch packages cannot be upgraded.'

DECLARE @clientList TABLE ( clientName NVARCHAR(MAX) )

INSERT INTO @clientList 
SELECT name FROM APP_Client
WHERE CAST(ID AS VARCHAR(32)) IN 
(
	SELECT clientId FROM simInstalledPackages 
	WHERE simPackageID in (554)
)

DECLARE	clientsNotUpgradable CURSOR STATIC FOR 
SELECT clientName FROM @clientList
ORDER BY clientName asc

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

OPEN clientsNotUpgradable
SET @openCurFlag = 1
FETCH NEXT FROM clientsNotUpgradable INTO @clientName

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

WHILE @@FETCH_STATUS = 0 
BEGIN
	SET @retCode = 1

	SET @oneTouchCount = @oneTouchCount + 1		
	
	IF @oneTouchCount = 1
	BEGIN
		PRINT @WarningTag + ' The upgrade of 1-Touch Server is not supported.'
		PRINT @AdviceTag  + ' You must uninstall the 1-Touch Server before upgrading the clients.'
		PRINT @HeaderTag  + ' Client Name'
	END
		
	PRINT @DataTag + @clientName
		
	FETCH NEXT FROM clientsNotUpgradable INTO @clientName
	SET	@errorCode = @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END

CX_EXIT:

IF @openCurFlag > 0
BEGIN
	CLOSE clientsNotUpgradable
	DEALLOCATE clientsNotUpgradable
END

IF @errorCode != 0
BEGIN
	PRINT @ScriptName + 'failed with SQL Error [' + CAST(@errorCode AS VARCHAR(20)) + ']'
	SELECT 2
END
ELSE
BEGIN
	IF @retCode = 0
		PRINT @ScriptName + 'passed'
	SELECT @retCode
END

RETURN
