DECLARE @errorCode		INTEGER
DECLARE @newline		CHAR
DECLARE @output			NVARCHAR(MAX)
DECLARE @VSAAppType		INT
DECLARE @agentStatusToSkip	INT

SET @errorCode		= 0
SET @newline		= char(13)
SET @output		= ''
SET @VSAAppType		= 106
SET @agentStatusToSkip	= 22

DECLARE @VSAInstance		TABLE ( t_instanceInfo	NVARCHAR(1024))

INSERT INTO @VSAInstance
SELECT	DISTINCT I.name + '\\' + CASE attrVal WHEN '100' THEN 'ESX instance' ELSE 'XEN instance' END
FROM	APP_Application A	JOIN APP_InstanceName I ON A.instance = I.id AND (I.status & 16) = 0
				JOIN APP_InstanceProp P ON P.componentNameId = A.instance and P.attrName = 'Virtual Server Instance Type' and P.modified = 0
				JOIN APP_Client C	ON A.clientId = C.id
WHERE	C.id = 2 AND A.appTypeId = @VSAAppType AND (A.subclientStatus & @agentStatusToSkip) = 0 AND P.attrVal IN ('100', '201')

IF EXISTS (select * from @VSAInstance)
BEGIN
	SET @errorCode = 2
	SET @output = 'CommServer cannot be upgraded to new release because VSA agent has ESX/XEN instance configured ' + @newline
	SELECT @output = @output + t_instanceInfo + @newline FROM @VSAInstance
	PRINT @output
END

SELECT @errorCode