DECLARE @errorCode	INTEGER
DECLARE @newline	CHAR
DECLARE @output		VARCHAR(MAX)
DECLARE @tempTbl	TABLE (t_id int, t_id2 int default(0))
DECLARE @packagesToSkip	TABLE (t_appTypeId int)

SET @errorCode		= 0
SET @newline		= char(13)

INSERT INTO @packagesToSkip
SELECT type FROM APP_iDAType WHERE name in ('QNet Agent', 'QNET Agent DB on CommServer', 'NAS NDMP', 'Oracle RAC', 'Exchange 2000 Mailbox', 'Exchange 2000 Database', 'Exchange 2000 Web Folder', 'CommCell Explorer', 'CommNet Explorer')

-- Adding all dummy apptypes which is not associated with a package.
-- ignore the old SQL apptype
INSERT INTO @packagesToSkip
SELECT type FROM APP_iDAType WHERE type in (1020, 1076, 1077, 1016, 604, 601, 603, 1092, 1089, 1101, 1100, 1103, 1081, 1113, 1044, 103, 4, 16, 70)


-- Check if patch info table can be converted to simInstalledPackages table. For each apptype, we need to make sure that a packageID is present.
DECLARE @tempTbl2	TABLE (t_cid int, t_appType int, t_osType varchar(100), t_osSubType varchar(100))
INSERT INTO @tempTbl2
SELECT DISTINCT P.clientId, P.appTypeId, O.type, O.SubType
FROM	patchInfo P	JOIN APP_client C ON P.clientId = C.id
			JOIN simSystemOS S ON C.simSystemOSId = S.id
			JOIN simOperatingSystem_DBU O ON S.simOSId = O.id
WHERE	NOT EXISTS (select * from simPackageMap_DBU M where M.appType = P.appTypeId) AND 
	P.appTypeId NOT IN (select t_appTypeId from @packagesToSkip)

IF EXISTS (select * from @tempTbl2)
BEGIN
	SET @output = 'WARNING: some patchInfo records don''t have associated packageID:' + @newline
	SELECT @output = @output + (select name from APP_client where id = t_cid) + ', '
			+ (select name from APP_iDAType where type = t_appType) + @newline
	FROM @tempTbl2

	PRINT @output
END

-- For SimOperatingSystem table, we also need to verify that we have a corresponding simOperatingSystemId.
INSERT INTO @tempTbl (t_id)
SELECT DISTINCT C.id
FROM	APP_Client C JOIN simSystemOS S ON C.simSystemOSId = S.id
WHERE	C.id > 1 AND NOT EXISTS (select * from simOperatingSystem_DBU O where O.id = S.simOSId)
IF EXISTS (select * from @tempTbl)
BEGIN
	SET @output = 'Cannot upgrade APP_Client table because some clients don''t have associated simOSID:' + @newline
	SELECT @output = @output + (select name from APP_client where id = t_id) + @newline
	FROM @tempTbl

	PRINT @output
	SET @errorCode = @errorCode + 1
END

-- 10.0 Upgrade changes
DECLARE @clientWithWebServerClient	TABLE(t_clientId INT, t_packageId INT, t_client VARCHAR(1024), t_package VARCHAR(1024))
DECLARE @clientWithDelayUpgradeAgents	TABLE(t_clientId INT, t_packageId INT, t_client VARCHAR(1024), t_package VARCHAR(1024))
DECLARE @clientWithDeprecatedPackages	TABLE(t_clientId INT, t_packageId INT, t_client VARCHAR(1024), t_package VARCHAR(1024))
DECLARE @DRMediaAgent			TABLE(t_clientId INT, t_packageId INT, t_client VARCHAR(1024), t_package VARCHAR(1024))
DECLARE @clientsNotupgradable		TABLE(t_id int, t_name VARCHAR(MAX))

-- Web Server: 252; Web Service DB: 803; Web Console: 726, 1135; Web Client: 255
INSERT INTO @clientWithWebServerClient
SELECT	DISTINCT clientID, simPackageID, (select name from APP_client where id = clientID), (select name from simPackage_DBU where id = simPackageID)
FROM	patchInfo P JOIN simPackageMap_DBU M ON M.appType = P.appTypeId
WHERE	clientID <> 2 AND simPackageID in (252, 255, 803, 726, 1135)

INSERT INTO @clientWithDeprecatedPackages
SELECT	DISTINCT clientID, simPackageID, (select name from APP_client where id = clientID), (select name from simPackage_DBU where id = simPackageID)
FROM	patchInfo P	JOIN simPackageMap_DBU M ON M.appType = P.appTypeId
			JOIN simPackage_DBU S ON M.simpackageId = S.id
WHERE	(S.flag & 2) > 0

INSERT INTO @clientWithDelayUpgradeAgents
SELECT	DISTINCT clientID, simPackageID, (select name from APP_client where id = clientID), (select name from simPackage_DBU where id = simPackageID)
FROM	patchInfo P 	JOIN simPackageMap_DBU M ON M.appType = P.appTypeId
			JOIN simApptypeProp_DBU A ON A.componentNameId = M.appType AND attrName = 'DelayedAgentUpgradeInfo' AND A.componentNameId <> 106

--Media Agent
INSERT INTO @DRMediaAgent
SELECT	DISTINCT clientID, 51, (select name from APP_client where id = clientID), 'MediaAgent'
FROM	PatchInfo P
WHERE	P.clientID <> 2 AND P.AppTypeId = 1002 AND 
	P.clientID IN (select HostClientId from MMDataPath P	JOIN archGroup G	ON P.CopyId = G.defaultCopy AND (Flag & 1) > 0
								JOIN APP_Application A	ON G.id = A.dataArchGrpID AND A.appTypeId = 1000 )


IF EXISTS (select * from @DRMediaAgent)
BEGIN
	SET @output = 'The following Media Agent is used for DR backup and need to be upgraded immediately after CS upgrade:' + @newline
	SELECT @output = @output + t_client  + ', ' + t_package + @newline 
	FROM @DRMediaAgent
	PRINT @output
END

IF EXISTS (select * from @clientWithWebServerClient)
BEGIN
	SET @output = 'The following clients have webserver or webclient installed and need be upgraded immediately after CS upgrade:' + @newline
	SELECT @output = @output + t_client  + ', ' + t_package + @newline 
	FROM @clientWithWebServerClient

	PRINT @output
END

IF EXISTS (select * from @clientWithDelayUpgradeAgents)
BEGIN
	SET @output = 'The following clients have delay upgraded packages installed and can only be upgraded later. Please refer to the documentation for details.' + @newline
	SELECT @output = @output + t_client  + ', ' + t_package + @newline 
	FROM @clientWithDelayUpgradeAgents

	PRINT @output
END

IF EXISTS (select * from @clientWithDeprecatedPackages)
BEGIN
	SET @output = 'The following clients have deprecated packages installed and cannot be upgraded' + @newline
	SELECT @output = @output + t_client  + ', ' + t_package + @newline 
	FROM @clientWithDeprecatedPackages

	PRINT @output
END

-- Not allow CS upgrade if CS has clients with both immediate upgrade packages & deprecated/deplay upgrade packages installed
INSERT INTO @clientsNotupgradable
SELECT	t_clientId, t_package FROM @clientWithWebServerClient
UNION
SELECT	t_clientId, t_package FROM @DRMediaAgent
DELETE @clientsNotupgradable
WHERE	t_id NOT IN (select t_clientId from @clientWithDelayUpgradeAgents) AND t_id NOT IN (select t_clientId from @clientWithDeprecatedPackages)

-- Not allow CS upgrade if CS has deprecated or delay upgraded packages installed
INSERT INTO @clientsNotupgradable
SELECT	t_clientId, t_package FROM @clientWithDelayUpgradeAgents WHERE t_clientId = 2
UNION
SELECT	t_clientId, t_package FROM @clientWithDeprecatedPackages WHERE t_clientId = 2

IF EXISTS (select * from @clientsNotupgradable WHERE t_id <> 2)
BEGIN
	SET @output = 'The following clients which need to be upgraded immediately also have deprecated or delay upgraded packages installed' + @newline
	SELECT @output = @output + (select name from APP_Client where id = t_id) + ', ' + t_name + @newline 
	FROM @clientsNotupgradable
	WHERE t_id <> 2
	PRINT @output
	SET @errorCode = @errorCode + 1
END

IF EXISTS (select * from @clientsNotupgradable WHERE t_id = 2)
BEGIN
	SET @output = 'CS cannot be upgraded with the following deprecated or delay upgraded packages installed' + @newline
	SELECT @output = @output + t_name + @newline 
	FROM @clientsNotupgradable
	WHERE t_id = 2
	PRINT @output
	SET @errorCode = @errorCode + 1
END


-- tables are dropped in simTableUpgradeCheck.sql
drop table simBinarySet_DBU
drop table simOS_DBU
drop table simSystemOS_DBU
drop table simLicAppTypeV2_DBU
drop table simAppTypeLicTypeMap_DBU
drop table simOEM_DBU
drop table simMiniBrand_DBU
drop table simOEMMap_DBU
drop table simApptypeGroupIDMap_DBU
drop table simAppTypeDependency_DBU
drop table simOperatingSystem_DBU
drop table simApptypeProp_DBU
drop table simPackage_DBU
drop table simPackageMap_DBU
drop table simPackageDependency_DBU

IF @errorCode > 0 
BEGIN
	PRINT 'SIM Preupgrade check failed.'
	SELECT 2
END	
ELSE
BEGIN
	PRINT 'SIM Preupgrade check completed.'
	SELECT 0
END
