SET NOCOUNT ON 

DECLARE @ScriptName	NVARCHAR(128)
DECLARE @ErrorTag	NVARCHAR(20) 
DECLARE @WarningTag	NVARCHAR(20) 
DECLARE @AdviceTag	NVARCHAR(20) 
DECLARE @HeaderTag	NVARCHAR(20) 
DECLARE @DataTag	NVARCHAR(20)
DECLARE @DescTag	NVARCHAR(20) 
DECLARE @colSeperator	NVARCHAR(20) 
DECLARE @errorCode	INT
DECLARE @openCurFlag	INT
DECLARE @clientCnt	INT 
DECLARE @clientName	NVARCHAR(MAX)

SET @ScriptName		= '8.0 client operating system info check: '
SET @ErrorTag		= '###ERROR###'
SET @WarningTag		= '###WARNING###'
SET @AdviceTag		= '###ADVICE###'
SET @HeaderTag		= '###HEADER###'
SET @DataTag		= '###DATA###'
SET @DescTag		= '###DESCRIPTION###'
SET @colSeperator	= ':,:'
SET @errorCode		= 0
SET @openCurFlag	= 0
SET @clientCnt		= 0

PRINT @DescTag + ' Check for client operating system info'

DECLARE	clientsNotUpgradable CURSOR STATIC FOR 
SELECT DISTINCT C.name
FROM	APP_Client C JOIN simSystemOS S ON C.simSystemOSId = S.id
WHERE	C.id > 1 AND NOT EXISTS (select * from simOperatingSystem_DBU O where O.id = S.simOSId)

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

SET @openCurFlag = 1
OPEN clientsNotUpgradable
FETCH NEXT FROM clientsNotUpgradable INTO @clientName

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

WHILE @@FETCH_STATUS = 0 
BEGIN
	SET @clientCnt = @clientCnt + 1

	IF @clientCnt = 1
	BEGIN
		PRINT  @ErrorTag + ' Cannot upgrade APP_Client table because the following clients don''t have associated simOSID'
		PRINT  @HeaderTag + ' Client Name'
	END

	PRINT @DataTag + @clientName

	FETCH NEXT FROM clientsNotUpgradable INTO @clientName
	SET	@errorCode = @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END

CX_EXIT:

IF @openCurFlag > 0
BEGIN
	CLOSE clientsNotUpgradable
	DEALLOCATE clientsNotUpgradable
END

IF @errorCode != 0 OR @clientCnt > 0
BEGIN
	IF @errorCode != 0
		PRINT @ScriptName + 'failed'
	SELECT 2
END
ELSE
BEGIN
	PRINT @ScriptName + 'passed'
	SELECT 0
END

RETURN
