
SET NOCOUNT ON 

DECLARE @ScriptName		NVARCHAR(128)
DECLARE @ErrorTag		NVARCHAR(20) 
DECLARE @WarningTag		NVARCHAR(20) 
DECLARE @AdviceTag		NVARCHAR(20) 
DECLARE @HeaderTag		NVARCHAR(20) 
DECLARE @DataTag		NVARCHAR(20) 
DECLARE @DescTag		NVARCHAR(20) 
DECLARE @colSeperator		NVARCHAR(20) 
DECLARE @retCode		INT
DECLARE @errorCode		INT
DECLARE @openCurFlag		INT
DECLARE @clientCnt		INT
DECLARE @clientName		NVARCHAR(MAX)

SET @ScriptName			= 'Deprecated SharePoint 2003 check: '
SET @ErrorTag			= '###ERROR###'
SET @WarningTag			= '###WARNING###'
SET @AdviceTag			= '###ADVICE###'
SET @HeaderTag			= '###HEADER###'
SET @DataTag			= '###DATA###'
SET @DescTag			= '###DESCRIPTION###'
SET @colSeperator		= ':,:'
SET @retCode			= 0
SET @errorCode			= 0
SET @openCurFlag		= 0
SET @clientCnt			= 0

PRINT @DescTag + ' Check for deprecated SharePoint 2003 Agent'

DECLARE @clientsWithSharePoint	TABLE (t_clientId INT, t_client NVARCHAR(1024))

INSERT INTO @clientsWithSharePoint
SELECT	DISTINCT C.id, C.name
FROM	APP_Client C	JOIN APP_iDAName I	ON C.id = I.clientId AND I.appTypeId = 78
			JOIN APP_iDAProp P	ON P.componentNameId = I.id AND P.attrName = 'IDA Version' AND P.attrVal = '20' AND P.modified = 0

SET	@errorCode = @@ERROR
IF	@errorCode != 0 GOTO CX_EXIT

IF EXISTS (select * from @clientsWithSharePoint	where t_clientId = 2)
BEGIN
	SET @retCode = 2
	PRINT @ErrorTag + ' The CommServe cannot be upgraded because a deprecated SharePoint 2003 Agent has been found.'
	--PRINT  @AdviceTag + ' Please make sure that SharePoint 2003 package is uninstalled and SharePoint 2003 agent is hard deleted from CommCell Console before the CommServer upgrade starts. Be aware that all backed up data will be lost once the agent is deleted.'
	PRINT  @AdviceTag + ' To proceed with the upgrade, you must either upgrade or uninstall the SharePoint 2003 Agent. If you uninstall the agent, but you want to keep the backup data, do not delete the agent icon from the CommCell Console.'
END

DECLARE	clientsWithSharePointCur CURSOR STATIC FOR SELECT t_client FROM @clientsWithSharePoint WHERE t_clientId > 2

SET @openCurFlag = 1
OPEN clientsWithSharePointCur
FETCH NEXT FROM clientsWithSharePointCur INTO @clientName

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

WHILE @@FETCH_STATUS = 0 
BEGIN
	SET @clientCnt = @clientCnt + 1

	IF @clientCnt = 1
	BEGIN
		IF @retCode = 0
			SET @retCode = 1

		PRINT  @WarningTag + ' The following clients have the SharePoint 2003 Agent installed. The agent is no longer supported in the new software version.'
		PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
		PRINT  @HeaderTag + ' Client Name'
	END

	PRINT @DataTag + @clientName

	FETCH NEXT FROM clientsWithSharePointCur INTO @clientName
	SET	@errorCode = @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END

CX_EXIT:

IF @openCurFlag > 0
BEGIN
	CLOSE clientsWithSharePointCur
	DEALLOCATE clientsWithSharePointCur
END

IF @errorCode != 0
BEGIN
	PRINT @ScriptName + 'failed'
	SELECT 2
END
ELSE
BEGIN
	IF @retCode = 0
		PRINT @ScriptName + 'passed'
	SELECT @retCode 
END

RETURN
