SET NOCOUNT ON 

DECLARE @ErrorTag	NVARCHAR(20) 
DECLARE @WarningTag	NVARCHAR(20) 
DECLARE @AdviceTag	NVARCHAR(20) 
DECLARE @HeaderTag	NVARCHAR(20) 
DECLARE @DataTag	NVARCHAR(20) 
DECLARE @DescTag	NVARCHAR(20) 
DECLARE @colSeperator	NVARCHAR(20) 
DECLARE @errorCode	INT

SET @ErrorTag		= '###ERROR###'
SET @WarningTag		= '###WARNING###'
SET @AdviceTag		= '###ADVICE###'
SET @HeaderTag		= '###HEADER###'
SET @DataTag		= '###DATA###'
SET @DescTag		= '###DESCRIPTION###'
SET @colSeperator	= ':,:'
SET @errorCode		= 0

PRINT @DescTag + ' Check for CommNet server package on CommServer'

DECLARE @blockedPkg	TABLE (t_id INT)

INSERT INTO @blockedPkg
SELECT	id
FROM	SimInstalledPackages
WHERE	(clientId = 2 OR clientId in (select PMCLientId from APP_VMToPMMap where VMClientId = 2)) AND SimPackageId IN (601)

IF EXISTS (select * from @blockedPkg)
BEGIN
	SET @errorCode = 1
	PRINT  @WarningTag + ' The CommNet Server package is installed on the CommServe computer. This package is deprecated and the reporting features are replaced with Cloud Metrics Reporting Server.'
	PRINT  @AdviceTag + ' Please uninstall the CommNet Server package before upgrade. See the following documentation link for information on Cloud Metrics Reporting Server http://documentation.commvault.com/commvault/release_10_0_0/books_online_1/english_us/features/reports/metrics/transition_from_commnet.htm'
END

SELECT @errorCode
