SET NOCOUNT ON 

DECLARE @ErrorTag	NVARCHAR(20)
DECLARE @WarningTag	NVARCHAR(20)
DECLARE @AdviceTag	NVARCHAR(20)
DECLARE @HeaderTag	NVARCHAR(20)
DECLARE @DataTag	NVARCHAR(20)
DECLARE @DescTag 	NVARCHAR(20)
DECLARE @colSeperator	NVARCHAR(20)
DECLARE @errorCode	INT
DECLARE @appType	INT
DECLARE @PkgName 	NVARCHAR(256)
DECLARE @FreePermLicensesAvailable INT
DECLARE @FreeEvalLicensesAvailable INT
DECLARE @PermLicensesUsed INT
DECLARE @EvalLicensesUsed INT
DECLARE @TotalAvailableQty INT
DECLARE @usedLicenseCount INT

SET @ErrorTag			= '###ERROR###'
SET @WarningTag			= '###WARNING###'
SET @AdviceTag			= '###ADVICE###'
SET @HeaderTag			= '###HEADER###'
SET @DataTag			= '###DATA###'
SET @DescTag			= '###DESCRIPTION###'
SET @colSeperator		= ':,:'
SET @errorCode			= 0
SET @PkgName			= 'MAC FileSystem'
SET @appType			= (select type from APP_iDAType where name = @PkgName)
SET @PermLicensesUsed			= (select COUNT(*) from LicUsage where AppType = @appType and LicType = 1 and OpType = 'Install' and Eval = 0 and (GETUTCDATE() < ExpiryDateUTC or dbo.GetUnixTime(ExpiryDateUTC) = 0)) 
SET @EvalLicensesUsed			= (select COUNT(*) from LicUsage where AppType = @appType and LicType = 1 and OpType = 'Install' and Eval = 1 and GETUTCDATE() < ExpiryDateUTC )
SET @FreePermLicensesAvailable			= 0
SET @FreeEvalLicensesAvailable			= 0
SET @usedLicenseCount = @PermLicensesUsed +@EvalLicensesUsed

PRINT @DescTag + ' Check for Laptop and Desktop Licenses for Macintosh Clients'

IF (@usedLicenseCount = 0)
BEGIN
	SET @errorCode = 0
	GOTO CX_EXIT
END

DECLARE @retLicData	TABLE (	licName	varchar(1024),
				TotalPermLicensesIssued INTEGER,
				FreePermLicensesAvailable INTEGER,
				TotalEvalLicensesIssued INTEGER,
				FreeEvalLicensesAvailable INTEGER	)
				
INSERT INTO @retLicData
exec QS_GetLicenseInfo 'Laptop and Desktop'
	
SELECT @FreePermLicensesAvailable = FreePermLicensesAvailable , @FreeEvalLicensesAvailable = FreeEvalLicensesAvailable from @retLicData

/*CS has unlimited quantity*/
IF (@FreePermLicensesAvailable < 0)
BEGIN
	SET @errorCode = 0
	GOTO CX_EXIT
END

IF ( (@FreePermLicensesAvailable >= @PermLicensesUsed) and ((@FreeEvalLicensesAvailable < 0) or (@FreePermLicensesAvailable + @FreeEvalLicensesAvailable >= @usedLicenseCount)) )
BEGIN
	SET @errorCode = 0
	GOTO CX_EXIT
END
ELSE if ( (@FreeEvalLicensesAvailable < 0) or (@FreePermLicensesAvailable + @FreeEvalLicensesAvailable >= @usedLicenseCount))
BEGIN
	SET @errorCode = 1
	GOTO CX_EXIT
END
ELSE
BEGIN
	SET @errorCode = 2
	GOTO CX_EXIT
END

CX_EXIT:
BEGIN
	IF @errorCode = 2
	BEGIN
		PRINT  @ErrorTag + ' The CommServe does not have sufficient Laptop and Desktop licenses to upgrade Macintosh clients'
		PRINT  @AdviceTag + ' Contact your Software Provider to obtain the necessary licenses'
	END
	ELSE if @errorCode = 1	
	BEGIN
		PRINT  @WarningTag + cast( (@PermLicensesUsed - @FreePermLicensesAvailable) as varchar(10) ) + ' Permanent licenses will be converted to Evaluation licenses (which expire in 30 days)'
		PRINT  @AdviceTag + ' Make sure that the CommServe has the necessary permanent Laptop and Desktop licenses'
	END
END

SELECT @errorCode
