-- Block DB Upgrade if there is any 9.0 client with service pack less than SP3

SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @ScriptName	NVARCHAR(MAX)
DECLARE @errorCode	INT
DECLARE @openCurFlag	INT
DECLARE @clientCnt	INT
DECLARE @clientRel	INT
DECLARE @clientSP	INT
DECLARE @clientName	NVARCHAR(MAX)

SET @ScriptName		= 'Client service pack check: '
SET @errorCode		= 0
SET @openCurFlag	= 0
SET @clientCnt		= 0

PRINT @DescTag + ' Check for Service Pack level on Clients'

--In the below query exclude the cluster clients. Cluster clients will never have base package registered. But there 
--has been instances reported from the field where the Base package somehow are registered with the cluster client with no service pack.
--This causes the CommServe upgrade to fail.

DECLARE	clientsNotUpgradable CURSOR STATIC FOR 
SELECT	DISTINCT C.name, C.releaseId, MIN(P.HighestSP)
FROM	APP_Client C, simInstalledPackages P 
WHERE	C.id = P.clientId AND C.status & 2 = 0 AND P.simPackageID in (1, 1002) AND NOT EXISTS(select * from APP_ClientProp where attrName = 'Virtual Client' and attrVal = '1' and componentNameId = C.id and modified = 0)
	AND C.id > 2 AND C.releaseId = 14 AND P.HighestSP < 3
GROUP BY C.releaseId, C.name
ORDER BY C.releaseId, C.name

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

SET @openCurFlag = 1
OPEN clientsNotUpgradable
FETCH NEXT FROM clientsNotUpgradable INTO @clientName, @clientRel, @clientSP

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

WHILE @@FETCH_STATUS = 0 
BEGIN
	IF @clientRel = 14
	BEGIN
		SET @clientCnt = @clientCnt + 1

		IF @clientCnt = 1
		BEGIN
			PRINT  @ErrorTag + ' The following version 9 clients have a Service Pack level lower than Service Pack 3.'
			PRINT  @AdviceTag + ' Before you retry the upgrade, make sure that these version 9 clients have Service Pack 3 or later.'
			PRINT  @HeaderTag + ' Client Name' + @colSeperator + 'service pack'
		END
	END


	PRINT @DataTag + @clientName + @colSeperator + CAST(@clientSP as VARCHAR(32))

	FETCH NEXT FROM clientsNotUpgradable INTO @clientName, @clientRel, @clientSP
	SET	@errorCode = @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END


-----------------------------
SET @clientName = ''
SELECT	@clientName = C.name, @clientRel = C.releaseId, @clientSP = P.HighestSP
FROM	APP_Client C	LEFT JOIN APP_VMToPMMap V	ON C.id = V.VMClientId
			JOIN SimInstalledPackages P	ON P.clientId IN (C.id, V.PMClientId) 
WHERE	C.id = 2 AND P.simPackageID = 1 AND (C.releaseId = 14 AND P.HighestSP < 14 OR C.releaseId = 15 AND P.HighestSP < 11)

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

IF LEN(@clientName) > 0
BEGIN
	SET @clientCnt = @clientCnt + 1

	IF @clientRel = 14		
		PRINT  @ErrorTag + ' Your version 9 CommServe computer has a Service Pack level lower than Service Pack 14.'
	ELSE IF @clientRel = 15
		PRINT  @ErrorTag + ' Your version 10 CommServe computer has a Service Pack level lower than Service Pack 11.'

	PRINT  @AdviceTag + ' Before you retry the upgrade, make sure that the CommServe computer has a minimum of V9 Service Pack 14 or V10 Service Pack 11.'
	PRINT  @HeaderTag + ' Client Name' + @colSeperator + 'service pack'
	PRINT @DataTag + @clientName + @colSeperator + CAST(@clientSP as VARCHAR(32))
END

CX_EXIT:

IF @openCurFlag > 0
BEGIN
	CLOSE clientsNotUpgradable
	DEALLOCATE clientsNotUpgradable
END

IF @errorCode != 0 OR @clientCnt > 0
BEGIN
	IF @errorCode != 0
		PRINT @ScriptName + 'failed with SQL Error [' + CAST(@errorCode AS VARCHAR(20)) + ']'
	SELECT 2
END
ELSE
BEGIN
	PRINT @ScriptName + 'passed'
	SELECT 0
END

RETURN
