SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @ScriptName		NVARCHAR(MAX)
DECLARE @retCode		INT
DECLARE @errorCode		INT
DECLARE @CSOSInfo		NVARCHAR(MAX)

SET @ScriptName			= 'CommServe OS check: '
SET @retCode			= 0
SET @errorCode			= 0
SET @CSOSInfo 			= ''

PRINT @DescTag + ' Check for CommServer OS Version'

IF EXISTS (	SELECT	C.id
		FROM	APP_Client C	JOIN simSystemOS S	ON C.simSystemOSId = S.id
					JOIN simOS O		ON S.simOSId = O.id
		WHERE	C.id = 2 and O.Name like '%2003%' )
BEGIN
	SET @retCode = 1

	PRINT  @WarningTag + ' 8.0 CommServer is running on Windows 2003 which is not supported in the new release.'
	PRINT  @AdviceTag + ' Please ensure that new CommServer is running on Windows 2008 or higher OS version.'
END

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

IF EXISTS (	SELECT * 
		FROM	APP_ClientProp C, SImBinarySet B
		WHERE	C.compoNentNameId = 2 and C.attrName = 'Binary Set ID' and C.attrVal = CAST(B.id as NVARCHAR(64)) and 
			C.modified = 0 and B.name = 'win32' )
BEGIN
	SET @retCode = 1

	PRINT  @WarningTag + ' 8.0 CommServer is running on 32bit which is not supported in the new release.'
	PRINT  @AdviceTag + ' Please ensure that new CommServer is running on x64 bit platform.'
END

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

CX_EXIT:

IF @errorCode <> 0
BEGIN
	PRINT @ScriptName + 'failed with SQL Error [' + CAST(@errorCode AS VARCHAR(20)) + ']'
	SELECT 2
END
ELSE
BEGIN
	IF @retCode = 0
		PRINT @ScriptName + 'passed'
	SELECT @retCode 
END

RETURN
