-- Block DB Upgrade if there is any 8.0 client with service pack less than SP3

SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @currentRelease	INTEGER
SET @currentRelease = (SELECT MAX(id) FROM simAllGalaxyRel)

DECLARE @ScriptName	NVARCHAR(MAX)
DECLARE @retCode	INT
DECLARE @errorCode	INT
DECLARE @openCurFlag	INT
DECLARE @clientCnt	INT 
DECLARE @clientName	NVARCHAR(MAX)

SET @ScriptName		= '8.0 client service pack check: '
SET @retCode		= 0
SET @errorCode		= 0
SET @openCurFlag	= 0
SET @clientCnt		= 0

PRINT @DescTag + ' Check for servicepack level on 8.0 clients'

IF @currentRelease = 13
	DECLARE	clientsNotUpgradable CURSOR STATIC FOR 
	SELECT	DISTINCT C.name 
	FROM	APP_Client C, patchInfo P 
	WHERE	C.id = P.clientId AND C.releaseId = 13 AND C.status & 2 = 0 AND P.HighestSP < 6 AND P.appTypeId IN (1001, 1084, 1045)
ELSE
	DECLARE	clientsNotUpgradable CURSOR STATIC FOR 
	SELECT	DISTINCT C.name 
	FROM	APP_Client C, simInstalledPackages P 
	WHERE	C.id = P.clientId AND C.releaseId = 13 AND C.status & 2 = 0 AND P.HighestSP < 6 AND P.simPackageID in (1, 1002)

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

OPEN clientsNotUpgradable
SET @openCurFlag = 1
FETCH NEXT FROM clientsNotUpgradable INTO @clientName

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

WHILE @@FETCH_STATUS = 0 
BEGIN
	SET @retCode = 2

	SET @clientCnt = @clientCnt + 1

	IF @clientCnt = 1
	BEGIN
		PRINT  @ErrorTag + ' The following 8.0 clients have service pack less than SP6.'
		PRINT  @AdviceTag + ' Please make sure these clients have latest 8.0 SP installed before starting DB upgrade again.'
		PRINT  @HeaderTag + ' Client Name'
	END

	PRINT @DataTag + @clientName

	FETCH NEXT FROM clientsNotUpgradable INTO @clientName
	SET	@errorCode = @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END

CX_EXIT:

IF @openCurFlag > 0
BEGIN
	CLOSE clientsNotUpgradable
	DEALLOCATE clientsNotUpgradable
END

IF @errorCode != 0
BEGIN
	PRINT @ScriptName + 'failed with SQL Error [' + CAST(@errorCode AS VARCHAR(20)) + ']'
	SELECT 2
END
ELSE
BEGIN
	IF @retCode = 0
		PRINT @ScriptName + 'passed'
	SELECT @retCode
END

RETURN
