SET NOCOUNT ON

DECLARE @upVerIdMap TABLE (oldUPId INT, newUPId INT)
DECLARE @upVerCounts TABLE (SPVerId INT, UPNubmer INT, correctTransId INT, correctUPVersionId INT, RowCounts INT)

IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[PatchUPVersion]') AND OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN

	INSERT INTO @upVerCounts
	SELECT SPVersionID, UPNumber, MAX(MaxTransactionID), 0, COUNT(*) FROM PatchUPVersion GROUP BY SPVersionID, UPNumber HAVING COUNT(*) > 1
		
	IF EXISTS (SELECT 1 FROM @upVerCounts)
	BEGIN
		UPDATE @upVerCounts 
		SET correctUPVersionId = U.UPVersionId FROM PatchUPVersion U WHERE U.SPVersionId = SPVerId AND U.UPNumber = UPNumber AND U.MaxTransactionId = correctTransId

		INSERT INTO @upVerIdMap
		SELECT U.UPVersionID, C.correctUPVersionId FROM PatchUPVersion U JOIN @upVerCounts C on U.SPVersionID = C.SPVerId AND u.UPNumber = C.UPNubmer AND U.MaxTransactionID <> C.correctTransId
			
		UPDATE PatchCacheUpdatePackMap
		SET UpdatePackID = m.newUPId
		FROM @upVerIdMap m WHERE UpdatePackID = m.oldUPId AND NOT EXISTS (SELECT 1 FROM PatchCacheUpdatePackMap pcup WHERE pcup.UpdatePackID = m.newUPId AND pcup.CacheID = CacheID)
			
		DELETE PatchCacheUpdatePackMap
		FROM @upVerIdMap m
		WHERE UpdatePackId = m.oldUPId
			
		UPDATE PatchUpdatePackPatchesMap
		SET UpdatePackID = m.newUPId
		FROM @upVerIdMap m WHERE UpdatePackID = m.oldUPId AND NOT EXISTS (SELECT 1 FROM PatchUpdatePackPatchesMap pcup WHERE pcup.UpdatePackID = m.newUPId AND pcup.UpdateID = UpdateID)
			
		DELETE PatchUpdatePackPatchesMap
		FROM @upVerIdMap m
		WHERE UpdatePackId = m.oldUPId
			
		DELETE PatchUPVersion
		FROM @upVerIdMap m
		WHERE UPVersionId = m.oldUPId 
	END

	IF EXISTS (SELECT 1 FROM @upVerIdMap)
		PRINT 'Duplicate entries in PatchUPVersion are deleted'
	ELSE
		PRINT 'PatchUPVersion does not have duplicate entries'
	
END

SELECT 0

RETURN

