
SET NOCOUNT ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

DECLARE @ErrorTag	NVARCHAR(20) = '###ERROR###'
DECLARE @WarningTag	NVARCHAR(20) = '###WARNING###'
DECLARE @AdviceTag	NVARCHAR(20) = '###ADVICE###'
DECLARE @HeaderTag	NVARCHAR(20) = '###HEADER###'
DECLARE @DataTag	NVARCHAR(20) = '###DATA###'
DECLARE @DescTag 	NVARCHAR(20) = '###DESCRIPTION###'
DECLARE @errorCode	INT = 0
DECLARE @LicOIName 	NVARCHAR(256) = 'Operating Instances'
DECLARE @LicVOIName NVARCHAR(256) = 'Virtual Operating Instances'
DECLARE @LicName 	NVARCHAR(256) = ''
DECLARE @currentTime int = dbo.GetUNIXTime(GETUTCDATE())
DECLARE @ErrorMsg 		NVARCHAR(256) = ' The CommServe does not have sufficient '
DECLARE @IssuedCountMsg NVARCHAR(256) = 'Number of licenses for '
DECLARE @WarningMsg		NVARCHAR(256) = ''
DECLARE @OIlicTypeId INT = 100032
DECLARE @VOIlicTypeId INT = 100033
DECLARE @nOI	    INT = 0
DECLARE @nVOI	    INT = 0
DECLARE @nDbInstance    INT = 0
DECLARE @HighestSP INT
DECLARE @prevReleaseID INT = 0
DECLARE @isOIValid  INT = 0
DECLARE @isVOIValid INT = 0

DECLARE @evalFld    varchar(1024)
DECLARE @permFld    varchar(1024)
DECLARE @licTypeId  integer
DECLARE @evalTotal  integer
DECLARE @evalUsed   integer
DECLARE @bEval      integer
DECLARE @evalExpiry integer
DECLARE @permTotal  integer
DECLARE @permUsed   integer
DECLARE @bPerm      integer = 0
DECLARE @permExpiry integer = 0
DECLARE @TotalVOILicensesIssued INT = 0
DECLARE @TotalOILicensesIssued  INT = 0
DECLARE @TotalLicensesIssued    INT = 0

PRINT @DescTag + ' Check for OI/VOI License'

SELECT TOP 1 @prevReleaseID = id FROM simAllGalaxyRel WITH (NOLOCK) ORDER BY id DESC

SELECT TOP 1 @HighestSP = HighestSP FROM simInstalledPackages WITH (NOLOCK) WHERE ClientId = 2 AND simPackageID = 801

SELECT @isOIValid = 1 FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = @OIlicTypeId
SELECT @isVOIValid = 1 FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = @VOIlicTypeId

IF @prevReleaseID <> 16 OR @HighestSP < 17 OR @HighestSP >= 23 OR (@isOIValid = 0 AND @isVOIValid = 0)
BEGIN
	SET @errorCode = 0
	GOTO CX_EXIT
END
ELSE 
BEGIN	
	SET @isOIValid = 0
	SET @isVOIValid = 0
	IF object_id('tempdb.dbo.#tmpValidLictypes') IS NOT null DROP TABLE #tmpValidLictypes
		CREATE TABLE #tmpValidLictypes (LicType INT)
	EXEC LicCheckOIStatus '#tmpValidLictypes', 0, 0, @isOIValid OUTPUT, @isVOIValid OUTPUT	
	
	IF object_id('tempdb.dbo.#templic') IS NOT null DROP TABLE #templic
		CREATE TABLE #templic(t_cid int, t_lictype int, t_isVM int default 0)   
	IF object_id('tempdb.dbo.#VMList') IS NOT null DROP TABLE #VMList
		CREATE TABLE #VMList(t_VMid int, t_type int)
	IF object_id('tempdb.dbo.#tempCluster') IS NOT null DROP TABLE #tempCluster
		CREATE TABLE #tempCluster(t_VMClientId int, t_PMClientId int, t_Lictype int)   
    IF object_id('tempdb.dbo.#msimCountTable') IS NOT null DROP TABLE #msimCountTable
		CREATE TABLE #msimCountTable (clientId INT, appTypeId INT, mailbox NVARCHAR(448), mailboxGUID VARCHAR(512), apptypename NVARCHAR(1024), subclientname NVARCHAR(1024), clientname NVARCHAR(1024), subClientId int, instance int,isCIEnabled int)
	EXEC LicGetMSimUserCountV2 1,0
	DECLARE @currentDateUTC DATETIME = GETUTCDATE()
	INSERT INTO #templic
    SELECT cid, LicType,0 FROM LicUsage WITH (NOLOCK) WHERE OpType = 'Install' AND LicType in (1,2,3,16,17,25,127) AND (Eval = 0 OR ExpiryDateUTC > @currentDateUTC)	
	UNION --include Openstack pseudo client 
	SELECT DISTINCT C.id, 100032, 0
	FROM APP_Client C WITH (NOLOCK) 
	INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.clientId = C.id AND (APP.subclientStatus & 6) = 0
	INNER JOIN APP_iDAName IDA WITH (NOLOCK) ON IDA.clientId = APP.clientId AND (iDA.Status & 6) = 0
	INNER JOIN APP_InstanceProp Prop WITH (NOLOCK) ON APP.instance = Prop.componentNameId AND attrName = 'Cloud Apps Instance Type' AND LEN(attrVal) > 0 AND attrVal ='15'
	
    IF object_id('tempdb.dbo.#tempVMToPMList') IS NOT null DROP TABLE #tempVMToPMList
    CREATE TABLE #tempVMToPMList(appTypeId INT,pseudoClientId INT,physClientId INT) 
	
	IF OBJECT_ID('tempdb.dbo.#tmpProxyClientList') IS NOT NULL 
    DROP TABLE #tmpProxyClientList
	CREATE TABLE #tmpProxyClientList(
    ClientId        INTEGER,
    instanceId      INTEGER,
    proxyClientId   INTEGER,
    ClientAppType   INTEGER,
    isIndexServer       INTEGER DEFAULT 0,  --0 meaning proxyclient, 1 meaning INDEX server
    iscloudindexServer  INTEGER DEFAULT 0,    -- 1 meaning cloud INDEX server
    cloudindexServer    INTEGER DEFAULT 0,
    isproxyclientGroup  INTEGER DEFAULT 0 , -- 1 meaning client Group
    clientGroup         INTEGER DEFAULT 0,
    subclientId         INTEGER DEFAULT 0
	)
	CREATE CLUSTERED INDEX #tmpProxyClientList_proxyClientId_ClientId_idx ON #tmpProxyClientList(proxyClientId,ClientId)

	IF object_id('tempdb.dbo.#tmpClientList') IS NOT NULL DROP TABLE #tmpClientList
	CREATE TABLE #tmpClientList
    (   ClientId        integer,
        subclientId     integer,
        INSTANCE        integer,
        appTypeId       integer
    )
	INSERT INTO #tmpClientList
	SELECT DISTINCT t_cid,0,0,0
	FROM #templic

	EXEC AppGetPRoxyClientInfo '#tmpClientList', '#tmpProxyClientList', 1
	INSERT INTO #tempVMToPMList (appTypeId, pseudoClientId, physClientId)			
	SELECT DISTINCT ClientAppType,ClientId,proxyClientId
	FROM #tmpProxyClientList	
	WHERE ClientAppType <> 106 AND isIndexServer = 0 AND  iscloudindexServer = 0 AND ClientId > 0 AND proxyClientId > 0 	
	
	IF OBJECT_ID('tempdb.dbo.#tmpProxyMySql') IS NOT NULL 
    DROP TABLE #tmpProxyMySql
	CREATE TABLE #tmpProxyMySql(appTypeId INT,pseudoClientId INT,physClientId INT)  
	INSERT INTO #tmpProxyMySql
	SELECT DISTINCT t.appTypeId, t.clientId pseudoClientId, a.value('@clientId', 'int') physClientId 
    FROM (
            SELECT a.clientId, a.appTypeId, CAST(ip.attrVal AS XML) data
            FROM APP_Application A WITH (NOLOCK)
            INNER JOIN APP_InstanceProp ip WITH (NOLOCK) ON A.appTypeId = 81 AND ip.componentNameId = A.instance AND ip.attrName = 'Availability Group' AND (A.subclientStatus & 6) = 0
            WHERE dbo.IsPseudoClient(a.clientId) = 1
         ) t
    CROSS APPLY t.data.nodes('App_SQLAvailabilityGroup/primaryReplicaClient') rc(a)
    WHERE a.value('@clientId', 'int') IS NOT NULL 
	
	DELETE T
	FROM #tempVMToPMList T
	INNER JOIN #tmpProxyMySql S ON S.appTypeId = T.appTypeId AND T.pseudoClientId  = S.pseudoClientId 

	INSERT INTO #tempVMToPMList
	SELECT appTypeId,pseudoClientId,physClientId
	FROM #tmpProxyMySql

	DELETE T
	FROM #tempVMToPMList T
	INNER JOIN APP_VMToPMMap M ON T.pseudoClientId = M.VMClientId AND T.physClientId = M.PMClientId 

	INSERT INTO  #tempVMToPMList
	SELECT DISTINCT 134, VMClientId, PMClientId 
	FROM APP_VMToPMMap V WITH (NOLOCK)  
	
	DELETE #tempVMToPMList
	WHERE physClientId IS NULL OR physClientId <= 0
	
	INSERT INTO #tempCluster
    SELECT DISTINCT pseudoClientId, physClientId, U.LicType
    FROM #tempVMToPMList V
    INNER JOIN #templic T ON V.pseudoClientId = T.t_cid
    INNER JOIN LicUsage U WITH (NOLOCK) ON U.cid = V.physClientId AND LicType in (1,2,3,16,17,25,127)
	UNION --add physical nodes which do not consume app class agent licenses due to ACV
	SELECT DISTINCT pseudoClientId, physClientId, T.t_Lictype
	FROM #tempVMToPMList V
	INNER JOIN #templic T ON V.pseudoClientId = T.t_cid
	INNER JOIN APP_IDAName Ida WITH (NOLOCK) ON Ida.clientId = V.physClientId 
	INNER JOIN simAppTypeLicTypeMap Map WITH (NOLOCK) ON Map.appTypeId = Ida.appTypeId AND Map.simLicAppType = T.t_Lictype
	WHERE T.t_Lictype in (3,16,17)
	
    DELETE T
    FROM #templic T
    INNER JOIN #tempCluster C ON T.t_cid = C.t_PMClientId OR T.t_cid = C.t_VMClientId

    INSERT INTO #templic
    SELECT DISTINCT t_PMClientId, t_Lictype, 0
    FROM #tempCluster
    
	--Exclude commserve DR nodes
	DELETE T
	FROM #templic T
	INNER JOIN SimInstalledPackages P WITH (NOLOCK) ON T.t_cid = P.clientid AND P.simpackageid = 24
	INNER JOIN App_application APP WITH (NOLOCK) ON APP.clientId = T.t_cid AND APP.appTypeId = 81

	DECLARE @isMsimValid INT = 0
	DECLARE @licAppliedStatus INT = 0
	DECLARE @isLicInherited INT = 0
	EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
	IF @isLicInherited > 0
		SELECT @isMsimValid = @licAppliedStatus&0x80 
	ELSE
		SELECT @isMsimValid = ISNULL((SELECT simLicAppTypeId FROM licAAL WITH (NOLOCK) WHERE simLicAppTypeId = 100028), 0)

	IF @isMsimValid > 0
	BEGIN
		DELETE #templic
		FROM #msimCountTable 
		WHERE t_cid = clientId
	END

    UPDATE T
    SET t_isVM = 1
    FROM #templic T
    INNER JOIN (SELECT DISTINCT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Machine GUID' and modified = 0) C ON T.t_cid = C.componentNameId
		
	EXEC LicGetVirtualizationDetailsV3
	INSERT INTO #VMList(t_VMid,t_type)
	SELECT ObjectId,LicType
	FROM Lic_CurrentUsage WITH (NOLOCK) WHERE UsageType = 21 OR UsageType = 19		

	MERGE #VMList AS T
    USING (SELECT DISTINCT t_cid FROM #templic WHERE t_isVM = 1) AS S
    ON T.t_VMid = S.t_cid
    WHEN NOT MATCHED BY TARGET
    THEN INSERT (t_VMid,t_type) VALUES (S.t_cid, 100033)
    ;

	DELETE #VMList WHERE t_type <> 100033 AND t_type NOT IN (SELECT LicType From #tmpValidLictypes)
	SELECT @nVOI = count(DISTINCT t_VMid) FROM #VMList

	IF OBJECT_ID('tempdb.dbo.#tempClientOwners') IS NOT NULL DROP TABLE #tempClientOwners
    CREATE TABLE #tempClientOwners (clientId INT, userId INT, PRIMARY KEY(clientId, userId))
    INSERT INTO #tempClientOwners(clientId, userId)
    SELECT DISTINCT clientId, userId FROM dbo.sec_getClientOwners(1) WHERE userId <> 0 

	IF NOT EXISTS (SELECT 1 FROM #tmpValidLictypes WHERE LicType = 200020)
    BEGIN
        DELETE #templic
        FROM (	SELECT DISTINCT t_cid AS cid FROM #templic 
				INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = t_cid		
				WHERE t_lictype = 2 OR C.status & 4096 = 4096 AND C.status & 2 <> 2) L
        INNER JOIN #tempClientOwners O ON L.cid = O.clientId    
        WHERE t_cid = cid   
    END

	IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
		DROP TABLE #ClientInstanceDetails
	CREATE TABLE #ClientInstanceDetails
	(
		[InstanceId] INT,		
		[ClientId] INT,		
		[IdaType] INT,		
		[DbName] NVARCHAR(255)		
		PRIMARY KEY([InstanceId],[ClientId],[DbName])
	)
	--INSERT	INTO #ClientInstanceDetails (InstanceId,ClientId,IdaType,DbName)
	--SELECT	DISTINCT I.id as instanceid, SC.clientId, IP.attrVal, DB.databaseName
	--FROM IdaDBExtendedProp DB WITH (NOLOCK)
	--INNER JOIN APP_InstanceName I WITH (NOLOCK) ON DB.instanceId = I.id
	--INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal IN ('22','23','32')
	--INNER JOIN APP_Application SC WITH (NOLOCK) ON DB.instanceId = SC.instance
	--INNER JOIN APP_IDAName N WITH (NOLOCK) ON N.clientId = SC.clientId and N.appTypeId = 134 and N.status = 0 
	--WHERE (I.status&4) = 0 AND (I.status&16) = 0 AND (I.status&32) = 0 AND (I.status&2048) = 0 
	--UNION
	--SELECT	DISTINCT I.id, SC.clientId, IP.attrVal, DBMap.dbName + ' [' + CVR.RegionCode + ']'
	--FROM	APP_Application SC WITH (NOLOCK)
	--INNER JOIN (SELECT subclientId, dbName, CAST(rsdAttributes AS XML) as rdsXml, regionId
	--			FROM APP_RDSSubclientContentMap WITH (NOLOCK)
	--			WHERE modified = 0) DBMap ON SC.id = DBMap.subclientId
	--INNER JOIN APP_InstanceName I WITH (NOLOCK) ON SC.instance = I.id
	--INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal IN ('4','26','27')
	--INNER JOIN APP_IDAName N WITH (NOLOCK) ON N.clientId = SC.clientId and N.appTypeId = 134 and N.status = 0 
	--INNER JOIN App_CloudVendorRegion CVR WITH (NOLOCK) ON CVR.Id = DBMap.regionId
	--WHERE (I.status&4) = 0 AND (I.status&16) = 0 AND (I.status&32) = 0 AND (I.status&2048) = 0
	
	SELECT @nDbInstance = ISNULL(sum(S.counts),0)
	FROM (SELECT ClientId, count(distinct DbName) as counts from #ClientInstanceDetails GROUP BY ClientId) S

	SELECT @nOI = count(DISTINCT t_cid) FROM #templic WHERE t_isVM = 0
	SET @nOI = @nOI + @nDbInstance

	IF @isOIValid > 0 AND @isVOIValid = 0
    BEGIN
        DELETE #templic WHERE t_isVM = 1
        INSERT INTO #templic SELECT DISTINCT t_VMid,100033,1 FROM #VMList
        SET @nOI = @nOI + @nVOI
        SET @nVOI = 0
	END
    ELSE IF @isOIValid > 0 AND @isVOIValid > 0 AND @nVOI > 0
    BEGIN
        DECLARE @nVOIToOI INT = 0
		EXEC LicVOIToOI @nVOI, @nOI, @nVOIToOI OUTPUT
		IF @nVOIToOI > 0
        BEGIN
            SET @nVOI = @nVOI - @nVOIToOI
            SET @nOI = @nOI + @nVOIToOI
        END
    END
	
	PRINT @DescTag + 'OI Used: ' + cast(@nOI  as varchar(10)) + '; VOI Used: ' + cast(@nVOI  as varchar(10)) 

	IF @nOI = 0 AND @nVOI = 0
	BEGIN
		SET @errorCode = 0
		GOTO CX_EXIT
	END

	BEGIN TRY
	DECLARE licList CURSOR FOR
    SELECT simLicAppTypeId, RTRIM(eval_fld1), RTRIM(perm_fld1) FROM licAAL A WITH (NOLOCK) WHERE  commcellId = 2 AND simLicAppTypeId in (100032,100033)
	OPEN licList
	FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @evalTotal  = 0
		SET @evalUsed   = 0
		SET @bEval      = 0
		SET @evalExpiry = 0
		SET @permTotal  = 0
		SET @permUsed   = 0
		IF len(@evalFld) > 0
		   EXEC dbo.xp_getAALInfo2 @evalFld, @evalTotal OUTPUT, @evalUsed OUTPUT, @bEval OUTPUT, @evalExpiry OUTPUT
		IF len(@permFld) > 0
			EXEC dbo.xp_getAALInfo2 @permFld, @permTotal OUTPUT, @permUsed OUTPUT, @bPerm OUTPUT, @permExpiry OUTPUT
		IF @evalExpiry = 0 OR @evalExpiry > @currentTime
				SET @TotalLicensesIssued = @evalTotal
		IF @permExpiry = 0 OR @permExpiry > @currentTime
		BEGIN
			IF @TotalLicensesIssued < 0 OR @permTotal < 0 
				SET @TotalLicensesIssued = -1
			ELSE
				SET @TotalLicensesIssued = @TotalLicensesIssued + @permTotal
		END
		IF @licTypeId  = 100032
		SET @TotalOILicensesIssued = @TotalLicensesIssued
		ELSE IF @licTypeId  = 100033
		SET @TotalVOILicensesIssued = @TotalLicensesIssued  
		FETCH NEXT FROM licList INTO @licTypeId, @evalFld, @permFld
	END
	CLOSE licList
	DEALLOCATE licList
	
		PRINT @DescTag + 'OI Purchased: ' + cast(@TotalOILicensesIssued as varchar(10)) + '; VOI Purchased: ' + cast(@TotalVOILicensesIssued  as varchar(10)) 
	END TRY
	BEGIN CATCH
		SET @errorCode = 2
		GOTO CX_EXIT
	END CATCH
	
	IF (@TotalOILicensesIssued > 0 AND @TotalOILicensesIssued *1.1 <= @nOI) OR (@TotalVOILicensesIssued > 0 AND @TotalVOILicensesIssued *1.1 <= @nVOI)
	BEGIN
		SET @ErrorMsg = ' The CommServe does not have sufficient OI/VOI licenses.'+CHAR(13)
		SET @IssuedCountMsg += @LicOIName + ' Purchased: ' + cast(@TotalOILicensesIssued as varchar(10)) + ' Used: ' + cast(@nOI as varchar(10)) + '; ' +  @LicVOIName + ' Purchased: ' + cast(@TotalVOILicensesIssued as varchar(10)) + ' Used: ' + cast(@nVOI as varchar(10))
		SET @errorCode = 2	
	END
	ELSE
		SET @errorCode = 0	

	DROP TABLE #tmpValidLictypes
	DROP TABLE #templic
	DROP TABLE #tempCluster
	DROP TABLE #VMList
	DROP TABLE #tempClientOwners
	DROP TABLE #tempVMToPMList
	DROP TABLE #msimCountTable 
	DROP TABLE #ClientInstanceDetails
	DROP TABLE #tmpClientList
	DROP TABLE #tmpProxyClientList
	DROP TABLE #tmpProxyMySql
END			
CX_EXIT:
	IF @errorCode = 2
	BEGIN
		PRINT  @ErrorTag + @ErrorMsg + @IssuedCountMsg 
		PRINT  @AdviceTag + ' Contact your Software Provider to obtain the necessary licenses'
	END	
	PRINT @DescTag + ' errorCode = ' + cast(@errorCode as varchar(10)) 
	IF @errorCode = 2
		SELECT 2
	ELSE IF @errorCode = 1
		SELECT 1
	ELSE
		SELECT 0
RETURN

