SET NOCOUNT ON 

DECLARE @ErrorTag	NVARCHAR(20)
DECLARE @WarningTag	NVARCHAR(20)
DECLARE @AdviceTag	NVARCHAR(20)
DECLARE @HeaderTag	NVARCHAR(20)
DECLARE @DataTag	NVARCHAR(20)
DECLARE @DescTag 	NVARCHAR(20)
DECLARE @colSeperator	NVARCHAR(20)
DECLARE @errorCodeVM	INT
DECLARE @errorCodeSkt	INT
DECLARE @TotalVMLicensesIssued INT
DECLARE @PermVMLicensesIssued INT
DECLARE @EvalVMLicensesIssued INT
DECLARE @TotalSocketLicensesIssued INT
DECLARe @PermSocketLicensesIssued INT
DECLARe @EvalSocketLicensesIssued INT
DECLARE @UsedVMCount INT
DECLARE @UsedSocketCount INT
DECLARE @ErrorMsg 		NVARCHAR(256)
DECLARE @IssuedCountMsg NVARCHAR(256)
DECLARE @VmLicName		NVARCHAR(32)
DECLARE @SktLicName		NVARCHAR(32)
DECLARE @WarningMsg		NVARCHAR(256)
DECLARE @ServicePackRqrd INT


SET @ErrorTag			= '###ERROR###'
SET @WarningTag			= '###WARNING###'
SET @AdviceTag			= '###ADVICE###'
SET @HeaderTag			= '###HEADER###'
SET @DataTag			= '###DATA###'
SET @DescTag			= '###DESCRIPTION###'
SET @colSeperator		= ':,:'
SET @errorCodeVM		= 0
SET @errorCodeSkt 		= 0
SET @TotalVMLicensesIssued		= 0
SET @PermVMLicensesIssued  		= 0
SET @EvalVMLicensesIssued		= 0
SET @TotalSocketLicensesIssued  = 0
SET @PermSocketLicensesIssued	= 0
SET @EvalSocketLicensesIssued  = 0
SET @UsedVMCount			= 0
SET @UsedSocketCount			= 0
SET @ErrorMsg			= ' The CommServe does not have sufficient '
SET @IssuedCountMsg			= 'Number of licenses for '
SET @VmLicName			= 'Protected Virtual Machines'
SET @SktLicName			= 'CPU Sockets on Hypervisor Hosts'
SET @WarningMsg			= ''
SET @ServicePackRqrd = 11

PRINT @DescTag + ' Check for protected Virtual Machines and CPU Sockets on Hypervisor Hosts Licenses'
--Check for servicepack 11.0
IF ( (SELECT TOP 1  HighestSP FROM simInstalledPackages WITH (NOLOCK) WHERE ClientId = 2 AND simPackageID = 801 ) < @ServicePackRqrd)
BEGIN
	select 0
END
ELSE
BEGIN

	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpSubscrptnUsg10'))
		DROP TABLE #tmpSubscrptnUsg10

	CREATE TABLE #tmpSubscrptnUsg10(   
	   nProtectedClient INTEGER,
	   nProtectedVM INTEGER,
	   nArchivedClient INTEGER,
	   nArchivedMailBox INTEGER,
	   nSRMClient INTEGER,
	   nCIServer INTEGER,
	   nAdvSearchNodes INTEGER,
	   nSearchMailBox INTEGER,
	   VMSocket INTEGER,
	   nEpUsers INTEGER,
	   EpSharingUsers INTEGER,
	   EpEdiscoveryUsers INTEGER,
	   UsedDiskSpaceMB BIGINT,
	   AvailDiskSpaceMB BIGINT,
	   DedupDataSizeMB BIGINT,
	   DedupDataOnTapeMB BIGINT,
	   AvailDedupSpaceMB BIGINT,
	   ContentIndexedObject  BIGINT,
	   MailBoxXML           XML,
	   VMXML                XML,
	   SRMxml				XML,
	   CIEngineXML          XML,
	   socketXML            XML,
	   EndPointUserXML      XML,
	   EndPointSharingUser  XML,
	   EndPointEDiscoveryUser XML
	)

	EXEC LicCALUsage 0,0

	SELECT @UsedVMCount = ISNULL(nProtectedVM,0) , @UsedSocketCount = ISNULL(VMSocket,0) from #tmpSubscrptnUsg10

	DECLARE @retLicVMData	TABLE (	licName	varchar(1024),
					TotalPermLicensesIssued INTEGER,
					FreePermLicensesAvailable INTEGER,
					TotalEvalLicensesIssued INTEGER,
					FreeEvalLicensesAvailable INTEGER )
			
	BEGIN TRY
		INSERT INTO @retLicVMData
		exec QS_GetLicenseInfo @VmLicName
		SELECT @PermVMLicensesIssued = ISNULL(TotalPermLicensesIssued,0), @EvalVMLicensesIssued = ISNULL(TotalEvalLicensesIssued,0) from @retLicVMData where licName = @VmLicName
		SET @TotalVMLicensesIssued = @PermVMLicensesIssued + @EvalVMLicensesIssued
	END TRY
	BEGIN CATCH
		SET @TotalVMLicensesIssued = 0
	END CATCH
	
	BEGIN TRY
		INSERT INTO @retLicVMData
		exec QS_GetLicenseInfo @SktLicName
		SELECT @PermSocketLicensesIssued = ISNULL(TotalPermLicensesIssued,0), @EvalSocketLicensesIssued = ISNULL(TotalEvalLicensesIssued,0) from @retLicVMData where licName = @SktLicName
		SET @TotalSocketLicensesIssued = @PermSocketLicensesIssued + @EvalSocketLicensesIssued
	END TRY
	BEGIN CATCH
		SET @TotalSocketLicensesIssued = 0
	END CATCH

	--Check for VM license
	IF(@TotalVMLicensesIssued > 0)
	BEGIN 
	--Consider the soft cap
		IF ( ((@TotalVMLicensesIssued + @TotalVMLicensesIssued*0.1) > @UsedVMCount) or @UsedVMCount = 0)
		BEGIN
			IF (@EvalVMLicensesIssued > 0 and @UsedVMCount > 0)
			BEGIN
				SET @WarningMsg = @VmLicName
				SET @errorCodeVM = 1
			END
			ELSE
				SET @errorCodeVM = 0
		END
		ELSE
		BEGIN
			SET @ErrorMsg += @VmLicName
			SET @IssuedCountMsg += @VmLicName + ' Purchased: ' + cast(@TotalVMLicensesIssued as varchar(10)) + ' Used: ' + cast(@UsedVMCount as varchar(10))
			SET @errorCodeVM = 2
		END
	END
	--Check for Socket license
	IF(@TotalSocketLicensesIssued > 0)
	BEGIN 
	--Consider the soft cap
		IF ( ((@TotalSocketLicensesIssued + @TotalSocketLicensesIssued*0.1) > @UsedSocketCount)  or @UsedSocketCount = 0)
		BEGIN
			IF (@EvalSocketLicensesIssued > 0 and @UsedSocketCount > 0)
			BEGIN
				IF(@errorCodeVM = 1)
					SET @WarningMsg += ' and '
				SET @WarningMsg += @SktLicName
				SET @errorCodeSkt = 1
			END
			ELSE
				SET @errorCodeSkt = 0
		END
		ELSE
		BEGIN
			IF(@errorCodeVM = 2)
			BEGIN 
				SET @ErrorMsg += ' and '
				SET @IssuedCountMsg += ' and for '
			END
			SET @ErrorMsg += @SktLicName
			SET @IssuedCountMsg += @SktLicName + ' Purchased: '+ cast(@TotalSocketLicensesIssued as varchar(10)) + ' Used: ' + cast(@UsedSocketCount as varchar(10))
			SET @errorCodeSkt = 2
		END
	END
	
	SET @ErrorMsg += ' licenses.'+CHAR(13)

	CX_EXIT:
	IF (@errorCodeVM = 2 or @errorCodeSkt = 2)
	BEGIN
		PRINT  @ErrorTag + @ErrorMsg + @IssuedCountMsg 
		PRINT  @AdviceTag + ' Contact your Software Provider to obtain the necessary licenses'
	END
	IF (@errorCodeVM = 1 or @errorCodeSkt = 1)
	BEGIN
		PRINT  @WarningTag + @WarningMsg + ' Evaluation Licenses will expire within 30 days after upgrade'
		PRINT  @AdviceTag + ' Make sure that the CommServe has the necessary permanent licenses'
	END
	IF (@errorCodeVM = 2 or @errorCodeSkt = 2)
		SELECT 2
	ELSE IF (@errorCodeVM = 1 or @errorCodeSkt = 1)
		SELECT 1
	ELSE
		SELECT 0
END