SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

PRINT @DescTag + ' Check for Deduplication Store or Mount path configured on the MediaAgent installation directory'

DECLARE @errorCode  INTEGER

SET @errorCode = 0

DECLARE @retStatus INTEGER

SET @retStatus = 0

DECLARE @tblAllMAs table(MAId int, installDir nvarchar(255), pathSeparator char(1), isConfigured int, clientName nvarchar(255))

INSERT INTO @tblAllMAs
SELECT MA.clientId, PL.install_dir, CASE WHEN LEFT(PL.install_dir,1) = '/' THEN '/' ELSE '\' END, 0, CL.name
FROM MMHost MA WITH(NOLOCK) INNER JOIN App_Platform PL WITH(NOLOCK) 
ON MA.clientId = PL.clientId AND PL.platformType = 2 /*MA platform*/
INNER JOIN App_Client CL ON CL.Id = MA.clientId

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

UPDATE @tblAllMAs
SET installDir = installDir + CASE WHEN RIGHT(installDir, 1) = pathSeparator THEN '%' ELSE pathSeparator + '%' END

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

UPDATE @tblAllMAs SET isConfigured = isConfigured | 1
FROM IdxAccessPath IdxPath WITH(NOLOCK) INNER JOIN IdxSIDBStore Store WITH(NOLOCK) 
ON IdxPath.IdxAccessPathId = Store.IdxAccessPathId 
INNER JOIN @tblAllMAs MA ON MA.MAId = IdxPath.clientId
WHERE IdxPath.path like MA.installDir

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

UPDATE @tblAllMAs SET isConfigured = isConfigured | 2
FROM MMDeviceController dev WITH(NOLOCK) INNER JOIN @tblAllMAs MA ON MA.MAId = dev.clientId
WHERE dev.folder like MA.installDir

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

UPDATE @tblAllMAs SET isConfigured = isConfigured | 2
FROM MMMountPath MP WITH(NOLOCK) INNER JOIN MMDrivePool DP WITH(NOLOCK) ON DP.MasterPoolId = MP.MasterPoolId
INNER JOIN @tblAllMAs MA ON MA.MAId = DP.clientId
WHERE MountPathName like MA.installDir

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

DELETE @tblAllMAS where isConfigured = 0

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

DECLARE @clientName nvarchar(255)

IF NOT EXISTS(SELECT 1 FROM @tblAllMAs)
BEGIN
	PRINT 'No MediaAgents have deduplication store or mount path configured on the installation directory'
	SET @retStatus = 0
	GOTO CX_EXIT
END
ELSE IF NOT EXISTS(SELECT 1 FROM @tblAllMAs WHERE MAId = 2) --CS MA is not affected just throw warning
	SET @retStatus = 1
ELSE
	SET @retStatus = 2

IF EXISTS(SELECT 1 FROM @tblAllMAs WHERE isConfigured = 1)
BEGIN

	DECLARE @output_1 nvarchar(max)
	SET @output_1 = char(10) + CASE WHEN @retStatus = 2 THEN @ErrorTag ELSE @WarningTag END + ' : Deduplication Store is configured on the MediaAgent installation directory.' + char(10)
				+ @AdviceTag + ' Move the store to a new location.' + char(10) + char(10)
				+ @HeaderTag + ' Deduplication Store is configured on the installation directory of the following computers' + char(10)
				+ '---------------------------' + char(10)

	PRINT @output_1

	DECLARE CLIENT_LIST_CURSOR CURSOR FOR 
	SELECT clientName FROM @tblAllMAs WHERE isConfigured = 1

	OPEN CLIENT_LIST_CURSOR

	FETCH NEXT FROM CLIENT_LIST_CURSOR INTO @clientName

	SET	@errorCode	= @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 

	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		PRINT @DataTag + ' ' + @clientName
		FETCH NEXT FROM CLIENT_LIST_CURSOR INTO @clientName

		SET	@errorCode	= @@ERROR 
		IF	@errorCode != 0 GOTO CX_EXIT 

	END

	CLOSE CLIENT_LIST_CURSOR
	DEALLOCATE CLIENT_LIST_CURSOR	
END

IF EXISTS(SELECT 1 FROM @tblAllMAs WHERE isConfigured = 2)
BEGIN
	
	DECLARE @output_2 nvarchar(max)	
	SET @output_2 = char(10) + CASE WHEN @retStatus = 2 THEN @ErrorTag ELSE @WarningTag END + ' : Disk library mount path is configured on the MediaAgent installation directory.' + char(10)
				+ @AdviceTag + ' Change the mount path location and move the contents.' + char(10) + char(10)
				+ @HeaderTag + ' Mount path is configured on the installation directory of the following computers' + char(10)
				+ '---------------------------' + char(10)
	
	PRINT @output_2

	DECLARE CLIENT_LIST_CURSOR CURSOR FOR 
	SELECT clientName FROM @tblAllMAs WHERE isConfigured = 2

	OPEN CLIENT_LIST_CURSOR

	FETCH NEXT FROM CLIENT_LIST_CURSOR INTO @clientName

	SET	@errorCode	= @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 

	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		PRINT @DataTag + ' ' + @clientName
		FETCH NEXT FROM CLIENT_LIST_CURSOR INTO @clientName

		SET	@errorCode	= @@ERROR 
		IF	@errorCode != 0 GOTO CX_EXIT 

	END

	CLOSE CLIENT_LIST_CURSOR
	DEALLOCATE CLIENT_LIST_CURSOR	
END

IF EXISTS(SELECT 1 FROM @tblAllMAs WHERE isConfigured = 3)
BEGIN
	
	DECLARE @output_3 nvarchar(max)
	SET @output_3 = char(10) + CASE WHEN @retStatus = 2 THEN @ErrorTag ELSE @WarningTag END + ' : Deduplication Store and Disk library Mount path are configured on the MediaAgent installation directory.' + char(10)
					+ @AdviceTag + ' Change the mount path location, move the contents, and then move the deduplication store to a new location.' + char(10) + char(10)
					+ @HeaderTag + ' Deduplication Store and Mount path are configured on the installation directory of the following computers' + char(10)
					+ '---------------------------' + char(10)
	
	PRINT @output_3

	DECLARE CLIENT_LIST_CURSOR CURSOR FOR 
	SELECT clientName FROM @tblAllMAs WHERE isConfigured = 3

	OPEN CLIENT_LIST_CURSOR

	FETCH NEXT FROM CLIENT_LIST_CURSOR INTO @clientName

	SET	@errorCode	= @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 

	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		PRINT @DataTag + ' ' + @clientName
		FETCH NEXT FROM CLIENT_LIST_CURSOR INTO @clientName

		SET	@errorCode	= @@ERROR 
		IF	@errorCode != 0 GOTO CX_EXIT 
	END

	CLOSE CLIENT_LIST_CURSOR
	DEALLOCATE CLIENT_LIST_CURSOR	
END

CX_EXIT:

IF(@errorCode != 0)
	SELECT 2
ELSE
	SELECT @retStatus

RETURN
