SET NOCOUNT ON 

DECLARE @output nvarchar(max)
SET @output = char(10) + '#### ERROR : Spaces are not allowed in client names.' + char(10)
				+ '#### Please rename the following client names.' + char(10) + char(10)
				+ 'Client Names with spaces' + char(10)
				+ '---------------------------' + char(10)

DECLARE @clientNameCurFlag  INTEGER 
SET 		@clientNameCurFlag  = 0 

DECLARE @errorCode  INTEGER 
DECLARE @clientName NVARCHAR(510) 
DECLARE @cnt 				INTEGER 
SET     @cnt 				= 0 

DECLARE	clientNameCur CURSOR STATIC FOR 
SELECT name                                   
FROM APP_Client                               
WHERE RTRIM(LTRIM(name)) LIKE ('% %')
AND id > 1   

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @clientNameCurFlag = 1 
OPEN clientNameCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  clientNameCur 
INTO  @clientName

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN 
	SET @cnt = @cnt + 1 

	IF (@cnt = 1)
		PRINT @output
	
	PRINT @clientName

	FETCH NEXT 
	FROM  clientNameCur 
	INTO  @clientName

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END 

IF @cnt = 0 
BEGIN 
	PRINT 'No Client Names have spaces in their name.' 
END 

CX_EXIT: 

IF @clientNameCurFlag = 1 
BEGIN 
	CLOSE	    	clientNameCur 
	DEALLOCATE	clientNameCur 
END


IF @errorCode != 0 OR @cnt > 0
	SELECT 2
ELSE
	SELECT 0

RETURN
                                          