SET NOCOUNT ON 

DECLARE @output nvarchar(max)
SET @output = char(10) + '#### ERROR : One or more snap shots are mounted.' + char(10)
				+ '#### Please unmount all snap shots before upgrade.' + char(10) + char(10)
				+ 'Snap shots to be unmouned:' + char(10)
				+ '---------------------------' + char(10)

DECLARE @CVSM_SNAPMOUNTSTATUS_UNMOUNTED INTEGER
SET @CVSM_SNAPMOUNTSTATUS_UNMOUNTED = 0

DECLARE @snapCurFlag  INTEGER 
SET @snapCurFlag  = 0 

DECLARE @errorCode  INTEGER 
DECLARE @snapMountPath NVARCHAR(2048) 
DECLARE @cnt 		INTEGER 
SET     @cnt 		= 0 

DECLARE	snapCur CURSOR STATIC FOR 
SELECT N'Snapshot mounted at "' + SNAP.SnapMountPath + N'" on client "' + AC.name + N'"'
FROM SMSnapShot SNAP, App_Client AC
WHERE SNAP.MountHostId <> 0
AND SNAP.MountHostId = AC.id

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @snapCurFlag = 1 
OPEN snapCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  snapCur 
INTO	@snapMountPath

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

/*
WHILE @@FETCH_STATUS = 0 
BEGIN 
	SET @cnt = @cnt + 1 

	IF (@cnt = 1)
		PRINT @output
	
	PRINT @snapMountPath

	FETCH NEXT 
	FROM  snapCur 
	INTO	@snapMountPath

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END 
*/

IF @cnt = 0 
BEGIN 
	PRINT 'No snap shots are mounted.' 
END 

CX_EXIT: 

IF @snapCurFlag = 1 
BEGIN 
	CLOSE	    	snapCur 
	DEALLOCATE	snapCur 
END


IF @errorCode != 0 OR @cnt > 0
	SELECT 2
ELSE
	SELECT 0

RETURN
                                          