SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag	NVARCHAR(20) 
SET @HeaderTag		= '###HEADER###'

DECLARE @colSeperator NVARCHAR(20) 
SET @colSeperator		= ':,:'

DECLARE @DataTag NVARCHAR(20) 
SET @DataTag			= '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @pseudoClientIDCurFlag  INTEGER 
SET 		@pseudoClientIDCurFlag  = 0 

DECLARE @errorCode  INTEGER 
DECLARE @pseudoClientId  VARCHAR(16)
DECLARE @physicalClientId VARCHAR(16)
DECLARE @pseudoClientName  VARCHAR(1024)
DECLARE @physicalClientName VARCHAR(1024)
DECLARE @relId INTEGER
DECLARE @relStr VARCHAR(16)
DECLARE @spVer VARCHAR(16)
DECLARE @spMajor VARCHAR(16)
DECLARE @spStr  VARCHAR(4)
DECLARE @cnt 				INTEGER 
SET     @cnt 				= 0
DECLARE @enabled 				NVARCHAR(1024)
DECLARE @majorIndex				INTEGER
DECLARE @minorIndex				INTEGER
DECLARE @spVerLen				INTEGER

PRINT @DescTag + ' Check for installed SAP Archive Link Agents.'

SET @enabled = ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'Patch Allow SAP Archive Link Upgrade'), '')

IF @enabled <> '0' AND @enabled <> ''
	GOTO CX_EXIT

DECLARE	pseudoClientIDCur CURSOR STATIC FOR 
SELECT DISTINCT P.componentNameId, C2.name, C.id, C.name
FROM	App_Client C WITH(NOLOCK) 
		JOIN simInstalledPackages sim WITH(NOLOCK) ON C.id = sim.ClientId 
		JOIN APP_ClientProp P WITH (NOLOCK) CROSS APPLY dbo.SplitIDString(replace(P.attrVal,':',',')) T ON T._ID = C.id
		JOIN App_Client C2 WITH(NOLOCK) ON C2.id = P.componentNameId
WHERE	P.attrName = 'Object Server Member Servers List' AND P.modified = 0 AND (C.releaseId < 16 OR (C.releaseId = 16 AND sim.HighestSP < 7))
		AND sim.simPackageID = 1129

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @pseudoClientIDCurFlag = 1 
OPEN pseudoClientIDCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  pseudoClientIDCur 
INTO  @pseudoClientId, @pseudoClientName, @physicalClientId, @physicalClientName

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN 
	
	SELECT @spVer = MAX(HighestSP) FROM simInstalledPackages WHERE ClientId = @physicalClientId
	SELECT @relId = releaseId FROM App_Client WHERE id = @physicalClientId
	SET @spVerLen = LEN(@spVer)

	SET @majorIndex = PATINDEX('%[0-9]%', @spVer)
	SET @minorIndex = PATINDEX('%[a-z,A-Z]%',@spVer)
	
	IF @minorIndex > 0
		SELECT @spMajor = CONVERT(INTEGER, SUBSTRING(@spVer, @majorIndex, @minorIndex - @majorIndex))
	ELSE
		SELECT @spMajor = CONVERT(INTEGER, SUBSTRING(@spVer, @majorIndex, (@spVerLen - @majorIndex) + 1))
	
	SET @cnt = @cnt + 1 
	
	IF @cnt = 1
	BEGIN
	PRINT @WarningTag + ' Your CommCell environment has clients with [SAP ArchiveLink] installed. Upgrades might be blocked for the clients.'
	PRINT @HeaderTag + ' SAP ArchiveLink Client' + @colSeperator + 'Physical Client' + @colSeperator + 'Client Version' + @colSeperator + 'Client ServicePack'
	END
	
	SET @relStr = (@relId - 5)
	PRINT @DataTag + @pseudoClientName + @colSeperator + @physicalClientName + @colSeperator + @relStr + @colSeperator + @spMajor

	FETCH NEXT 
	FROM  pseudoClientIDCur 
	INTO  @pseudoClientId, @pseudoClientName, @physicalClientId, @physicalClientName

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END

IF @cnt > 0 AND @enabled = ''
PRINT @AdviceTag + ' Please check with support on this.'

CX_EXIT: 

IF @pseudoClientIDCurFlag = 1 
BEGIN 
	CLOSE	    	pseudoClientIDCur 
	DEALLOCATE	pseudoClientIDCur 
END


IF @errorCode != 0
	SELECT 2
ELSE IF (@enabled <> '0' AND @enabled <> '') OR @cnt = 0
	SELECT 0
ELSE
	SELECT 1

RETURN
                                          