SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @errorCode  INTEGER 
SET 		@errorCode = 0

PRINT @DescTag + ' Check whether the CommServe database was partially upgraded'

IF EXISTS (SELECT * FROM GXGlobalParam WHERE Name = N'UpgradeInProgress')
BEGIN
  PRINT @ErrorTag  + ' The CommServe database is partially upgraded from a previous attempt.' 
  PRINT @AdviceTag + ' You must roll back the database and resume the upgrade.' 

  SET @errorCode = 2

  GOTO ERROR_EXIT
END

ERROR_EXIT:
	IF @errorCode != 0 
		SELECT 2
	ELSE
	BEGIN
		PRINT 'Check for partial upgrade succeeded.' 
		SELECT 0
	END

RETURN