--USE commserv
SET NOCOUNT ON

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'
DECLARE @errorCode INTEGER

DECLARE @onePassMAsCount INTEGER	= 0
DECLARE	@clTbl TABLE ( t_ID INTEGER, t_name VARCHAR(256), ReleaseId INTEGER, SPMajor INTEGER)

PRINT @DescTag + ' Check for MediaAgents used by the Exchange and Celerra OnePass'
DECLARE @output nvarchar(max)
SET @output = ''
SET @output = @WarningTag + 'There are some MediaAgents used by Exchange and Celerra OnePass. After the upgrade recalls may not work.' + char(13) 
			+ @AdviceTag + ' Please upgrade the following MediaAgents used by Exchange and Celerra to SP11+ service pack or upgrade to V11.' + char(13)
			-- + 'Following list may not be the complete list' + char(13)
			+ @HeaderTag + ' MediaAgent Name' + char(13) 
			+ '----------------------------' + char(13)

DECLARE @appIDs TABLE (id int, type int)

-- Get list of Celerra One Pass subclients 
-- Query written on basis of APPgetTurboNasSubClientsForProxyClient.sp, filerType 3(NAS_CELERA_TYPE)
Insert into @appIDs
select distinct sc.id, 1
From App_Application(NOLOCK) sc, App_subClientProp(NOLOCK) scProp, App_IdaName(NOLOCK) ida, App_IdaProp(NOLOCK) idaProp
Where ida.id = idaProp.componentNameId 
And idaProp.attrName = N'CELERA_CIFS_PATH' And idaProp.attrVal <>'' And idaProp.modified = 0
And ida.clientId = sc.clientId And ida.appTypeId = sc.appTypeId
And scProp.attrName = N'Turbo NAS Proxy Client' and scProp.modified = 0
And scProp.componentNameId = sc.id


-- Populate the Exchange MB one pass subclients
Insert into @appIDs
select distinct sc.id, 2
From App_Application(NOLOCK) sc, APP_SubClientProp(NOLOCK) scProp
Where sc.appTypeId = 54/*Exchange MailBox*/ 
And scProp.componentNameId = sc.id
And scProp.attrName = 'Is Turbo Subclient' And scProp.modified = 0 And scProp.attrVal = '1'

-- Populate the OnePass MediaAgent list from @appIDs.
INSERT INTO @clTbl
select distinct cli.id, cli.name, 0/*ReleaseId*/, 0/*Service pack number*/
From App_Application(NOLOCK) app, ArchGroup(NOLOCK) arch, MMDataPath(NOLOCK) datapath, App_Client(NOLOCK) cli
Where app.id in(select id from @appIDs) and app.id > 1/*Ignoring Default*/
And app.dataArchGrpID = arch.id And arch.defaultCopy = datapath.CopyId And datapath.HostClientId = cli.id
And datapath.HostClientId > 1

-- Compute the releaseId and service pack number
;WITH ClientSPLevel AS (
        SELECT 
            C.t_ID AS ClientId, 
            CLIENT.ReleaseId AS ReleaseId, 
            PKG.HighestSP AS SPMajor, 
            PKG.SpMinorVersion AS SPMinor, 
            ROW_NUMBER() OVER (PARTITION BY C.t_ID 
            ORDER BY C.t_ID, CLIENT.ReleaseId, PKG.HighestSP, PKG.SpMinorVersion) AS RowNum
        FROM 
                     @clTbl C 
                     LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = C.t_ID
                     INNER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, C.t_ID)
                     INNER JOIN APP_Client CLIENT ON CLIENT.id = ISNULL(MAP.PMClientId, C.t_ID)
        WHERE 
            PKG.simPackageID in (51/*N_WIN_PACKAGE_MEDIAAGENT*/, 1301/*N_UNIX_PACKAGES_MEDIA_AGENT*/))

UPDATE @clTbl
SET           ReleaseId = SPL.ReleaseId,
              SPMajor = SPL.SPMajor
FROM   @clTbl C, ClientSPLevel SPL
WHERE  SPL.RowNum = 1
              AND C.t_ID = SPL.ClientId

-- Remove the mediaAgents that are already upgraded to V11.
-- Remove the mediaAgents that are already upgraded to V10 SP11+ clients.
Delete From @clTbl Where ReleaseId > 15/*SIM_ID_GX_REL100*/ OR (ReleaseId = 15 AND SPMajor >=11)

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SELECT @onePassMAsCount = count(t_id) FROM @clTbl

SELECT @output = @output + @DataTag +  ' ' + t_name + char(13)  from @clTbl

IF @onePassMAsCount = 0 
BEGIN 
	PRINT 'There are no OnePass MediaAgents.'
END 
ELSE
BEGIN
	PRINT @output
END

CX_EXIT: 

IF @errorCode != 0 
	SELECT 2
ELSE IF @onePassMAsCount > 0
	SELECT 1
ELSE
	SELECT 0

	
RETURN