--USE commserv
SET NOCOUNT ON

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'
DECLARE @errorCode INTEGER

DECLARE @lndmClientsCount INTEGER	= 0

DECLARE	@clTbl TABLE ( t_ID INTEGER)

PRINT @DescTag + ' Check for deprecated features for IBM Notes Add-In.'
DECLARE @output nvarchar(max)
SET @output = ''
SET @output = @WarningTag + ' Find and Recovery operation with IBM Notes Add-In is not supported.' + char(13) 
			+ @AdviceTag + ' If you need to perform this operation, do not upgrade the CommServe computer at this time.' + char(13)			

INSERT INTO @clTbl
select ida.clientId
From App_IdaName(NOLOCK) ida
where ida.appTypeId = 90

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SELECT @lndmClientsCount = count(t_id) FROM @clTbl

IF @lndmClientsCount = 0 
BEGIN 
	PRINT 'There are no installed Domino mailbox Archiver Agents.'
END 
ELSE
BEGIN
	PRINT @output
END

CX_EXIT: 

IF @errorCode != 0
	SELECT 2
ELSE IF @lndmClientsCount > 0
	SELECT 1
ELSE
	SELECT 0

	
RETURN