--Retire this script for version 12
SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @MANameCurFlag  INTEGER 
SET 		@MANameCurFlag  = 0 

DECLARE @MACount 		INTEGER 
SET			@MACount		= 0

DECLARE @errorCode  INTEGER 
SET			@errorCode	= 0

DECLARE @retCode  INTEGER 
SET			@retCode	= 0

DECLARE @HostId 	INTEGER 
DECLARE @MAName 	NVARCHAR(510) 
DECLARE @output		NVARCHAR(MAX)

DECLARE @MAWithObjLevelDedupeLic TABLE
(
		HostId		INTEGER,
		MAName		NVARCHAR(510) 
		PRIMARY KEY (HostId)
)

PRINT @DescTag + ' Check for Media Agents with [Single Instancer Data Deduplication Enabler] license'

INSERT INTO @MAWithObjLevelDedupeLic
SELECT DISTINCT AC.id, AC.name
FROM APP_Client AC WITH (NOLOCK), MMHost H WITH (NOLOCK), LicUsage LU WITH (NOLOCK)
WHERE AC.id = H.ClientId
AND	H.ClientId = LU.CId
AND LU.LicType = 132 
AND LU.OpType = 'Install' 
AND (dbo.GetUnixTime(ExpiryDateUTC) = 0 OR ExpiryDateUTC > GETUTCDATE())

SELECT @errorCode	= @@ERROR, @MACount = @@ROWCOUNT
IF	@errorCode != 0 GOTO CX_EXIT 

--If no Media Agents found with Object Level De-Dupe License
IF @MACount = 0 
BEGIN 
	SET @retCode = 0
	PRINT 'No MediaAgents were found with [Single Instancer Data Deduplication Enabler] license.'
	GOTO CX_EXIT
END 

--If Media Agent found with Object Level De-Dupe License is CommServer then fail the Pre-Upgrade check
IF EXISTS (SELECT * FROM @MAWithObjLevelDedupeLic WHERE HostId = 2)
BEGIN
	SET @retCode = 2
	SET @output = @ErrorTag + ' The CommServe cannot be upgraded because a MediaAgent has been found using the "Single Instancer Data Deduplication Enabler" license. This license is deprecated in the latest software version.'
END	
ELSE
--If Media Agent(s) found with Object Level De-Dupe License is not CommServer then just give warning in the Pre-Upgrade check
BEGIN
	SET @retCode = 1
	SET @output = @WarningTag + ' Found one or more MediaAgents that use the "Single Instancer Data Deduplication Enabler" license. This license is deprecated in the latest software version.'
END

--Print Error/Warning
SET @output = @output + CHAR(10) + 'The following (' + CAST(@MACount AS VARCHAR(10)) + ') MediaAgents are using the "Single Instancer Data Deduplication Enabler" license.'
SET @output = @output + CHAR(10) + 'The upgrade will fail for the specified MediaAgents if this is not corrected.' 
SET @output = @output + CHAR(10)

PRINT @output

--Print Header
PRINT @HeaderTag + ' Media Agents'
PRINT '----------------------------'
	
DECLARE	MANameCur CURSOR STATIC FOR 
SELECT HostId, MAName
FROM @MAWithObjLevelDedupeLic

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @MANameCurFlag = 1 
OPEN MANameCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  MANameCur 
INTO  @HostId, @MAName 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN 
	PRINT @DataTag + ' ' + @MAName

	FETCH NEXT 
	FROM  MANameCur 
	INTO  @HostId, @MAName 

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END 

--Print Advice
SET @output = CHAR(10) + @AdviceTag + ' To upgrade the MediaAgents to the latest software version and to continue using the MediaAgents for deduplicated backups, perform the following steps:'
SET @output = @output + CHAR(10) + '	1. If you do not have the [De-duplication Block Level] license, contact the Sales team to obtain this license.' 
SET @output = @output + CHAR(10) + '	2. Before you upgrade the MediaAgents, contact Customer Support to release the [Single Instancer Data Deduplication Enabler] license.'
SET @output = @output + CHAR(10) + '	3. After the MediaAgent upgrade, create a new [De-duplication Block Level] enabled storage policy.'
SET @output = @output + CHAR(10) + '	4. Re-associate existing subclients to the new storage policy and run backup jobs.'
SET @output = @output + CHAR(10)

PRINT @output

CX_EXIT: 

IF @MANameCurFlag = 1 
BEGIN 
	CLOSE	    MANameCur 
	DEALLOCATE	MANameCur 
END

IF @errorCode != 0
	SELECT 2
ELSE
	SELECT @retCode

RETURN
