
SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @LibraryNameCurFlag  INTEGER 
SET 	@LibraryNameCurFlag  = 0 

DECLARE @LibraryCount 	INTEGER 
SET	@LibraryCount	= 0

DECLARE @errorCode  INTEGER 
SET			@errorCode	= 0

DECLARE @retCode  INTEGER 
SET			@retCode	= 0

DECLARE @LibraryId 	INTEGER 
DECLARE @LibraryName 	NVARCHAR(512) 
DECLARE @output		NVARCHAR(MAX)

DECLARE @LibaryWithInvalidMP TABLE
(
	LibraryId		INTEGER,
	LibraryName		NVARCHAR(512),
	MountPathType		INTEGER
	PRIMARY KEY (LibraryId)
)

PRINT @DescTag + ' Checking for Disk Library with DRU or Dynamic Mountpaths configured.'

INSERT INTO @LibaryWithInvalidMP
SELECT ML.LibraryId, ML.LibraryName, MP.MountPathTypeId
FROM MMLibrary ML, MMMountPath MP
WHERE ML.LibraryId > 0 AND ML.LibraryId = MP.LibraryId
	AND MP.MountPathTypeId IN(2, 6) -- MOUNT_PATH_DYNAMIC_SHARED, MOUNT_PATH_DRU


SELECT @errorCode = @@ERROR,	@LibraryCount = @@ROWCOUNT
IF	@errorCode != 0 GOTO CX_EXIT 

--No Library found with DRU or Dynamic Mountpath configured.
IF @LibraryCount = 0 
BEGIN 
	SET @retCode = 0
	PRINT 'No Library found with DRU or Dynamic Mountpath configured.'
	GOTO CX_EXIT
END 

--If Library found with DRU or Dynamic Mountpath configured then fail the Pre-Upgrade check
SET @retCode = 2
SET @output = @ErrorTag + ' Found one or more disk libraries that use Dynamic or DRU Mount paths, which are no longer supported in Version 11.'

--Print Error/Warning
SET @output = @output + CHAR(10) + 'The following (' + CAST(@LibraryCount AS VARCHAR(10)) + ') libraries are configured with DRU or Dynamic Mount paths.'
SET @output = @output + CHAR(10) + 'The upgrade process to Version 11 will fail if this is not corrected.' 
SET @output = @output + CHAR(10)

PRINT @output

--Print Header
PRINT @HeaderTag + ' Library Name'
PRINT '----------------------------'
	
DECLARE	LibraryNameCur CURSOR STATIC FOR 
SELECT LibraryId, LibraryName
FROM @LibaryWithInvalidMP

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @LibraryNameCurFlag = 1 
OPEN LibraryNameCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  LibraryNameCur 
INTO  @LibraryId, @LibraryName 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN 
	PRINT @DataTag + ' ' + @LibraryName

	FETCH NEXT 
	FROM  LibraryNameCur 
	INTO  @LibraryId, @LibraryName 

	SET @errorCode = @@ERROR 
	IF  @errorCode != 0 GOTO CX_EXIT 
END 

--Print Advice
SET @output = CHAR(10) + @AdviceTag + ' Before you upgrade to version 11, deconfigure DRU and Dynamic Mount paths.'
SET @output = @output + CHAR(10)

PRINT @output

CX_EXIT: 

IF @LibraryNameCurFlag = 1 
BEGIN 
	CLOSE	    LibraryNameCur 
	DEALLOCATE  LibraryNameCur 
END

IF @errorCode != 0
	SELECT 2
ELSE
	SELECT @retCode

RETURN