SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

PRINT @DescTag + ' Check for Duplicate Host Names'

DECLARE @output nvarchar(max)
SET @output = char(10) + @ErrorTag + ' : Duplicate client host names found.' + char(10)
				+ @AdviceTag + ' Please resolve the following host name conflicts.' + char(10) + char(10)
				+ @HeaderTag + ' Duplicate Client Host Names' + char(10)
				+ '---------------------------' + char(10)

DECLARE @clientHostNameCurFlag  INTEGER 
SET 	@clientHostNameCurFlag  = 0 

DECLARE @errorCode  INTEGER 
DECLARE @clientHostName NVARCHAR(510) 
DECLARE @clientCount INTEGER 
DECLARE @cnt INTEGER 
SET     @cnt = 0 

DECLARE	clientHostNameCur CURSOR STATIC FOR 
SELECT net_hostname, COUNT(*) AS cnt 
FROM app_client 
GROUP BY net_hostname 
HAVING COUNT(*) > 1 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @clientHostNameCurFlag = 1 
OPEN clientHostNameCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  clientHostNameCur 
INTO  @clientHostName, @clientCount 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN 
	SET @cnt = @cnt + 1 

	IF (@cnt = 1)
		PRINT @output
	
	PRINT @DataTag + ' ' + @clientHostName

	FETCH NEXT 
	FROM  clientHostNameCur 
	INTO  @clientHostName, @clientCount 

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END 

IF @cnt = 0 
BEGIN 
	PRINT 'No duplicate host names for Clients.' 
END 

CX_EXIT: 

IF @clientHostNameCurFlag = 1 
BEGIN 
	CLOSE	    clientHostNameCur 
	DEALLOCATE	clientHostNameCur 
END


IF @errorCode != 0 OR @cnt > 0 
	SELECT 2
ELSE
	SELECT 0

RETURN
