SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

PRINT @DescTag + ' Check for shared client and host names'

DECLARE @output nvarchar(max)
SET @output = char(10) + @ErrorTag + ' : Client or Host names are shared on following clients.' + char(10)
				+ @AdviceTag + ' Please resolve the following client name conflicts.' + char(10) + char(10)
				+ @HeaderTag + ' Client Name' + @colSeperator + 'Host Name' + @colSeperator  + 'Duplicate Client Name' + @colSeperator  + 'Duplicate Host Name' + char(10)
				+ '----------------------' + char(10)

DECLARE @clientNameCurFlag  INTEGER 
SET 	@clientNameCurFlag  = 0 

DECLARE @errorCode  INTEGER 
DECLARE @clientName NVARCHAR(510) 
DECLARE @clientHostName NVARCHAR(510) 
DECLARE @dupClientName NVARCHAR(510) 
DECLARE @dupClientHostName NVARCHAR(510) 
DECLARE @cnt INTEGER 
SET     @cnt = 0 

DECLARE	clientNameCur CURSOR STATIC FOR 
SELECT	DISTINCT C1.Name AS 'ClientName1', C1.net_hostname AS 'HostName1',C2.Name AS 'ClientName2', C2.net_hostname AS 'HostName2'
FROM	APP_Client C1, APP_Client C2
WHERE	C1.id < C2.id
		AND (C1.name = C2.net_hostname OR C1.net_hostname = C2.name)

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

SET @clientNameCurFlag = 1 
OPEN clientNameCur 

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

FETCH NEXT 
FROM  clientNameCur 
INTO  @clientName, @clientHostName, @dupClientName, @dupClientHostName

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN 
	SET @cnt = @cnt + 1 
	
	IF (@cnt = 1)
		PRINT @output
	
	PRINT @DataTag + ' ' + @clientName + @colSeperator + @clientHostName + @colSeperator + @dupClientName + @colSeperator + @dupClientHostName

	FETCH NEXT 
	FROM  clientNameCur 
	INTO  @clientName, @clientHostName, @dupClientName, @dupClientHostName

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END 

IF @cnt = 0
BEGIN 
	PRINT 'No shared names or host names for Clients.' 
END 

CX_EXIT: 

IF @clientNameCurFlag = 1 
BEGIN 
	CLOSE	    clientNameCur 
	DEALLOCATE	clientNameCur 
END

IF @errorCode != 0 OR @cnt > 0 
	SELECT 2
ELSE
	SELECT 0

RETURN