
SET NOCOUNT ON 

DECLARE @ScriptName		NVARCHAR(128)
DECLARE @ErrorTag		NVARCHAR(20) 
DECLARE @WarningTag		NVARCHAR(20) 
DECLARE @AdviceTag		NVARCHAR(20) 
DECLARE @HeaderTag		NVARCHAR(20) 
DECLARE @DataTag		NVARCHAR(20) 
DECLARE @DescTag		NVARCHAR(20) 
DECLARE @colSeperator		NVARCHAR(20) 
DECLARE @retCode		INT
DECLARE @errorCode		INT

SET @ScriptName			= 'Deprecated Database versions check: '
SET @ErrorTag			= '###ERROR###'
SET @WarningTag			= '###WARNING###'
SET @AdviceTag			= '###ADVICE###'
SET @HeaderTag			= '###HEADER###'
SET @DataTag			= '###DATA###'
SET @DescTag			= '###DESCRIPTION###'
SET @colSeperator		= ':,:'
SET @retCode			= 0
SET @errorCode			= 0

PRINT @DescTag + ' Check for deprecated Database versions'

/* Minimum Supported DB versions */
DECLARE @oraMajor INT = 10
DECLARE @oraMinor INT = 1
DECLARE @db2Ver NVARCHAR(32) = N'SQL09050'
DECLARE @sybMajor INT = 15
DECLARE @sybMinor INT = 0
DECLARE @infMajor INT = 11
DECLARE @infMinor INT = 5
DECLARE @mysqlMajor INT = 5
DECLARE @mysqlMinor INT = 5
DECLARE @postgresMajor INT = 9
DECLARE @postgresMinor INT = 2

DECLARE @oracleVersion		TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @DB2Version			TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @sybaseVersion		TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @informixVersion	TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @mysqlVersion		TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @postgresVersion	TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))

DECLARE @clientName NVARCHAR(1024)
DECLARE @instanceName NVARCHAR(1024)
DECLARE @version NVARCHAR(512)
DECLARE @clientNotUpgradable INT = 0
DECLARE @minorVersion INT
DECLARE @majorVersion INT
DECLARE @tempVer NVARCHAR(32)
DECLARE @tempBuffer NVARCHAR(512) = N''
DECLARE @headersPrinted INT = 0

INSERT	INTO @oracleVersion
SELECT	DISTINCT A.clientID, C.name, IP.componentNameId, I.name, IP.attrVal
FROM	APP_Application A
		INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
		INNER JOIN APP_InstanceName I ON A.instance = I.id
		INNER JOIN APP_Client C ON A.clientID = C.id
WHERE	A.appTypeId IN (22, 61, 80)
	AND	IP.modified = 0
	AND IP.attrName = 'Oracle Version'
	AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)

INSERT	INTO @DB2Version
SELECT	DISTINCT A.clientID, C.name, IP.componentNameId, I.name, IP.attrVal
FROM	APP_Application A
		INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
		INNER JOIN APP_InstanceName I ON A.instance = I.id
		INNER JOIN APP_Client C ON A.clientID = C.id
WHERE	A.appTypeId IN (37, 62, 103)
	AND	IP.modified = 0
	AND IP.attrName = 'DB2 Version'
	AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)

INSERT	INTO @sybaseVersion
SELECT	DISTINCT A.clientID, C.name, IP.componentNameId, I.name, IP.attrVal
FROM	APP_Application A
		INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
		INNER JOIN APP_InstanceName I ON A.instance = I.id
		INNER JOIN APP_Client C ON A.clientID = C.id
WHERE	A.appTypeId IN (5, 126)
	AND	IP.modified = 0
	AND IP.attrName = 'SYBASE version'
	AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)

INSERT	INTO @informixVersion
SELECT	DISTINCT A.clientID, C.name, IP.componentNameId, I.name, IP.attrVal
FROM	APP_Application A
		INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
		INNER JOIN APP_InstanceName I ON A.instance = I.id
		INNER JOIN APP_Client C ON A.clientID = C.id
WHERE	A.appTypeId = 3
	AND	IP.modified = 0
	AND IP.attrName = 'Informix Version'
	AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)

INSERT	INTO @mysqlVersion
SELECT  DISTINCT A.clientID, C.name, IP.componentNameId, I.name,
	CASE WHEN CHARINDEX('Distrib ', IP.attrVal) > 0
		 THEN SUBSTRING(IP.attrVal, CHARINDEX('Distrib ', IP.attrVal) + 8, 5)
		 ELSE IP.attrVal
	END
FROM    APP_Application A
	INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
	INNER JOIN APP_InstanceName I ON A.instance = I.id
	INNER JOIN APP_Client C ON A.clientID = C.id
WHERE   A.appTypeId = 104
	AND     IP.modified = 0
	AND IP.attrName = 'MySQL version'
	AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)

INSERT	INTO @postgresVersion
SELECT  DISTINCT A.clientID, C.name, IP.componentNameId, I.name, IP.attrVal
FROM    APP_Application A
	INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
	INNER JOIN APP_InstanceName I ON A.instance = I.id
	INNER JOIN APP_Client C ON A.clientID = C.id
WHERE   A.appTypeId = 125
	AND     IP.modified = 0
	AND IP.attrName = 'PostgreSQL version'
	AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)

SET	@errorCode = @@ERROR
IF	@errorCode != 0 GOTO CX_EXIT

-- Oracle
DECLARE	oracleInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @oracleVersion WHERE t_clientId > 2

OPEN oracleInstCur
FETCH NEXT FROM oracleInstCur INTO @clientName, @instanceName, @version

WHILE @@FETCH_STATUS = 0 
BEGIN

	SET @minorVersion = 0
	SET @majorVersion = 0
	SET @tempVer = ''
	SET @tempBuffer = ''

	-- Calculate Major Version & Minor version numbers
	IF @version IS NOT NULL
	BEGIN
		IF CHARINDEX('.', @version) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @majorVersion = CAST (@tempVer AS INT)
		END
		SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))

		IF CHARINDEX('.', @tempBuffer) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @minorVersion = CAST (@tempVer AS INT)
		END
	END

	IF @majorVersion < @oraMajor OR (@majorVersion = @oraMajor AND @minorVersion < @oraMinor)
		SET @clientNotUpgradable = 1
	ELSE
		SET @clientNotUpgradable = 0

	IF @clientNotUpgradable = 1
	BEGIN
		IF @headersPrinted = 0
		BEGIN
			IF @retCode = 0
				SET @retCode = 1

			PRINT  @WarningTag + ' The following clients have database versions that are no longer supported in the latest software version.'
			PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
			PRINT  @HeaderTag + 'Client Name' + @colSeperator + 'Instance Name' + @colSeperator + 'Database' + @colSeperator + 'Version'
			SET @headersPrinted = 1
		END

		PRINT @DataTag + ' ' + @clientName + @colSeperator + @instanceName + @colSeperator + 'Oracle' + @colSeperator + @version
	END

	FETCH NEXT FROM oracleInstCur INTO @clientName, @instanceName, @version
	SET	@errorCode = @@ERROR
END

CLOSE oracleInstCur
DEALLOCATE oracleInstCur

IF	@errorCode != 0 GOTO CX_EXIT 

-- DB2
DECLARE	db2InstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @db2Version WHERE t_clientId > 2

OPEN db2InstCur
FETCH NEXT FROM db2InstCur INTO @clientName, @instanceName, @version

WHILE @@FETCH_STATUS = 0 
BEGIN

	IF @version < @db2Ver
		SET @clientNotUpgradable = 1
	ELSE
		SET @clientNotUpgradable = 0

	IF @clientNotUpgradable = 1
	BEGIN
		IF @headersPrinted = 0
		BEGIN
			IF @retCode = 0
				SET @retCode = 1

			PRINT  @WarningTag + ' The following clients have database versions that are no longer supported in the latest software version.'
			PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
			PRINT  @HeaderTag + 'Client Name' + @colSeperator + 'Instance Name' + @colSeperator + 'Database' + @colSeperator + 'Version'
			SET @headersPrinted = 1
		END

		PRINT @DataTag + ' ' + @clientName + @colSeperator + @instanceName + @colSeperator + 'DB2' + @colSeperator + @version
	END

	FETCH NEXT FROM db2InstCur INTO @clientName, @instanceName, @version
	SET	@errorCode = @@ERROR
END

CLOSE db2InstCur
DEALLOCATE db2InstCur

IF	@errorCode != 0 GOTO CX_EXIT 

-- Sybase
DECLARE	sybaseInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @sybaseVersion WHERE t_clientId > 2

OPEN sybaseInstCur
FETCH NEXT FROM sybaseInstCur INTO @clientName, @instanceName, @version

WHILE @@FETCH_STATUS = 0 
BEGIN

	SET @minorVersion = 0
	SET @majorVersion = 0
	SET @tempVer = ''
	SET @tempBuffer = ''

	-- Calculate Major Version & Minor version numbers
	IF @version IS NOT NULL
	BEGIN
		SET @version = SUBSTRING(@version, CHARINDEX('/', @version) + 1, LEN(@version))
		SET @version = SUBSTRING(@version, 1, CHARINDEX('/', @version) - 1)
		IF CHARINDEX('.', @version) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @majorVersion = CAST (@tempVer AS INT)
		END
		SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))

		IF CHARINDEX('.', @tempBuffer) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @minorVersion = CAST (@tempVer AS INT)
		END
		ELSE IF ISNUMERIC(@tempBuffer) = 1
		BEGIN
			SET @minorVersion = CAST(@tempBuffer AS INT)
		END
	END

	IF @majorVersion < @sybMajor OR (@majorVersion = @sybMajor AND @minorVersion < @sybMinor)
		SET @clientNotUpgradable = 1
	ELSE
		SET @clientNotUpgradable = 0

	IF @clientNotUpgradable = 1
	BEGIN
		IF @headersPrinted = 0
		BEGIN
			IF @retCode = 0
				SET @retCode = 1

			PRINT  @WarningTag + ' The following clients have database versions that are no longer supported in the latest software version.'
			PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
			PRINT  @HeaderTag + 'Client Name' + @colSeperator + 'Instance Name' + @colSeperator + 'Database' + @colSeperator + 'Version'
			SET @headersPrinted = 1
		END

		PRINT @DataTag + ' ' + @clientName + @colSeperator + @instanceName + @colSeperator + 'Sybase' + @colSeperator + @version
	END

	FETCH NEXT FROM sybaseInstCur INTO @clientName, @instanceName, @version
	SET	@errorCode = @@ERROR
END

CLOSE sybaseInstCur
DEALLOCATE sybaseInstCur

IF	@errorCode != 0 GOTO CX_EXIT 

-- Informix
DECLARE	informixInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @informixVersion WHERE t_clientId > 2

OPEN informixInstCur
FETCH NEXT FROM informixInstCur INTO @clientName, @instanceName, @version

WHILE @@FETCH_STATUS = 0 
BEGIN

	SET @minorVersion = 0
	SET @majorVersion = 0
	SET @tempVer = ''
	SET @tempBuffer = ''

	-- Calculate Major Version & Minor version numbers
	IF @version IS NOT NULL
	BEGIN
		IF CHARINDEX('.', @version) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @majorVersion = CAST (@tempVer AS INT)
		END
		SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))

		IF CHARINDEX('.', @tempBuffer) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @minorVersion = CAST (@tempVer AS INT)
		END
	END

	IF @majorVersion < @infMajor OR (@majorVersion = @infMajor AND @minorVersion < @infMinor)
		SET @clientNotUpgradable = 1
	ELSE
		SET @clientNotUpgradable = 0

	IF @clientNotUpgradable = 1
	BEGIN
		IF @headersPrinted = 0
		BEGIN
			IF @retCode = 0
				SET @retCode = 1

			PRINT  @WarningTag + ' The following clients have database versions that are no longer supported in the latest software version.'
			PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
			PRINT  @HeaderTag + 'Client Name' + @colSeperator + 'Instance Name' + @colSeperator + 'Database' + @colSeperator + 'Version'
			SET @headersPrinted = 1
		END

		PRINT @DataTag + ' ' + @clientName + @colSeperator + @instanceName + @colSeperator + 'Informix' + @colSeperator + @version
	END

	FETCH NEXT FROM informixInstCur INTO @clientName, @instanceName, @version
	SET	@errorCode = @@ERROR
END

CLOSE informixInstCur
DEALLOCATE informixInstCur

IF	@errorCode != 0 GOTO CX_EXIT 

-- MySQL
DECLARE	mysqlInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @mysqlVersion WHERE t_clientId > 2

OPEN mysqlInstCur
FETCH NEXT FROM mysqlInstCur INTO @clientName, @instanceName, @version

WHILE @@FETCH_STATUS = 0 
BEGIN

	SET @minorVersion = 0
	SET @majorVersion = 0
	SET @tempVer = ''
	SET @tempBuffer = ''

	-- Calculate Major Version & Minor version numbers
	IF @version IS NOT NULL
	BEGIN
		IF CHARINDEX('.', @version) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @majorVersion = CAST (@tempVer AS INT)
		END
		SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))

		IF CHARINDEX('.', @tempBuffer) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @minorVersion = CAST (@tempVer AS INT)
		END
	END

	IF @majorVersion < @mysqlMajor OR (@majorVersion = @mysqlMajor AND @minorVersion < @mysqlMinor)
		SET @clientNotUpgradable = 1
	ELSE
		SET @clientNotUpgradable = 0

	IF @clientNotUpgradable = 1
	BEGIN
		IF @headersPrinted = 0
		BEGIN
			IF @retCode = 0
				SET @retCode = 1

			PRINT  @WarningTag + ' The following clients have database versions that are no longer supported in the latest software version.'
			PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
			PRINT  @HeaderTag + 'Client Name' + @colSeperator + 'Instance Name' + @colSeperator + 'Database' + @colSeperator + 'Version'
			SET @headersPrinted = 1
		END

		PRINT @DataTag + ' ' + @clientName + @colSeperator + @instanceName + @colSeperator + 'MySQL' + @colSeperator + @version
	END

	FETCH NEXT FROM mysqlInstCur INTO @clientName, @instanceName, @version
	SET	@errorCode = @@ERROR
END

CLOSE mysqlInstCur
DEALLOCATE mysqlInstCur

IF	@errorCode != 0 GOTO CX_EXIT 

-- PostgreSQL
DECLARE	postgresInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @postgresVersion WHERE t_clientId > 2

OPEN postgresInstCur
FETCH NEXT FROM postgresInstCur INTO @clientName, @instanceName, @version

WHILE @@FETCH_STATUS = 0 
BEGIN

	SET @minorVersion = 0
	SET @majorVersion = 0
	SET @tempVer = ''
	SET @tempBuffer = ''

	-- Calculate Major Version & Minor version numbers
	IF @version IS NOT NULL
	BEGIN
		IF CHARINDEX('.', @version) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @majorVersion = CAST (@tempVer AS INT)
		END
		SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))

		IF CHARINDEX('.', @tempBuffer) > 0
		BEGIN
			SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
			IF ISNUMERIC(@tempVer) = 1
				SET @minorVersion = CAST (@tempVer AS INT)
		END
	END

	IF @majorVersion < @postgresMajor OR (@majorVersion = @postgresMajor AND @minorVersion < @postgresMinor)
		SET @clientNotUpgradable = 1
	ELSE
		SET @clientNotUpgradable = 0

	IF @clientNotUpgradable = 1
	BEGIN
		IF @headersPrinted = 0
		BEGIN
			IF @retCode = 0
				SET @retCode = 1

			PRINT  @WarningTag + ' The following clients have database versions that are no longer supported in the latest software version.'
			PRINT  @AdviceTag + ' The clients will continue to operate in backward compatibility mode.'
			PRINT  @HeaderTag + 'Client Name' + @colSeperator + 'Instance Name' + @colSeperator + 'Database' + @colSeperator + 'Version'
			SET @headersPrinted = 1
		END

		PRINT @DataTag + ' ' + @clientName + @colSeperator + @instanceName + @colSeperator + 'PostgreSQL' + @colSeperator + @version
	END

	FETCH NEXT FROM postgresInstCur INTO @clientName, @instanceName, @version
	SET	@errorCode = @@ERROR
END

CLOSE postgresInstCur
DEALLOCATE postgresInstCur

IF	@errorCode != 0 GOTO CX_EXIT 

CX_EXIT:

IF @errorCode != 0
BEGIN
	PRINT @ScriptName + 'failed'
	SELECT 2
END
ELSE
BEGIN
	IF @retCode = 0
		PRINT @ScriptName + 'passed'
	SELECT @retCode 
END

RETURN
