--USE commserv
SET NOCOUNT ON

DECLARE @output nvarchar(2048)
SET @output = '#### ERROR : There is some database inconsistency for Clients.' + char(13)
				+ 'Client Names' + char(13)
				+ '----------------------' + char(13)

DECLARE @danglingclientNameCurFlag	INTEGER
DECLARE @danglingClientsCount		INTEGER
DECLARE @existingRelId			INTEGER
DECLARE @upgradeToRelId			INTEGER

SET @danglingclientNameCurFlag	= 0
SET @danglingClientsCount	= 0
SET @upgradeToRelId		= 14

SELECT @existingRelId = MAX (ReleaseId) FROM licUsage
IF @existingRelId > 12
	GOTO CX_EXIT

DECLARE	@clTbl	TABLE ( cID INTEGER)
DECLARE	@clTbl1	TABLE ( cID INTEGER)

DECLARE @errorCode  INTEGER
DECLARE @clientName NVARCHAR(510)
DECLARE @releaseID  INTEGER
DECLARE @cID  INTEGER

DECLARE	danglingclientNameCur CURSOR FOR
	SELECT DISTINCT Name,Releaseid,cid AS cnt
	FROM licUsage
	WHERE ReleaseId < (@upgradeToRelId -2) AND LicType NOT IN (71, 10, 26)

SET @danglingclientNameCurFlag = 1
OPEN danglingclientNameCur

FETCH NEXT 
FROM  danglingclientNameCur 
INTO  @clientName,@releaseID, @cID

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

WHILE @@FETCH_STATUS = 0 
BEGIN
	DECLARE @tempReleaseID  INTEGER
	IF EXISTS (select * from simClientAppsV2 where clientId = @cID)
	BEGIN
		set @tempReleaseID = (select max(releaseid) from simClientAppsV2 where clientId = @cID) 
		if(@tempReleaseID > @releaseID) 
		BEGIN
			SET @danglingClientsCount = @danglingClientsCount + 1
			IF EXISTS (SELECT * FROM APP_CLIENT Where id = @cID)
				INSERT INTO @clTbl SELECT @cID
		END
	END

	FETCH NEXT
	FROM  danglingclientNameCur
	INTO  @clientName,@releaseID, @cID

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
END

INSERT INTO @clTbl1 select distinct cID from @clTbl

SELECT @output = @output +  (select name from app_client where id = cID) + char(13)  from @clTbl1

CX_EXIT: 

IF @danglingClientsCount = 0 
BEGIN 
	PRINT 'DB is consistent.' 
END 
ELSE
BEGIN
	PRINT @output
END

IF @danglingclientNameCurFlag = 1 
BEGIN 
    CLOSE	    danglingclientNameCur 
    DEALLOCATE	danglingclientNameCur 
END

IF @errorCode != 0 OR @danglingClientsCount > 0
    SELECT 2
ELSE
	SELECT 0
	
RETURN