-- Block DB Upgrade if there is any DDB Hosting 9.0 MA with service pack less than SP14

SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @ScriptName	NVARCHAR(MAX)
DECLARE @errorCode	INT
DECLARE @openCurFlag	INT
DECLARE @clientCnt	INT 
DECLARE @clientName	NVARCHAR(MAX)

SET @ScriptName		= 'Version 9 DDB Hosting MediaAgents service pack check: '
SET @errorCode		= 0
SET @openCurFlag	= 0
SET @clientCnt		= 0

PRINT @DescTag + ' Check for Service Pack level on MediaAgents hosting the Deduplication database (DDB)'

--In the below query exclude the cluster clients. Cluster clients will never have base package registered. But there 
--has been instances reported from the field where the Base package somehow are registered with the cluster client with no service pack.
--This causes the CommServe upgrade to fail.

DECLARE	masNotUpgradable CURSOR STATIC FOR 
SELECT	DISTINCT C.name 
FROM	APP_Client C WITH (NOLOCK) , simInstalledPackages P WITH (NOLOCK) , IdxSIDBStore SS WITH (NOLOCK) 
WHERE	C.id = P.clientId 
		AND C.releaseId = 14 
		AND C.status & 2 = 0 
		AND P.HighestSP < 14 
		AND P.simPackageID in (1, 1002)
		AND NOT EXISTS(select * from APP_ClientProp where attrName = 'Virtual Client' and attrVal = '1' and componentNameId = C.id and modified = 0)
		AND	C.id = SS.ClientId
		AND	SS.SIDBStoreId > 0
		AND	SS.Status != 1		-- IDX_SIDBSTORE_STATUS_CORRUPTED  (Non corrupted stores)
		AND	SS.SealedTime = 0
		AND SS.firstBackupTime > 0
		AND EXISTS (SELECT * FROM archCopySIDBStore ACS WHERE ACS.SIDBStoreId = SS.SIDBStoreId)

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

SET @openCurFlag = 1
OPEN masNotUpgradable
FETCH NEXT FROM masNotUpgradable INTO @clientName

SET	@errorCode = @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT

WHILE @@FETCH_STATUS = 0 
BEGIN
	SET @clientCnt = @clientCnt + 1

	IF @clientCnt = 1
	BEGIN
		PRINT  @ErrorTag + ' The following version 9 MediaAgents hosting the DDB have a low Service Pack level.'
		PRINT  @AdviceTag + ' Before you retry the upgrade, make sure these MediaAgents have a minimum of Service Pack 14.'
		PRINT  @HeaderTag + ' MediaAgent Name'
	END

	PRINT @DataTag + @clientName

	FETCH NEXT FROM masNotUpgradable INTO @clientName
	SET	@errorCode = @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END

CX_EXIT:

IF @openCurFlag > 0
BEGIN
	CLOSE masNotUpgradable
	DEALLOCATE masNotUpgradable
END

IF @errorCode != 0 OR @clientCnt > 0
BEGIN
	IF @errorCode != 0
		PRINT @ScriptName + 'failed with SQL Error [' + CAST(@errorCode AS VARCHAR(20)) + ']'
	SELECT 2
END
ELSE
BEGIN
	PRINT @ScriptName + 'passed'
	SELECT 0
END

RETURN
