--USE commserv
SET NOCOUNT ON

DECLARE @output nvarchar(2048)

declare @errorCode int
declare @numCorruptedStores int
declare @cursorFlag int
declare @SPName NVARCHAR(288)
declare @sizeOnSP bigint
DECLARE @cnt 		INTEGER 
SET     @cnt 		= 0 



CREATE      TABLE #StoreToJobs (jobid int, archgroupId int, SPName NVARCHAR(288), archCopyId int, copyname nvarchar(128), StoreId int, StoreName NVARCHAR(256), siloAppId int, sizeOfJob bigint)

insert into #StoreToJobs
select jobId, archgroupid, storagepolicyname, archcopyid, copyname, StoreId, storename, 0, 0
from archjobsonstoreinfo where storeid in (select sidbstoreid from idxsidbstore where status = 1)

set @numCorruptedStores = @@ROWCOUNT

update #StoreToJobs
set siloappid = ac.siloAppId
from archgroupcopy AC
where #StoreToJobs.archcopyid = ac.id

update #StoreToJobs
set sizeOfJob = T.totalSize
from (
      SELECT      AF.jobId, AF.commCellId, SUM(ACM.physicalSize) as totalSize
      FROM  archFile AF WITH (NOLOCK), archChunkMapping ACM WITH (NOLOCK), #StoreToJobs Jobs
      WHERE Jobs.JobId = AF.jobId and AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1 AND AF.appId <> Jobs.siloAppId
            AND ACM.archCopyId = Jobs.archcopyId
      GROUP BY AF.jobId, AF.commCellId
) as T
where T.JobId = #StoreToJobs.JobId

declare @totalSize bigint
declare @TB bigint
set @TB = (1099511627776)
select @totalSize = ((sum (sizeOfJob))/@TB) from #StoreToJobs

select @output = 'There are one or more DeDuplication Database stores that have been sealed due to abnormal termination. 
There is [' + cast( @totalSize as varchar) + '] TB of space that will be freed only if all jobs associated to these stores are aged. This aging is completed at the Macro Level. 
It is possible to complete an Auxiliary Copy for these storage policy(ies) and free the space on the Magnetic Library associated with the sealed stores. The list affected of storage policy(ies) is/are:' + char(13)
				+ 'SP-Name            Size-occupied-in-GB' + char(13)
				+ '--------------------------------------' + char(13)


DECLARE	CorruptStoreSPsCur CURSOR FOR 
	select SPName, sum(sizeOfJob)/(1024*1024*1024) as SizeOccupiedByCorruptStoreGB
	from #StoreToJobs
	group by SPName

SET @cursorFlag = 1 

OPEN CorruptStoreSPsCur
FETCH NEXT 
FROM  CorruptStoreSPsCur
INTO  @SPName, @sizeOnSP

SET	@errorCode	= @@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 


WHILE @@FETCH_STATUS = 0 
BEGIN 
	SET @cnt = @cnt + 1 

	IF (@cnt = 1)
		PRINT @output

	select @output = @SPName + '    ' + cast (@sizeOnSP AS varchar) + char(13)
	PRINT @output

	FETCH	NEXT 
	FROM 	CorruptStoreSPsCur
	INTO	@SPName, @sizeOnSP

	SET	@errorCode	=	@@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 
END 


drop table #StoreToJobs


CX_EXIT: 



IF @cursorFlag = 1 
BEGIN 
	CLOSE	    CorruptStoreSPsCur
	DEALLOCATE	CorruptStoreSPsCur
END 

if (@cnt > 0)
	select 0
else
begin
	print 'There are no corrupted stores'
	select 0
end

	
RETURN
