--warning message if there are workflows from outside our software store installed.

SET NOCOUNT ON 

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

DECLARE @errorCode  INTEGER 
SET			@errorCode	= 0

DECLARE @retCode  INTEGER 
SET			@retCode	= 0

DECLARE @sfStoreWFCount  INTEGER 
SET			@sfStoreWFCount	= 0

DECLARE @WFName NVARCHAR(MAX) 
DECLARE @WFNameCurFlag INTEGER

DECLARE @sfStoreWFList NVARCHAR(MAX)
SET @sfStoreWFList = '''Log Shipping'',''Relocate MediaAgent Mount Path'',''VM Package Deployment'',''AWS Snapshot Schedule Configuration'',''CV Failover Configuration Workflow'',''AWS Manage Snapshot'',''Analytics'',''SetVLANProperty'',
					''Generate and Embed Report To Mail'',''Create VM'',''Relocate MediaAgent'',''eDiscovery Exception Report'',''Optimize Search Engine'',''DeconfigInactiveClients'',''SetGlobalFilterOnCommCell'''

PRINT @DescTag + ' Check for workflows not associated with Commvault Software Store.'

select @sfStoreWFCount = count(*) from WF_Definition where not(flags & 4 > 0) and (activityid is not null) and Name not in (@sfStoreWFList)

SET @errorcode = @@ERROR
IF	@errorCode != 0 GOTO CX_EXIT

IF @sfStoreWFCount > 0
BEGIN
	SET @retCode = 1
	PRINT  @WarningTag + ' The following workflows are not part of the Commvault Software Store. When you upgrade to V11, the workflows may stop working.'

	PRINT @HeaderTag + ' Workflow Name'
	PRINT '----------------------------'
	
	DECLARE	WFNameCur CURSOR STATIC FOR 
	SELECT Name
	from WF_Definition where not(flags & 4 > 0) and (activityid is not null) and Name not in (@sfStoreWFList)

	SET	@errorCode	= @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 

	SET @WFNameCurFlag = 1 
	OPEN WFNameCur 

	SET	@errorCode	= @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 

	FETCH NEXT 
	FROM  WFNameCur 
	INTO  @WFName 

	SET	@errorCode	= @@ERROR 
	IF	@errorCode != 0 GOTO CX_EXIT 

	WHILE @@FETCH_STATUS = 0 
	BEGIN 
		PRINT @DataTag + ' ' + @WFName

		FETCH NEXT 
		FROM  WFNameCur 
		INTO  @WFName

		SET	@errorCode	=	@@ERROR 
		IF	@errorCode != 0 GOTO CX_EXIT 
	END 

	PRINT  @AdviceTag + ' Before you upgrade your production commcell to V11, run the workflows on a test V11 setup.'
END

CX_EXIT: 

IF @WFNameCurFlag = 1 
BEGIN 
	CLOSE	    WFNameCur 
	DEALLOCATE	WFNameCur 
END

IF @errorCode != 0
BEGIN
	SELECT 2
END
ELSE
BEGIN
	SELECT @retCode 
END

RETURN
