SET NOCOUNT ON

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @errorCode  INTEGER 
SET 		@errorCode = 0

PRINT @DescTag + ' Check for existence of CCM Databases'


IF EXISTS (select 1 from sys.databases where name in ('Commserv_Capture', 'Commserv_Merge', 'Commserv_Convert', 'Commserv_Capture_80', 'Commserv_Capture_90'))
BEGIN
	DECLARE @DatabaseList varchar(1024) = ''
	SELECT @DatabaseList = @DatabaseList + name + + ', '   
	FROM sys.databases WHERE name in ('Commserv_Capture', 'Commserv_Merge', 'Commserv_Convert', 'Commserv_Capture_80', 'Commserv_Capture_90')
	SET @DatabaseList = LEFT(@DatabaseList, LEN(@DatabaseList)-1)
	
	PRINT @WarningTag  + ' CCM databases [' + @DatabaseList + '] exists in SQL Server.' 
	PRINT @AdviceTag + ' Please drop CCM databases [' + @DatabaseList + '] and resume the upgrade.' 

	SET @errorCode = 1

	GOTO ERROR_EXIT
END

ERROR_EXIT:
	IF @errorCode != 0 
		SELECT 1
	ELSE
	BEGIN
		PRINT 'Check for existence of CCM Databases succeeded.' 
		SELECT 0
	END

RETURN