IF ((SELECT TOP 1 CAST(value AS VARCHAR(10))FROM GXGlobalParam WHERE name = 'OldReleaseNumber') IN ('9.0')) 
BEGIN
	IF object_id('TM_TempOptionsTable888') is not null DROP TABLE TM_TempOptionsTable888

	SELECT * 
	INTO TM_TempOptionsTable888
	FROM TM_JobOptions
	WHERE jobId=0 
	OR jobId IN (SELECT jobId FROM JMJobInfo)

	TRUNCATE TABLE TM_JobOptions

	INSERT INTO TM_JobOptions 
	SELECT jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified 
	FROM TM_TempOptionsTable888

	--MARK COMPLETED ANY NO-SCHEDULE JOBS
	UPDATE TM_Jobs SET status=2
	WHERE jobRequestId IN (
		SELECT jobRequestId 
		FROM TM_JobRequest 
		WHERE subTaskId NOT IN (
			SELECT subTaskId FROM TM_TempOptionsTable888
		)
	) AND status <> 2

	DROP TABLE TM_TempOptionsTable888
END

--REMOVE ENTRIES WHICH HAVE ALREADY BEEN PRUNE IN TM_Jobs TABLE
DELETE TM_JobRequest
FROM TM_JobRequest JR
LEFT OUTER JOIN TM_Jobs TJ WITH (NOLOCK) ON TJ.jobRequestId = JR.jobRequestId
WHERE TJ.status IS NULL
