		--------------------------------------------------------------------------------
		----   HANDLE DOWNLOAD CENTER ASSOCIATION WITH WEBSERVER DURING UPGRADE   ------
		--------------------------------------------------------------------------------

BEGIN
		--applicable only for upgrade form 10.0 => 11.0
		declare @upgradeFromRel integer = 0		
		SELECT @upgradeFromRel = status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'
		IF (@upgradeFromRel = 15) --10.0
		BEGIN			
			DECLARE @dcClientId INT = ISNULL((select CONVERT (INT, value) from GXGlobalParam where name = 'DOWNLOAD_CENTER_CLIENT_ID_RETRY'),0)
			IF EXISTS (SELECT * FROM APP_Client WITH (NOLOCK) WHERE id = @dcClientId)
			BEGIN
				DECLARE @EV_MANAGE_DOWNLOADCENTER INT  = 41				
				DECLARE @EV_MANAGE_DOWNLOADCENTER_CAP BIGINT  = CAST(POWER(2.0, (@EV_MANAGE_DOWNLOADCENTER-1)) as BIGINT)
				DECLARE @SERVER_GROUP_NAME_ITEM INT= 2572
				DECLARE @CLIENT_ITEM INT= 2009
				DECLARE @COMMCELL_ENTITY INT= 1
				DECLARE @CLIENT_ENTITY INT= 3
				DECLARE @CLIENT_GROUP_ENTITY INT= 28
				DECLARE @COMM_CELL_ITEM INT= 2018		

				DECLARE @systemOWnerCapabilities BIGINT = ISNULL(( select value from GXGlobalParam where name like 'SystemOwnerCapibilities'),0)

				IF object_id('tempdb.dbo.#dcOwnerUserAndGrpClientAssoc') IS NOT null DROP TABLE #dcOwnerUserAndGrpClientAssoc
				CREATE TABLE #dcOwnerUserAndGrpClientAssoc(groupId INT, userId INT, providerId INT, clientId INT, permissionId INT)			

				--AT OWNER LEVEL GET ALL USERS & USERGROUP WITH EV_MANAGE_DOWNLOADCENTER CAPABILITY ON CLIENTS				
				INSERT INTO #dcOwnerUserAndGrpClientAssoc (groupId, userId, providerId, clientId, permissionId)			
				SELECT groupId, userId, providerId, objectId , @EV_MANAGE_DOWNLOADCENTER
				FROM UMUserandGroupEntityAssociation 
				WHERE entityType= @CLIENT_ITEM  And 
						((capabilities & @EV_MANAGE_DOWNLOADCENTER_CAP <>0) 
							OR  (	@systemOWnerCapabilities & @EV_MANAGE_DOWNLOADCENTER_CAP<>0 ) 
						OR    ( objectId in 
								  (		SELECT clientId 
										from  APP_ClientGroupAssoc 
										where clientGroupId in 
											(	select objectId 
												from UMUserandGroupEntityAssociation 
												where entityType=@SERVER_GROUP_NAME_ITEM and capabilities & @EV_MANAGE_DOWNLOADCENTER_CAP<>0 and userid = 0 and groupId = 0
											)
								   )
							 ))
							 and (userId <>0 OR groupId<>0)

							 			
			--A) USER GROUP + DOWNLOAD CENTER + ANY ENTITY
				INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)			
                SELECT DISTINCT @EV_MANAGE_DOWNLOADCENTER, gc.groupId,  0 , @CLIENT_ENTITY, @dcClientId, 1 
                FROM UMGroupCapability GC					
				WHERE GC.groupId NOT IN (SELECT id FROM UMGroups WHERE (allCapabilities =1 and allassociations =1)) 
				AND ( GC.capabilityId = @EV_MANAGE_DOWNLOADCENTER OR GC.groupId IN (SELECT id FROM UMGroups WHERE allCapabilities =1 and allassociations =0))
                AND  GC.capabilityId  NOT IN (SELECT permissionId
                                            FROM UMSecurityAssociations 
                                            WHERE userOrGroupId = gc.groupId
                                                  AND isuser = 0
												  AND permissionId = @EV_MANAGE_DOWNLOADCENTER  
												  AND (entityType1 = @CLIENT_ENTITY AND entityId1 = @dcClientId 
                                                  AND entityType2 = 0 AND entityId2 = 0 
                                                  AND entityType3 = 0 AND entityId3 = 0
                                                  AND entityType4 = 0 AND entityId4 = 0 
                                                  AND entityType5 = 0 AND entityId5 = 0 AND isCreator = 0))
				

			--B) OWNER LEVEL + FOR USER_GROUP + AT CLIENT (OWNER) ENTITY ->  DOWNLOAD CENTER
				INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)			
                SELECT DISTINCT UGE1.permissionId , UGE1.groupId,  0 , @CLIENT_ENTITY, @dcClientId, 1 
                FROM  #dcOwnerUserAndGrpClientAssoc UGE1 				
				WHERE UGE1.groupId > 0
					AND UGE1.userId = 0				
					AND NOT EXISTS (SELECT permissionId
                                            FROM UMSecurityAssociations 
                                            WHERE userOrGroupId = UGE1.groupId
													AND isuser = 0
													AND permissionId = @EV_MANAGE_DOWNLOADCENTER	--EV_MANAGE_DOWNLOADCENTER
													AND (entityType1 = @CLIENT_ENTITY AND entityId1 = @dcClientId  --3 =CLIENT_ENTITY
													AND entityType2 = 0 AND entityId2 = 0 
													AND entityType3 = 0 AND entityId3 = 0
													AND entityType4 = 0 AND entityId4 = 0 
													AND entityType5 = 0 AND entityId5 = 0 AND isCreator = 0))
				AND UGE1.groupId NOT IN (SELECT id FROM UMGROUPS WHERE (allCapabilities =1 and allassociations =1))

			--C) OWNER LEVEL + FOR USER + AT CLIENT (OWNER) ENTITY ->  DOWNLOAD CENTER
				INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)			
				SELECT DISTINCT UGE1.permissionId , UGE1.userId,  1 , @CLIENT_ENTITY, @dcClientId,  1 
                FROM  #dcOwnerUserAndGrpClientAssoc UGE1 	
				WHERE UGE1.groupId = 0
					AND UGE1.userId > 0					
					AND NOT EXISTS (SELECT permissionId
                                            FROM UMSecurityAssociations 
                                            WHERE userOrGroupId = UGE1.userId
													AND isuser = 1
													AND permissionId = @EV_MANAGE_DOWNLOADCENTER
													AND (entityType1 = @CLIENT_ENTITY AND entityId1 = @dcClientId  
													AND entityType2 = 0 AND entityId2 = 0 
													AND entityType3 = 0 AND entityId3 = 0
													AND entityType4 = 0 AND entityId4 = 0 
													AND entityType5 = 0 AND entityId5 = 0 AND isCreator = 0))
				AND UGE1.userId NOT IN (SELECT userId FROM UMUserGroup WHERE groupId in (SELECT id FROM UMGROUPS WHERE (allCapabilities =1 and allassociations =1) ))			
			
			IF object_id('tempdb.dbo.#dcOwnerUserAndGrpClientAssoc') IS NOT null DROP TABLE #dcOwnerUserAndGrpClientAssoc
        END			
	END	
END


