		------------------------------------------------------------------
		---		HANDLE NEW ANALYTICS PERMISSION DURING UPGRADE		---
		------------------------------------------------------------------

BEGIN
		--upgrade form 10.0 11.0 older builds
		declare @upgradeFromRel integer = 0		
		SELECT @upgradeFromRel = status FROM DBUpgradeSteps WHERE Step = 'UpgradeFromRelease'
		IF (@upgradeFromRel = 15) --10.0
		BEGIN			
			DECLARE @SERVER_GROUP_NAME_ITEM INT= 2572
			DECLARE @CLIENT_ITEM INT= 2009
			DECLARE @COMMCELL_ENTITY INT= 1
			DECLARE @CLIENT_ENTITY INT= 3
			DECLARE @CLIENT_GROUP_ENTITY INT= 28
			DECLARE @COMM_CELL_ITEM INT= 2018					
			DECLARE @CAT_ANALYTICS_FILE INT= 134
			DECLARE @CAT_ANALYTICS_EMAIL  INT= 135
			DECLARE @EV_BROWSE INT= 13
			DECLARE @EV_BROWSE_CAP INT= CAST(POWER(2.0, (@EV_BROWSE-1)) as BIGINT)
			DECLARE @EV_RUN_REPORTS INT= 15
			DECLARE @EV_RUN_REPORTS_CAP INT= CAST(POWER(2.0, (@EV_RUN_REPORTS-1)) as BIGINT)
		

			--FILE & EMAIL ANALYTICS
			DECLARE @newAnalyticsRoleTbl TABLE ( newPermId INt)
			INSERT INTO @newAnalyticsRoleTbl
			VALUES (@CAT_ANALYTICS_FILE), (@CAT_ANALYTICS_EMAIL)
	
			DECLARE @systemOWnerCapabilities BIGINT = ISNULL(( select value from GXGlobalParam where name like 'SystemOwnerCapibilities'),0)			
			IF object_id('tempdb.dbo.#OwnerUserAndGrpWithBrowse') IS NOT null DROP TABLE #OwnerUserAndGrpWithBrowse
			CREATE TABLE #OwnerUserAndGrpWithBrowse(groupId INT, userId INT, providerId INT, entityId INT, entityType INT)			

			IF object_id('tempdb.dbo.#OwnerUserAndGrpWithReports') IS NOT null DROP TABLE #OwnerUserAndGrpWithReports
			CREATE TABLE #OwnerUserAndGrpWithReports(groupId INT, userId INT)			

			IF object_id('tempdb.dbo.#OwnerUserAndGrpBothPermission') IS NOT null DROP TABLE #OwnerUserAndGrpBothPermission
			CREATE TABLE #OwnerUserAndGrpBothPermission(groupId INT, entityId INT, entityType INT)			

			/*Logic

			1.	Get list A of all groups/ user having Browse and client/client group/commcell. ( via  UMGroupAssociation and Client owners)  ( you can insert allAssocition=1 and allCapabilities=0) as commcell level association.
			2.	Get list B of all group/user having report management  ( union of UMgroupAssoc and client owners) ( you dont need to save clientId in this case)
			3.	Get list C of common user group in 1 and 2  and insert into new security association table.
			4.	Delete users from list A got which are member of list C groups. ( as they are already handled)
			5.	Now  get list D of users which are in A and expand list A-C group to users.   ( these are users which  have browse on client/client group/commcell, so now we just need to see if these users have report management somewhere)
			6.	Insert into UMSecurityAssociation  the users in list D which are in B or member of user group B
			*/

			--1.EV_BROWSE 
			--get list 'A' of all users & usergroups having Browse capability at Client /Client group/System level
				--1.a get all users & usersgroup having Browse capability for owners
					INSERT INTO #OwnerUserAndGrpWithBrowse (groupId, userId, providerId, entityId, entityType)			
					SELECT groupId, userId, providerId, objectId, @CLIENT_ENTITY
					FROM UMUserandGroupEntityAssociation 			
					WHERE entityType= @CLIENT_ITEM  And 
								((capabilities & @EV_BROWSE_CAP <>0) 
									OR  (	@systemOWnerCapabilities & @EV_BROWSE_CAP<>0 ) 
								OR    ( objectId in 
										  (		SELECT clientId 
												from  APP_ClientGroupAssoc 
												where clientGroupId in 
													(	select objectId 
														from UMUserandGroupEntityAssociation 
														where entityType=@SERVER_GROUP_NAME_ITEM and capabilities & @EV_BROWSE_CAP<>0 and userid = 0 and groupId = 0
													)
										   )
									 ))
									 and (userId <>0 OR groupId<>0)									 
									 AND groupId NOT IN (SELECT id FROM UMGroups WHERE allCapabilities =1 and allassociations =1)							
					UNION ALL
					--1.b get all usersgroup having Browse capability at group level other than allassociations=1
						SELECT distinct gc1.groupId,  0 ,0, id1,  (case when ga.type1 = @CLIENT_ITEM then @CLIENT_ENTITY  
																		 when ga.type1 = @SERVER_GROUP_NAME_ITEM then @CLIENT_GROUP_ENTITY   
																		 when ga.type1 = @COMM_CELL_ITEM then @COMMCELL_ENTITY
														 				 end )
						FROM UMGroupCapability GC1 				
						INNER JOIN UMGroupAssociation GA ON GC1.groupId = GA.groupId				
						WHERE  GC1.groupId NOT IN (SELECT id FROM UMGroups WHERE (allCapabilities =1 and allassociations =1)) 
						AND ( (GC1.capabilityId = @EV_BROWSE OR GC1.groupId IN (SELECT id FROM UMGroups WHERE allCapabilities =1 and allassociations =0) )
								and ga.type1 IN  ( @CLIENT_ITEM, @SERVER_GROUP_NAME_ITEM, @COMM_CELL_ITEM) AND type2=0 and type3=0 and type4=0 )
						AND GC1.groupId not IN (SELECT id FROM UMGroups WHERE allCapabilities =0 and allassociations =1)
					UNION ALL
					--1.c get all usersgroup having Browse capability at group level for allassociations =1
						SELECT distinct gc1.groupId,  0 ,0, 2,  @COMMCELL_ENTITY														 
						FROM UMGroupCapability GC1 									
						WHERE  GC1.groupId NOT IN (SELECT id FROM UMGroups WHERE (allCapabilities =1 and allassociations =1)) 
						AND (GC1.capabilityId = @EV_BROWSE AND GC1.groupId IN (SELECT id FROM UMGroups WHERE allCapabilities =0 and allassociations =1) )
						

			--2.EV_RUN_REPORTS 
			--get list 'B' of all users & usersgroup having Reports capability at Any level 
				INSERT INTO #OwnerUserAndGrpWithReports (groupId, userId)
				SELECT groupId, userId
				FROM UMUserandGroupEntityAssociation 			
				WHERE entityType= @CLIENT_ITEM  And 
							((capabilities & @EV_RUN_REPORTS_CAP <>0) 
								OR  (	@systemOWnerCapabilities & @EV_RUN_REPORTS_CAP<>0 ) 
							OR    ( objectId in 
									  (		SELECT clientId 
											from  APP_ClientGroupAssoc 
											where clientGroupId in 
												(	select objectId 
													from UMUserandGroupEntityAssociation 
													where entityType=@SERVER_GROUP_NAME_ITEM and capabilities & @EV_RUN_REPORTS_CAP<>0 and userid = 0 and groupId = 0
												)
									   )
								 ))
								 and (userId <>0 OR groupId<>0)								
								AND groupId NOT IN (SELECT id FROM UMGroups WHERE (allCapabilities =1 and allassociations =1)) 								
				UNION ALL
					SELECT distinct gc1.groupId,  0 
					FROM UMGroupCapability GC1 										
					WHERE  GC1.groupId NOT IN (SELECT id FROM UMGroups WHERE (allCapabilities =1 and allassociations =1)) 
					AND  (GC1.capabilityId = @EV_RUN_REPORTS OR GC1.groupId IN (SELECT id FROM UMGroups WHERE allCapabilities =1 and allassociations =0) )
			
			--MR 147515: Analytics permission not set properly for External Domain Group/User after upgrade
				INSERT INTO #OwnerUserAndGrpWithBrowse (groupId, userId, providerId, entityId, entityType)			
				SELECT DISTINCT  ds.umDSgroupId , 0 ,0,entityId, entityType
				FROM UMDSGroupMaps DS 
					INNER JOIN #OwnerUserAndGrpWithBrowse B ON B.groupId =DS.umgroupId 

				INSERT INTO #OwnerUserAndGrpWithReports (groupId, userId)
				SELECT DISTINCT  DS.umDSgroupId , 0 
				FROM UMDSGroupMaps DS 
					INNER JOIN #OwnerUserAndGrpWithReports R ON R.groupId =DS.umgroupId 
				---

			--3. BOTH REPORTS & BROWSE Capability for usergroup
			   --3.a get list 'C' of all common usergroups having both Browse + Reports capability
				INSERT INTO #OwnerUserAndGrpBothPermission
				SELECT B.groupId, B.entityId, B.entityType
				FROM #OwnerUserAndGrpWithBrowse B 
						INNER JOIN #OwnerUserAndGrpWithReports R ON B.groupid = R.groupid  
								AND B.userId = 0 AND R.userId =0

			   --3.b. insert usergroup having BOTH capabilities into UMSecurityAssociations
				INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)
				SELECT DISTINCT newPermId, groupId, 0, entityType,entityId, 1
				FROM #OwnerUserAndGrpBothPermission 
				CROSS JOIN @newAnalyticsRoleTbl
				WHERE  newPermId  NOT IN (SELECT permissionId
														FROM UMSecurityAssociations 
														WHERE userOrGroupId = groupId
															  AND isuser = 0
															  AND permissionId in (newPermId)   
															  AND entityType1 = entityType AND entityId1 = entityId
															  AND entityType2 = 0 AND entityId2 = 0 
															  AND entityType3 = 0 AND entityId3 = 0
															  AND entityType4 = 0 AND entityId4 = 0 
															  AND entityType5 = 0 AND entityId5 = 0 AND isCreator = 0)
			
				
			--4.a Delete common usergroup from 'A' which are already handled
			DELETE T
			FROM #OwnerUserAndGrpWithBrowse T 
				INNER JOIN #OwnerUserAndGrpBothPermission C ON T.groupId = C.groupId 	

			--4.b. Delete users from list A got which are member of list C groups.( as they are already handled)
			DELETE T
			FROM #OwnerUserAndGrpWithBrowse T 
				INNER JOIN UMUserGroup UG WITH (NOLOCK) ON T.userId = UG.userId
				INNER JOIN #OwnerUserAndGrpBothPermission C ON UG.groupId = C.groupId 		

			--5. Now  get list D of users which are in A and expand list A-C group to users. 
			--( these are users which  have browse on client/client group/commcell, so now we just need to see if these users have report management somewhere)
			--expend usergroup for 'A' to individual users
			IF EXISTS (SELECT 1 FROM #OwnerUserAndGrpWithBrowse WHERE groupId <> 0 AND userId=0)
			BEGIN
				INSERT INTO #OwnerUserAndGrpWithBrowse (groupId, userId, providerId,  entityId, entityType)
				SELECT distinct Ug.groupid, UG.userId, T.providerId, T.entityId, T.entityType
				FROM #OwnerUserAndGrpWithBrowse T 
					INNER JOIN UMUserGroup UG WITH (NOLOCK) ON T.groupId = UG.groupId AND T.userId=0
				WHERE UG.userId not in (SELECT userId FROM #OwnerUserAndGrpWithBrowse)
			END

			--6. Insert into UMSecurityAssociation  the users in list D which are in B or member of user group B			
			INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)	
			SELECT DISTINCT newPermId, B.userId, 1, B.entityType, B.entityId, 1
			FROM #OwnerUserAndGrpWithBrowse B
				INNER JOIN #OwnerUserAndGrpWithReports R ON (B.userId = R.userId AND  R.groupid =0) 
				CROSS JOIN @newAnalyticsRoleTbl
				WHERE  newPermId  NOT IN (SELECT permissionId
												FROM UMSecurityAssociations 
													WHERE userOrGroupId = B.userId
														  AND isuser = 1
														  AND permissionId in (newPermId)   
														  AND entityType1 = B.entityType AND entityId1 = B.entityId
														  AND entityType2 = 0 AND entityId2 = 0 
														  AND entityType3 = 0 AND entityId3 = 0
														  AND entityType4 = 0 AND entityId4 = 0 
													  AND entityType5 = 0 AND entityId5 = 0 AND isCreator = 0)
			UNION
			SELECT DISTINCT newPermId, B.userId, 1, B.entityType, B.entityId, 1
			FROM #OwnerUserAndGrpWithBrowse B
				INNER JOIN UMUserGroup UG ON B.userId = UG.userId
				INNER JOIN #OwnerUserAndGrpWithReports R ON R.groupId = UG.groupId   --member of group
				CROSS JOIN @newAnalyticsRoleTbl
				WHERE  newPermId  NOT IN (SELECT permissionId
												FROM UMSecurityAssociations 
													WHERE userOrGroupId = B.userId
														  AND isuser = 1
														  AND permissionId in (newPermId)   
														  AND entityType1 = B.entityType AND entityId1 = B.entityId
														  AND entityType2 = 0 AND entityId2 = 0 
														  AND entityType3 = 0 AND entityId3 = 0
														  AND entityType4 = 0 AND entityId4 = 0 
													  AND entityType5 = 0 AND entityId5 = 0 AND isCreator = 0)
			
				IF object_id('tempdb.dbo.#OwnerUserAndGrpWithBrowse') IS NOT null DROP TABLE #OwnerUserAndGrpWithBrowse
				IF object_id('tempdb.dbo.#OwnerUserAndGrpWithReports') IS NOT null DROP TABLE #OwnerUserAndGrpWithReports
				IF object_id('tempdb.dbo.#OwnerUserAndGrpBothPermission') IS NOT null DROP TABLE #OwnerUserAndGrpBothPermission	
	END	
END

