----------FIGURE OUT ALL CLIENTS WHERE ANALYTICS ENGINE IS CONFIGURE-----
----------CREATE PSEUDO CLIENTS FOR EACH SUCH CLIENTS----------------

SET QUOTED_IDENTIFIER ON

DECLARE @SIM_ID_GX_REL110	INT =16
DECLARE @analyticsServerUpgrade INT = 0

DECLARE @analyticsServerVersion varchar(36) = '8EB62A40-9CD5-402E-A790-9EAAA84812D1'
	 
SELECT @analyticsServerUpgrade = 1
FROM GXUniqueSQLScriptExecTracking GS WITH(NOLOCK)
WHERE GS.SqlScriptGUID = @analyticsServerVersion
	 
IF (@analyticsServerUpgrade = 0)            -- not done, do the db upgrade
BEGIN   

	DECLARE @analyticsClients TABLE (t_clientId INT, t_clientName NVARCHAR(2048), t_hostName NVARCHAR(2048))
 
	--GET ALL CLIENTS WHERE ANALYTICS ENGINE IS CONFIGURED
	INSERT INTO @analyticsClients (t_clientId, t_clientName, t_hostName)
	SELECT DISTINCT componentNameId, name, C.net_hostname
	FROM APP_ClientProp CP WITH (NOLOCK)
	INNER JOIN APP_Client C ON CP.componentNameId = C.id
	INNER JOIN DM2SearchServerCoreInfo S ON C.id =S.ClientId
	INNER JOIN DM2CloudCoreRole CR ON CR.CloudId = S.CloudId
	WHERE attrName = 'AnalyticSearchEngineEnabled' AND attrVal ='1' AND cp.modified = 0 and C.ID =15

	--DELETE ALREADY UPGRADED SOLR INDEX SERVERS OR NEW SERVERS
	DELETE T
	FROM @analyticsClients T
	INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CAST (CP.attrVal AS INT) = T.t_clientId
	WHERE attrName = 'Index Server ClientId' AND cp.modified = 0 

	DECLARE @psuedoClientId INT  = 0
	DECLARE @psuedoInstanceId INT  = 0
	DECLARE @psuedoBackupsetId INT  = 0
	DECLARE @psuedoAppId INT  = 0
	DECLARE @idxServerClientId INT  = 0
	DECLARE @psuedoClientName NVARCHAR(2048)  = N''
	DECLARE @idxSvrClientName NVARCHAR(2048)  = N''
	DECLARE @idxSvrHostName NVARCHAR(2048)  = N''
	DECLARE @curTime INT 
	SET @curTime  = datediff(second, '01/01/1970', GETDATE())

	BEGIN TRY
	BEGIN TRAN
	DECLARE GetIncrementalCur CURSOR
		FOR select t_clientId, t_clientName , t_hostName from @analyticsClients

		OPEN GetIncrementalCur
		FETCH NEXT FROM GetIncrementalCur INTO @idxServerClientId, @idxSvrClientName, @idxSvrHostName

		--CREATE PSEUDO CLIENTS FOR EACH ANALYTICS ENGINE
		WHILE @@FETCH_STATUS=0 
		BEGIN			
			SET @psuedoClientName = @idxSvrClientName + '_AnalyticsServer'

			--CLIENT
			INSERT INTO APP_Client (name, simOperatingSystemId, net_hostname, refTime, client_password, releaseId,origCCId,GUID,specialClientFlags,displayName, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort, evmgrcPort, status, spaceCheckFlags)       
			SELECT  @psuedoClientName,	0, @psuedoClientName , @curTime,	'3cfe3eeb854e8aa64e0155bec019674d5',	16,	2	, NEWID() , 2, @psuedoClientName, @curTime, 0, 0, N'', N'',  N'', 0, 0, 0, 0, 0
				
			SET @psuedoClientId = ISNULL((SELECT TOP 1 id FROM APP_Client WHERE NAME = @psuedoClientName),0)				
			IF @psuedoClientId >0
			BEGIN							
				INSERT INTO APP_ClientProp (componentNameId,attrName,attrType, attrVal,created, modified)
				VALUES	(@psuedoClientId,	'Distributed iDA Client',	2,	1,	@curTime,0),
						(@psuedoClientId,	'Index Server Type',		7	, 6	,@curTime	,0),
						(@psuedoClientId,	'Index Server ClientId',	7,	@idxServerClientId,	@curTime,0),
						(@psuedoClientId,	'IndexingV2',			2	,1,	@curTime,0),
						(@psuedoClientId,	'SP Version Info',		1,	11,	@curTime,0)

				--INSTANCE
				INSERT INTO APP_InstanceName (name, status, origCCId,GUID, refTime, modified)
				VALUES ('defaultInstanceName',	0,	2, NEWID(), @curTime, @curTime)
				SET @psuedoInstanceId = @@IDENTITY

				
				INSERT INTO APP_InstanceProp (componentNameId,attrName, attrType, attrVal,created, modified)
				VALUES (@psuedoInstanceId , 'Distributed Cluster Type',	7,	6,	@curTime,0),
				(@psuedoInstanceId,	'Solr Index Client Id',	10,	@idxServerClientId	,@curTime,0	)

				--BACKUPSET
				INSERT INTO APP_BackupSetName (name, status, origCCId,GUID,refTime, modified)
				VALUES ('defaultBackupSet',	8,	2, NEWID(), @curTime, @curTime)
				SET @psuedoBackupsetId = @@IDENTITY

				--SUBCLIENT
				INSERT INTO APP_Application (clientId,appTypeId,instance,backupSet,subclientName,subclientStatus,origCCId,GUID,appNumber, dataArchGrpID,logArchGrpID, refTime, modified)
				VALUES ( @psuedoClientId,	64	,@psuedoInstanceId,	@psuedoBackupsetId,	'default',	8	,2,	NEWID(), 0,1,1, @curTime,@curTime)
				SET @psuedoAppId = (SELECT id FROM APP_Application WHERE clientId = @psuedoClientId)

				--IDA
				INSERT INTO APP_IDAName (clientId, appTypeId, status, refTime, modified)
				VALUES (@psuedoClientId,	64,	0, 0 , @curTime)

				--CONTENTS
				INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified)
				SELECT DISTINCT  @psuedoAppId,  1, '\%'+ RM.roleTypeName +'%', @curTime, 0
				FROM DM2CloudCoreRole CR WITH (NOLOCK)
				INNER JOIN DM2CloudRoleMaster RM WITH (NOLOCK) ON CR.roleId =RM.roleType
				INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CR.CloudId =S.CloudId AND S.ClientId = @idxServerClientId


				--ACCESS NODES
				DECLARE @dataAccessNode NVARCHAR(2048) = N'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_DataAccessNodes><dataAccessNodes _type_="3" clientId="'+ CAST (@idxServerClientId AS nvarchar(20))  +'" clientName="' + @idxSvrClientName +'" hostName="'+ @idxSvrHostName +'"/></App_DataAccessNodes>'
			
				INSERT INTO APP_SubClientProp (componentNameId,attrName, attrType, attrVal,created, modified)
				VALUES (@psuedoAppId , 'Solr Index Client Id',	10,	@dataAccessNode,	@curTime, 0)

				--PLATFORM
				INSERT INTO APP_Platform
				VALUES (@psuedoClientId,	4,	'N/A',	0)

				--JOB ACTIVITY
				INSERT INTO JMJobAction
				VALUES (@psuedoClientId,	1,	0,	4,	2,	1,	0,	0,	0,	0,	1),
						(@psuedoClientId,	1,	0,	5,	2,	1,	0,	0,	0,	0,	1),
						(@psuedoClientId,	1,	0,	57,	2,	1,	0,	0,	0,	0,	1),
						(@psuedoClientId,	1,	64,	4,	2,	1,	0,	0,	0,	0,	1),
						(@psuedoClientId,	1,	64,	5,	2,	1,	0,	0,	0,	0,	1)
			END

			FETCH NEXT FROM GetIncrementalCur INTO @idxServerClientId, @idxSvrClientName, @idxSvrHostName
		END

		CLOSE GetIncrementalCur
		DEALLOCATE GetIncrementalCur	
		
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
		VALUES(@analyticsServerVersion, 'SCPAnalyticsServerUpgrade', 'Upgrade analytics server', datediff(second, '01/01/1970', GETDATE()), @SIM_ID_GX_REL110, 0 , (@SIM_ID_GX_REL110 + 1))
		
	COMMIT TRAN
	END TRY
	BEGIN CATCH
		ROLLBACK TRAN
		SELECT @@ERROR, ERROR_MESSAGE()
	END CATCH	
END

