SET NOCOUNT ON
BEGIN

	IF(dbo.isNewSecurity()<>0)
	BEGIN

		DECLARE @userGroupId INTEGER
		DECLARE @errorCode INTEGER=0
		DECLARE @errorString NVARCHAR(1024)
		--upgrade form 10.0 11.0 older builds
		DECLARE @oldRelease NVARCHAR(40)= ISNULL((SELECT value from GXGlobalParam WHERE name='OldReleaseNumber' AND modified=0),'Unknown')
		IF(@oldRelease='9.0' OR @oldRelease='10.0' OR @oldRelease='9' OR @oldRelease='10')
		BEGIN
			IF ( NOT EXISTS(SELECT value FROM GXGlobalParam WHERE name='isOldSecurityUpgraded' and value ='1'))
			BEGIN
				EXEC sec_upgradeOldSecurity @errorCode OUTPUt, @errorString OUTPUT
				IF(@errorCode<>0)
				BEGIN					
					RAISERROR (@errorString,16,1)			
				END
				IF EXISTS (SELECT * FROM GXGlobalParam WHERE name='isOldSecurityUpgraded')
					UPDATE GXGlobalParam
					set value='1'
					WHERE name='isOldSecurityUpgraded'
				ELSE
					INSERT INTO GXGlobalParam(name,value,created,modified)
					VALUES('isOldSecurityUpgraded','1',datediff(second, '01/01/1970', GetUTCdate()),0)
			END	
		END	

		EXEC sec_upgradePermissions @errorCode OUTPUT, @errorString OUTPUT
		IF @errorCode <> 0 
			RAISERROR (@errorString, 16, 1)

	END
END
SET NOCOUNT OFF