DECLARE @CSRelId INT = ISNULL((select MAX(id) from simAllGalaxyRel), 0)
DECLARE @CSRelStr VARCHAR(128)
DECLARE @CSBuildStr VARCHAR(128)
SELECT @CSRelStr = release, @CSBuildStr = buildNum FROM simAllGalaxyRel WHERE id = @CSRelId 
DECLARE @NSAClients TABLE (t_id INT)
INSERT INTO @NSAClients SELECT clientId FROM APP_iDAName WHERE appTypeId IN (13, 88) AND clientId IN (SELECT id FROM APP_Client WHERE releaseId < @CSRelId)
DECLARE @ClientProps TABLE (t_attrName VARCHAR(1024), t_attrVal VARCHAR(1024), t_attrType INT)
INSERT INTO @ClientProps VALUES ('Galaxy Build', 'BUILD' + @CSBuildStr, 1)
INSERT INTO @ClientProps VALUES ('SP Version Info', @CSRelStr, 1)
INSERT INTO @ClientProps VALUES ('Client Version', @CSRelStr + '(BUILD' + @CSBuildStr + ')', 1)

UPDATE APP_Client SET releaseId = @CSRelId WHERE id IN (select t_id from @NSAClients)
UPDATE APP_ClientProp SET attrVal = t_attrVal FROM @ClientProps WHERE attrName = t_attrName AND componentNameId IN (select t_id from @NSAClients)

INSERT	INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT	t_id, t_attrName, t_attrType, t_attrVal, dbo.GetUnixTime(GETUTCDATE()), 0
FROM	@ClientProps CROSS APPLY @NSAClients
		LEFT OUTER JOIN APP_ClientProp PROP ON PROP.componentNameId = t_id AND PROP.attrName = t_attrName
WHERE	PROP.id is NULL
