SET QUOTED_IDENTIFIER ON

IF exists(select * From GXGlobalParam where name = 'OldReleaseNumber' and value = '9.0')
BEGIN
--get clients
DECLARE @clientTable table (clientId int)
INSERT into @clientTable
SELECT clientId from APP_Firewall  where clientId <> 0
UNION
SELECT clientId from APP_FWPortRange  where clientId <> 0 
UNION
SELECT clientId from APP_FirewallOptions  where clientId <> 0 
UNION
SELECT clientId from App_FWOutGoingRoutes  where clientId <> 0 


--get clients groups
DECLARE @clientGroupTable table (clientGroupId int)
INSERT into @clientGroupTable
SELECT clientGroupId from APP_Firewall  where clientGroupId <> 0
UNION
SELECT clientGroupId from APP_FWPortRange  where clientGroupId <> 0 
UNION
SELECT clientGroupId from APP_FirewallOptions  where clientGroupId <> 0 
UNION
SELECT clientGroupId from App_FWOutGoingRoutes  where clientGroupId <> 0 

--update App_FWTrivialConfig for clients
INSERT into App_FWTrivialConfig
SELECT clientid,0,2,0,0,0,0,0,0
FROM @clientTable c where not exists(select * from App_FWTrivialConfig fwg WHERE fwg.clientId = c.clientId)

--update App_FWTrivialConfig for client groups
insert into App_FWTrivialConfig
SELECT 0,clientGroupid,2,0,0,0,0,0,0
FROM @clientGroupTable cg WHERE NOT EXISTS(SELECT * FROM App_FWTrivialConfig fwg WHERE fwg.clientGroupId = cg.clientGroupId)

--update App_FWOutGoingRoutes
UPDATE App_FWOutGoingRoutes
SET fwOutGoingRouteOptions.modify('
    insert attribute clientId {/EVGui_FireWallOutGoingRouteOptions/remoteProxy/@id} as last into
    (/EVGui_FireWallOutGoingRouteOptions/remoteProxy)[1]
')
WHERE (1 != fwOutGoingRouteOptions.exist('/EVGui_FireWallOutGoingRouteOptions/remoteProxy/@clientId'))

UPDATE App_FWOutGoingRoutes SET fwOutGoingRouteOptions.modify('
    insert attribute clientName {/EVGui_FireWallOutGoingRouteOptions/remoteProxy/@name} as last into
    (/EVGui_FireWallOutGoingRouteOptions/remoteProxy)[1]
')
WHERE (1 != fwOutGoingRouteOptions.exist('/EVGui_FireWallOutGoingRouteOptions/remoteProxy/@clientName'))


UPDATE App_FWOutGoingRoutes SET fwOutGoingRouteOptions.modify('
  delete /EVGui_FireWallOutGoingRouteOptions/remoteProxy/@name
')


update App_FWOutGoingRoutes set fwOutGoingRouteOptions.modify('
  delete /EVGui_FireWallOutGoingRouteOptions/remoteProxy/@id
')

update App_FWOutGoingRoutes SET fwOutGoingRouteOptions =  CONVERT(XML,REPLACE(CONVERT(NVARCHAR(MAX),fwOutGoingRouteOptions),'EVGui_FireWallOutGoingRouteOptions','App_FireWallOutGoingRouteOptions'))
END